<?php
/**
 * データアクセスオブジェクト
 */

require_once dirname(__FILE__).'/DAO_kiou_base.php';

class DAO_kiou_adult extends DAO_kiou_base
{
    protected $table = 'kiou_adult';
    protected $pkey  = 'kiou_adult_id';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetchNewest_BY_card_number($card_number)
    {
        $this->manipulator->select(' * ');
        $this->manipulator->where(array(
            'card_number' => $card_number, 
        ));
        $this->manipulator->orderBy(array(
            $this->pkey => 'DESC',
        ));
        return $this->manipulator->fetch();
    }



    public function insert(Array $p)
    {
        $this->manipulator->columns(
            'answer_code', 'card_number', 'serialized_data', 'diseases', 'reg_datetime', 'doctor_id'
        );
        $this->manipulator->values(array(
            'answer_code'  => $p['answer_code'], 
            'card_number'  => $p['card_number'], 
            'serialized_data' => $p['serialized_data'], 
            'diseases'        => $p['diseases'], 
            'reg_datetime'    => $p['reg_datetime'], 
            'doctor_id'       => isset($p['doctor_id']) ? $p['doctor_id'] : NULL, 
        ));
       return $this->manipulator->insert();
    }

    /*public function insert(Array $p)
    {
        $this->manipulator->columns(
            'answer_code', 'card_number', 'q1', 'q2', 'q2_a', 'q2_b', 'q2_c', 'q3', 'q3_text', 'q4', 'q4_yes', 
            'q5', 'q5_a', 'q5_a_text', 'q6', 'q7', 'q7_yes_a', 'q7_yes_b', 'q8', 'q8_yes_a', 'q8_yes_b', 
            'q9', 'q9_yes_a', 'q9_yes_b', 'q10', 'q10_yes_a', 'q10_yes_b', 'q10_yes_c', 'q10_yes_d', 'q10_yes_e', 
            'q11', 'q11_yes_a', 'q11_yes_b', 'q12', 'q12_yes', 'q13', 'q13_yes', 'q14', 'q14_yes', 'q15', 'q15_yes', 
            'q16', 'q16_yes', 'q17', 'q17_text', 'q18', 'q18_text', 'reg_datetime'
        );
        $this->manipulator->values(array(
            'answer_code'  => $p['answer_code'], 
            'card_number'  => $p['card_number'], 
            'q1'           => $p['q1'], 
            'q2'           => $p['q2'], 
            'q2_a'         => $p['q2_a'], 
            'q2_b'         => $p['q2_b'], 
            'q2_c'         => $p['q2_c'], 
            'q3'           => $p['q3'], 
            'q3_text'      => $p['q3_text'], 
            'q4'           => $p['q4'], 
            'q4_yes'       => $p['q4_yes'], 
            'q5'           => $p['q5'], 
            'q5_a'         => $p['q5_a'], 
            'q5_a_text'    => $p['q5_a_text'], 
            'q6'           => $p['q6'], 
            'q7'           => $p['q7'], 
            'q7_yes_a'     => $p['q7_yes_a'], 
            'q7_yes_b'     => $p['q7_yes_b'], 
            'q8'           => $p['q8'], 
            'q8_yes_a'     => $p['q8_yes_a'], 
            'q8_yes_b'     => $p['q8_yes_b'], 
            'q9'           => $p['q9'], 
            'q9_yes_a'     => $p['q9_yes_a'], 
            'q9_yes_b'     => $p['q9_yes_b'], 
            'q10'          => $p['q10'], 
            'q10_yes_a'    => $p['q10_yes_a'], 
            'q10_yes_b'    => $p['q10_yes_b'], 
            'q10_yes_c'    => $p['q10_yes_c'], 
            'q10_yes_d'    => $p['q10_yes_d'], 
            'q10_yes_e'    => $p['q10_yes_e'], 
            'q11'          => $p['q11'], 
            'q11_yes_a'    => $p['q11_yes_a'], 
            'q11_yes_b'    => $p['q11_yes_b'], 
            'q12'          => $p['q12'], 
            'q12_yes'      => $p['q12_yes'], 
            'q13'          => $p['q13'], 
            'q13_yes'      => $p['q13_yes'], 
            'q14'          => $p['q14'], 
            'q14_yes'      => $p['q14_yes'], 
            'q15'          => $p['q15'], 
            'q15_yes'      => $p['q15_yes'], 
            'q16'          => $p['q16'], 
            'q16_yes'      => $p['q16_yes'], 
            'q17'          => $p['q17'], 
            'q17_text'     => $p['q17_text'], 
            'q18'          => $p['q18'], 
            'q18_text'     => $p['q18_text'], 
            'reg_datetime' => $p['reg_datetime'], 
        ));
       return $this->manipulator->insert();
    }*/

    /*public function update($id, Array $p)
    {
        $this->manipulator->set(array(
            'answer_code'  => $p['answer_code'], 
            'card_number'  => $p['card_number'], 
            'q1'           => $p['q1'], 
            'q2'           => $p['q2'], 
            'q2_a'         => $p['q2_a'], 
            'q2_b'         => $p['q2_b'], 
            'q2_c'         => $p['q2_c'], 
            'q3'           => $p['q3'], 
            'q3_text'      => $p['q3_text'], 
            'q4'           => $p['q4'], 
            'q4_yes'       => $p['q4_yes'], 
            'q5'           => $p['q5'], 
            'q5_a'         => $p['q5_a'], 
            'q5_a_text'    => $p['q5_a_text'], 
            'q6'           => $p['q6'], 
            'q7'           => $p['q7'], 
            'q7_yes_a'     => $p['q7_yes_a'], 
            'q7_yes_b'     => $p['q7_yes_b'], 
            'q8'           => $p['q8'], 
            'q8_yes_a'     => $p['q8_yes_a'], 
            'q8_yes_b'     => $p['q8_yes_b'], 
            'q9'           => $p['q9'], 
            'q9_yes_a'     => $p['q9_yes_a'], 
            'q9_yes_b'     => $p['q9_yes_b'], 
            'q10'          => $p['q10'], 
            'q10_yes_a'    => $p['q10_yes_a'], 
            'q10_yes_b'    => $p['q10_yes_b'], 
            'q10_yes_c'    => $p['q10_yes_c'], 
            'q10_yes_d'    => $p['q10_yes_d'], 
            'q10_yes_e'    => $p['q10_yes_e'], 
            'q11'          => $p['q11'], 
            'q11_yes_a'    => $p['q11_yes_a'], 
            'q11_yes_b'    => $p['q11_yes_b'], 
            'q12'          => $p['q12'], 
            'q12_yes'      => $p['q12_yes'], 
            'q13'          => $p['q13'], 
            'q13_yes'      => $p['q13_yes'], 
            'q14'          => $p['q14'], 
            'q14_yes'      => $p['q14_yes'], 
            'q15'          => $p['q15'], 
            'q15_yes'      => $p['q15_yes'], 
            'q16'          => $p['q16'], 
            'q16_yes'      => $p['q16_yes'], 
            'q17'          => $p['q17'], 
            'q17_text'     => $p['q17_text'], 
            'q18'          => $p['q18'], 
            'q18_text'     => $p['q18_text'], 
        ));
        $this->manipulator->where(array(
            $this->pkey => $id,
        ));
        return $this->manipulator->update();
    }*/



} //-- End of class


