<?php
require_once dirname(__FILE__) . '/Vigenere.php';

class DocCookie
{
    const SESSION_USERNAME = 'doc_user_name_0519';
    const SESSION_USER_ID  = 'doc_user_id_0519';
    const SESSION_USER_DIV = 'doc_user_div_0519';

    const LOGIN_EXPIRE    = 86400; // 登录过期时间
    const CRYPT_KEY       = 'megro-street-child-clinic-doc';

    public static function unsetAll()
    {
        self::unsetUserName();
        self::unsetUserId();
        self::unsetUserDiv();
        session_unset();
    }

    public static function setUserName($user_name)
    {
        $enc = self::encode($user_name, self::CRYPT_KEY);
        $_SESSION[self::SESSION_USERNAME] = [
            'value' => $enc,
            'expire' => time() + self::LOGIN_EXPIRE
        ];
    }

    public static function getUserName()
    {
        if (isset($_SESSION[self::SESSION_USERNAME])) {
            $sessionData = $_SESSION[self::SESSION_USERNAME];
            if ($sessionData['expire'] >= time()) {
                $dec = self::decode($sessionData['value'], self::CRYPT_KEY);
                return $dec;
            }
            self::unsetUserName();
        }
        return '';
    }

    protected static function unsetUserName()
    {
        unset($_SESSION[self::SESSION_USERNAME]);
    }

    public static function setUserId($user_id)
    {
        $enc = self::encode($user_id, self::CRYPT_KEY);
        $_SESSION[self::SESSION_USER_ID] = [
            'value' => $enc,
            'expire' => time() + self::LOGIN_EXPIRE
        ];
    }

    public static function getUserId()
    {
        if (isset($_SESSION[self::SESSION_USER_ID])) {
            $sessionData = $_SESSION[self::SESSION_USER_ID];
            if ($sessionData['expire'] >= time()) {
                $dec = self::decode($sessionData['value'], self::CRYPT_KEY);
                return $dec;
            }
            self::unsetUserId();
        }
        return '';
    }

    protected static function unsetUserId()
    {
        unset($_SESSION[self::SESSION_USER_ID]);
    }

    public static function setUserDiv($user_div)
    {
        $enc = self::encode($user_div, self::CRYPT_KEY);
        $_SESSION[self::SESSION_USER_DIV] = [
            'value' => $enc,
            'expire' => time() + self::LOGIN_EXPIRE
        ];
    }

    public static function getUserDiv()
    {
        if (isset($_SESSION[self::SESSION_USER_DIV])) {
            $sessionData = $_SESSION[self::SESSION_USER_DIV];
            if ($sessionData['expire'] >= time()) {
                $dec = self::decode($sessionData['value'], self::CRYPT_KEY);
                return $dec;
            }
            self::unsetUserDiv();
        }
        return '';
    }

    protected static function unsetUserDiv()
    {
        unset($_SESSION[self::SESSION_USER_DIV]);
    }

    private static function encode($string, $key)
    {
        $string = base64_encode($string);
        return Vigenere::encrypt($string, $key);
    }

    private static function decode($string, $key)
    {
        $ret = Vigenere::decrypt($string, $key);
        return base64_decode($ret);
    }
}

// -- End of class

