<?php
/**
 * フォーム要素クラス
 * 
 * @package Lambda/lib
 * @author  rooth
 * @version 0.0.1
 *
 * PHP version 5
 *
 *<pre>
 *
 * usage: 
 *
 * ---------------
 * select
 * ---------------
 * $fe = new FormElement($RSC_ARR['arr']);
 *  - or -
 * $fe = new FormElement();
 * $fe->setResource($RSC_ARR['arr']);
 *
 * $default = isset($_REQUEST['name']) ? $_REQUEST['name'] : 0;
 * $fe->setDefault($default);
 * $fe->setFirst($key, $val);
 * $fe->setIndexes(array(1, 3, 5), true/false);
 * $fe->setSubstitute(array(0 =&gt; '選択してください'));
 * $fe->setLabelPrefix('接頭辞');
 * $fe->setLabelSuffix('接尾辞');
 * $fe->LFMode(true/false);
 * $fe->sanitize(true/false); //default: true
 * $fe->select('name' [, array opts, str optgroup_prefix]]);
 *
 * ---------------
 * text
 * ---------------
 * $fe = new FormElement();
 * $default = isset($_REQUEST['name']) ? $_REQUEST['name'] : '';
 * $fe->setDefault($default);
 * $fe->readonly(true/false);
 * $fe->LFMode(true/false);
 * $fe->sanitize(true/false); //default: true
 * $fe->text('name' [, array opts]);
 *
 * ---------------
 * textarea
 * ---------------
 * $fe = new FormElement();
 * $default = isset($_REQUEST['name']) ? $_REQUEST['name'] : '';
 * $fe->setDefault($default);
 * $fe->readonly(true/false);
 * $fe->LFMode(true/false);
 * $fe->sanitize(true/false); //default: true
 * $fe->textarea('name' [, array opts]]);
 *
 * ---------------
 * checkbox
 * ---------------
 * &lt;?php
 * $fe = new FormElement(); || $fe = new FormElement('value');
 * $default = (isset($_POST['name']) && $_POST['name'] == '1') ? '1' : '0';
 * $fe->setDefault($default);
 * $fe->LFMode(true/false);
 * $fe->withHidden();
 * $fe->sanitize(true/false); //default: true
 * $fe->checkbox('name' [, array opts]);
 * ?&gt;&lt;label style="cursor:pointer" for="id"&gt;新着のみ検索&lt;/label&gt;
 *
 * ---------------
 * checkboxes
 * ---------------
 * // $RSC_ARR['arr'] = '表示項目' || $RSC_ARR['arr'] = array('表示項目', 'オプション値')
 * $fe = new FormElement($RSC_ARR['arr']);
 *  - or -
 * $fe = new FormElement();
 * $fe->setResource($RSC_ARR['arr']);
 *
 * $default = isset($_REQUEST['name']) ? 1 : array $_REQUEST['name'];
 * $fe->setDefault($default);
 * $fe->setLabelTag('id');
 * $fe->setIndexes(array(1, 3, 5), true/false);
 * $fe->setPrefix('&lt;div class="hoge"&gt;');
 * $fe->setMiddle('...string...');
 * $fe->setSuffix('&lt;/div&gt;');
 * $fe->setPaddingByJquery('hoge'); // jquery のロードと setPrefix()、setSuffix()が必要。
 * $fe->setDelimiter('　');
 * $fe->LFMode(true/false);
 * $fe->withHidden();
 * $fe->sanitize(true/false); //default: true
 * $fe->checkboxes('name' [, array opts, int br]]);
 *
 * ---------------
 * radio
 * ---------------
 * $fe = new FormElement($RSC_ARR['arr']);
 *  - or -
 * $fe = new FormElement();
 * $fe->setResource($RSC_ARR['arr']);
 *
 * $default = isset($_REQUEST['name']) ? 1 : 0;
 * $fe->setDefault($default);
 * $fe->setLabelTag('id');
 * $fe->setIndexes(array(1, 3, 5), true/false);
 * $fe->setPrefix('&lt;div class="hoge"&gt;');
 * $fe->setMiddle('...string...');
 * $fe->setSuffix('&lt;/div&gt;');
 * $fe->setDelimiter('　');
 * $fe->LFMode(true/false);
 * $fe->withHidden();
 * $fe->sanitize(true/false); //default: true
 * $fe->radio('name' [, array opts, int br]]);
 *
 * ---------------
 * request2hidden
 * ---------------
 * $fe = new FormElement();
 * $fe->acceptParams(array('param1', 'param2', ...));
 * $fe->exceptParams(array('param1', 'param2', ...));
 * $fe->LFMode(true/false);
 * $fe->request2hidden();
 *
 * ---------------
 * request2query
 * ---------------
 * $fe = new FormElement();
 * $fe->exceptParams(array('param1', 'param2', ...));
 * $fe->request2query();
 *
 *</pre>
 */

class FormElement
{
    protected static $charset = 'UTF-8';

    protected $default;
    protected $resource;
    protected $first;
    //protected $last; // [todo] setDefault が利かないので未実装
    protected $indexes;
    protected $substitute;
    protected $prefix;
    protected $middle;
    protected $suffix;
    protected $delimiter;
    protected $label_tag;
    protected $label_prefix;
    protected $label_suffix;
    protected $accept_params;
    protected $except_params;
    protected $readonly;
    protected $LF; // [todo] 廃止予定
    protected $with_hidden;
    protected $sanitize;
    protected $dom_class;

    protected function initialize()
    {
        $this->default       = '';
        $this->resource      = '';
        $this->first         = array();
        //$this->last          = array(); // [todo] setDefault が利かないので未実装
        $this->indexes       = array();
        $this->substitute    = array();
        $this->prefix        = '';
        $this->middle        = '';
        $this->suffix        = '';
        $this->delimiter     = '';
        $this->label_tag     = '';
        $this->label_prefix  = '';
        $this->label_suffix  = '';
        $this->accept_params = array();
        $this->except_params = array();
        $this->readonly      = '';
        $this->LF            = ''; // [todo] 廃止予定
        $this->with_hidden   = false;
        $this->hidden_val    = '';
        $this->sanitize      = true;
        $this->dom_class     = '';
    }

    public function __construct($rsc = '')
    {
        $this->initialize();
        if ($rsc !== '') $this->resource = $rsc;
        $this->LFMode(true); // [todo] 廃止予定
    }

    public function setResource($rsc)
    {
        $this->resource = $rsc;
    }
    public function setDefault($mixed)
    {
        $this->default = $mixed;
    }
    public function setFirst($key, $val)
    {
        $this->first = array('key' => $key, 'val' => $val);
    }
    public function setIndexes(Array $arr, $bool = true)
    {
        $this->indexes = $arr;
        $this->indexes_bool = $bool;
    }
    public function setSubstitute(Array $arr)
    {
        $this->substitute = $arr;
    }
    public function setPrefix($str)
    {
        $this->prefix = $str;
    }
    public function setMiddle($str)
    {
        $this->middle = $str;
    }
    public function setSuffix($str)
    {
        $this->suffix = $str;
    }
    public function setDelimiter($str)
    {
        $this->delimiter = $str;
    }
    public function setLabelTag($str)
    {
        $this->label_tag = $str;
    }
    public function setLabelPrefix($str)
    {
        $this->label_prefix = $str;
    }
    public function setLabelSuffix($str)
    {
        $this->label_suffix = $str;
    }
    public function acceptParams(Array $arr)
    {
        $this->accept_params = $arr;
    }
    public function exceptParams(Array $arr)
    {
        $this->except_params = $arr;
    }
    public function readonly($bool)
    {
        $this->readonly = ($bool) ? ' readonly': '';
    }
    // [todo] 廃止予定
    public function LFMode($bool)
    {
        $this->LF = ($bool) ? "\n" : '';
    }
    public function withHidden($val = '')
    {
        $this->with_hidden = true;
        $this->hidden_val  = $val;
    }
    public function sanitize($bool)
    {
        $this->sanitize = $bool;
    }
    public function setPaddingByJquery($dom_class)
    {
        $this->dom_class = $dom_class;
    }

    /**
     *<pre>
     *
     * ---------------
     * select
     * ---------------
     *
     * usage: 
     *
     * <?php
     * $fe = new FormElement($RSC_ARR['arr']);
     *  - or -
     * $fe = new FormElement();
     * $fe->setResource($RSC_ARR['arr']);
     *
     * $default = isset($_REQUEST['name']) ? $_REQUEST['name'] : 0;
     * $fe->setDefault($default);
     * $fe->setFirst($key, $val);
     * $fe->setIndexes(array(1, 3, 5), true/false);
     * $fe->setSubstitute(array(0 => '選択してください'));
     * $fe->setLabelPrefix('接頭辞');
     * $fe->setLabelSuffix('接尾辞');
     * $fe->LFMode(true/false);
     * $fe->sanitize(true/false); //default: true
     * $fe->select('name' [, array opts, str optgroup_prefix]]);
     * ?>
     *
     *</pre>
     */
    public function select($name, Array $opts = array(), $optgroup_prefix = '')
    {
        $buff = '<select name="'.$name.'"';
        foreach ($opts as $k => $v) {
            $buff .= ' '.$k.'="'.$v.'"';
        }
        $buff .= '>'.$this->LF;

        // first
        if ($this->first) {
            $buff .= '<option value="'.$this->first['key'].'">'.$this->first['val'].'</option>'.$this->LF;
        }

        foreach ($this->resource as $k => $v)
        {
            if ($this->sanitize) {
                $v = self::rh($this->label_prefix.$v.$this->label_suffix);
            } else {
                $v = $this->label_prefix.$v.$this->label_suffix;
            }

            // indexes
            if ($this->indexes && in_array($k, $this->indexes) != $this->indexes_bool) continue;

            // substitute
            if ($this->substitute && isset($this->substitute[$k])) {
                $v = $this->substitute[$k];
            }

            if ($optgroup_prefix !== '' && strpos($k, $optgroup_prefix) === 0) {
                $buff .= '<optgroup label="'.$v.'" />'.$this->LF;
            } elseif ($this->default !== '' && $this->default == $k) {
                $buff .= '<option value="'.$k.'" selected="selected">'.$v.'</option>'.$this->LF;
            } else {
                $buff .= '<option value="'.$k.'">'.$v.'</option>'.$this->LF;
            }
        }

        $buff .= '</select>';

        echo $buff;
        $this->initialize();
    }

    /**
     *<pre>
     *
     * ---------------
     * text
     * ---------------
     *
     * usage: 
     *
     * <?php
     * $fe = new FormElement();
     * $default = isset($_REQUEST['name']) ? $_REQUEST['name'] : '';
     * $fe->setDefault($default);
     * $fe->readonly(true/false);
     * $fe->LFMode(true/false);
     * $fe->sanitize(true/false); //default: true
     * $fe->text('name' [, array opts]);
     * ?>
     *
     *</pre>
     */
    public function text($name, Array $opts = array())
    {
        $buff  = '<input type="text" name="'.$name.'"';
        $buff .= ($this->sanitize) ? ' value="'.self::rh($this->default).'"' : ' value="'.$this->default.'"';
        foreach ($opts as $k => $v) {
            $buff .= ' '.$k.'="'.$v.'"';
        }
        $buff .= $this->readonly.' />'.$this->LF;

        echo $buff;
        $this->initialize();
    }

    /**
     *<pre>
     *
     * ---------------
     * textarea
     * ---------------
     *
     * usage: 
     *
     * <?php
     * $fe = new FormElement();
     * $default = isset($_REQUEST['name']) ? $_REQUEST['name'] : '';
     * $fe->setDefault($default);
     * $fe->readonly(true/false);
     * $fe->LFMode(true/false);
     * $fe->sanitize(true/false); //default: true
     * $fe->textarea('name' [, array opts]]);
     * ?>
     *
     *</pre>
     */
    public function textarea($name, Array $opts = array())
    {
        $buff = '<textarea name="'.$name.'"';
        foreach ($opts as $k => $v) {
            $buff .= ' '.$k.'="'.$v.'"';
        }
        $buff .= $this->readonly.'>';
        $buff .= ($this->sanitize) ? self::rh($this->default) : $this->default;
        $buff .= '</textarea>'.$this->LF;

        echo $buff;
        $this->initialize();
    }

    /**
     *<pre>
     *
     * ---------------
     * checkbox
     * ---------------
     *
     * usage: 
     *
     * <?php
     * $fe = new FormElement(); || $fe = new FormElement('value');
     * $default = (isset($_POST['name']) && $_POST['name'] == '1') ? '1' : '0';
     * $fe->setDefault($default);
     * $fe->LFMode(true/false);
     * $fe->withHidden();
     * $fe->sanitize(true/false); //default: true
     * $fe->checkbox('name' [, array opts]);
     * ?><label style="cursor:pointer" for="id">新着のみ検索</label>
     *
     *</pre>
     */
    public function checkbox($name, Array $opts = array())
    {
        $value = ($this->resource !== '') ? $this->resource : 1;
        $value = ($this->sanitize) ? self::rh($value) : $value;
        $buff  = ($this->with_hidden) ? '<input type="hidden" name="'.$name.'" value="0">'.$this->LF : '';
        $buff .= '<input type="checkbox" name="'.$name.'" value="'.$value.'"';
        foreach ($opts as $k => $v) {
            $buff .= ' '.$k.'="'.$v.'"';
        }
        $buff .= ($this->default) ? ' checked="checked" />' : ' />';

        echo $buff;
        $this->initialize();
    }

    /**
     *<pre>
     *
     * ---------------
     * checkboxes
     * ---------------
     *
     * usage: 
     *
     * <?php
     * // $RSC_ARR['arr'] = '表示項目' || $RSC_ARR['arr'] = array('表示項目', 'オプション値')
     * $fe = new FormElement($RSC_ARR['arr']);
     *  - or -
     * $fe = new FormElement();
     * $fe->setResource($RSC_ARR['arr']);
     *
     * $default = isset($_REQUEST['name']) ? 1 : array $_REQUEST['name'];
     * $fe->setDefault($default);
     * $fe->setLabelTag('id');
     * $fe->setIndexes(array(1, 3, 5), true/false);
     * $fe->setPrefix('<div class="hoge">');
     * $fe->setMiddle('...string...');
     * $fe->setSuffix('</div>');
     * $fe->setPaddingByJquery('hoge'); // jquery のロードと setPrefix()、setSuffix()が必要。
     * $fe->setDelimiter('　');
     * $fe->LFMode(true/false);
     * $fe->withHidden();
     * $fe->sanitize(true/false); //default: true
     * $fe->checkboxes('name' [, array opts, int br]]);
     * ?>
     *
     *</pre>
     */
    public function checkboxes($name, Array $opts = array(), $br = '')
    {
        // setPaddingByJquery
        if ($this->dom_class) $this->outputJsCode();


        $buff = '';
        $i = 0;

        $buff .= ($this->with_hidden) ? '<input type="hidden" name="'.$name.'[]" value="'.$this->hidden_val.'" />'.$this->LF : '';

        $tmp = $this->resource;
        foreach ($this->resource as $k => $v)
        {
            next($tmp);

            $v = ($this->sanitize) ? self::rh($v) : $v;

            $str = (is_array($v)) ? $v[0] : $v;

            // indexes
            if ($this->indexes && in_array($k, $this->indexes) != $this->indexes_bool) continue;

            // label for
            if (isset($opts['id'])) {
                $id = $this->label_tag.'_'.$i;
                $str = '<label style="cursor:pointer" for="'.$id.'">'.$str.'</label>';
            }

            $buff .= $this->prefix;
            $buff .= '<input type="checkbox" name="'."{$name}[]".'" value="'.$k.'"';
            foreach ($opts as $key => $val) {
                if ($key === 'id') {
                    $buff .= ' '.$key.'="'.$id.'"';
                } else {
                    $buff .= ' '.$key.'="'.$val.'"';
                }
            }

            $delim = (current($tmp) !== false) ? $this->delimiter : '';

            if (is_array($this->default) && array_search($k, $this->default) !== false) {
                $buff .= ' checked="checked" />'.$this->middle.$str.$this->suffix.$delim.$this->LF;
            } else {
                $buff .= ' />'.$this->middle.$str.$this->suffix.$delim.$this->LF;
            }

            if (is_array($br) && $br) {
                if (in_array($i+1, $br)) $buff .= '<br />'.$this->LF;
            } elseif ($br && (($i+1) % $br === 0)) {
                $buff .= '<br />'.$this->LF;
            }
            $i++;
        }

        echo $buff;
        $this->initialize();
    }

    /**
     *<pre>
     *
     * ---------------
     * radio
     * ---------------
     *
     * usage: 
     *
     * <?php
     * $fe = new FormElement($RSC_ARR['arr']);
     *  - or -
     * $fe = new FormElement();
     * $fe->setResource($RSC_ARR['arr']);
     *
     * $default = isset($_REQUEST['name']) ? 1 : 0;
     * $fe->setDefault($default);
     * $fe->setLabelTag('id');
     * $fe->setIndexes(array(1, 3, 5), true/false);
     * $fe->setPrefix('<div class="hoge">');
     * $fe->setMiddle('...string...');
     * $fe->setSuffix('</div>');
     * $fe->setDelimiter('　');
     * $fe->LFMode(true/false);
     * $fe->withHidden();
     * $fe->sanitize(true/false); //default: true
     * $fe->radio('name' [, array opts, int br]]);
     * ?>
     *
     *</pre>
     */
    public function radio($name, $opts = array(), $br = '')
    {
        $buff = '';
        $i = 0;

        $buff .= ($this->with_hidden) ? '<input type="hidden" name="'.$name.'" value="'.$this->hidden_val.'" />'.$this->LF : '';

        $tmp = $this->resource;
        foreach ($this->resource as $k => $v)
        {
            next($tmp);

            $str = ($this->sanitize) ? self::rh($v) : $v;

            // indexes
            if ($this->indexes && in_array($k, $this->indexes) != $this->indexes_bool) continue;

            // label for
            if (isset($opts['id'])) {
                $id = $this->label_tag.'_'.$i;
                $str = '<label style="cursor:pointer" for="'.$id.'">'.$str.'</label>';
            }

            $buff .= $this->prefix;
            $buff .= '<input type="radio" name="'.$name.'" value="'.$k.'"';
            foreach ($opts as $key => $val) {
                if ($key === 'id') {
                    $buff .= ' '.$key.'="'.$id.'"';
                } else {
                    $buff .= ' '.$key.'="'.$val.'"';
                }
            }

            $delim = (current($tmp) !== false) ? $this->delimiter : '';

            if ($this->default !== '' && $this->default == $k) {
                $buff .= ' checked="checked" />'.$this->middle.$str.$this->suffix.$delim.$this->LF;
            } else {
                $buff .= ' />'.$this->middle.$str.$this->suffix.$delim.$this->LF;
            }

            if (is_array($br) && $br) {
                if (in_array($i+1, $br)) $buff .= '<br />'.$this->LF;
            } elseif ($br && (($i+1) % $br === 0)) {
                $buff .= '<br />'.$this->LF;
            }
            $i++;
        }

        echo $buff;
        $this->initialize();
    }

    /**
     *<pre>
     *
     * ---------------
     * request2hidden
     * ---------------
     *
     * usage: 
     *
     * <?php
     * $fe = new FormElement();
     * $fe->acceptParams(array('param1', 'param2', ...));
     * $fe->exceptParams(array('param1', 'param2', ...));
     * $fe->LFMode(true/false);
     * $fe->request2hidden();
     * ?>
     *
     *</pre>
     */
    public function request2hidden()
    {
        $buff = '';
        foreach ($_REQUEST as $key => $val) {
            // except_params
            if (in_array($key, $this->except_params)) continue;

            if ($this->accept_params) {
                // accept_params
                if (in_array($key, $this->accept_params)) {
                    $buff .= $this->mkHidden($key, $val);
                }
            } else {
                $buff .= $this->mkHidden($key, $val);
            }
        }

        echo $buff;
        $this->initialize();
    }

    /**
     *<pre>
     *
     * ---------------
     * request2query
     * ---------------
     *
     * usage: 
     *
     * <?php
     * $fe = new FormElement();
     * $fe->exceptParams(array('param1', 'param2', ...));
     * $fe->request2query();
     * ?>
     *
     *</pre>
     */
    public function request2query()
    {
        $buff = array();
        foreach ($_REQUEST as $k => $v) {
            // except_params
            if (in_array($k, $this->except_params)) continue;
            $buff[$k] = $v;
        }
        // URLエンコードされたクエリ文字列を生成する
        return http_build_query($buff);
    }



    /**
     * @protected
     */
    protected function mkHidden($key, $mixed)
    {
        $buff = '';
        if (is_array($mixed)) {
            foreach ($mixed as $k => $v) {
                $k = $key.'['.$k.']';
                $v = ($this->sanitize) ? self::rh($v) : $v;
                $buff .= '<input type="hidden" name="'.$k.'" value="'.$v.'" />'.$this->LF;
            }
        } else {
            $mixed = ($this->sanitize) ? self::rh($mixed) : $mixed;
            $buff .= '<input type="hidden" name="'.$key.'" value="'.$mixed.'" />'.$this->LF;
        }

        return $buff;
    }

    /**
     * @protected
     */
    protected function outputJsCode()
    {
echo <<< EOJS
<script type="text/javascript">
$(function(){
    var max = 0;
    var sl = $('.{$this->dom_class}');

    $(sl).css('display', 'inline');
    $(sl).each(function(){
        var w = $(this).width();
        if (w > max) max = w;
    });
    $(sl).each(function(){
        var pad = max - $(this).width();
        $(this).css('padding-right', pad);
    });
});
</script>

EOJS;
    }

    /**
     * recursive htmlspecialchars
     */
    protected static function rh($mixed)
    {
        if(is_array($mixed)) {
            return array_map(array('self', 'rh'), $mixed);
        } else {
            return htmlspecialchars($mixed, ENT_QUOTES, self::$charset);
        }
    }



} // -- End of class


