<?php
/**
 * フォーム要素カスタムクラス 
 */

require_once dirname(__FILE__).'/FormElement.php';

class FormElementCustom extends FormElement
{
    protected $input_type = 'text';

    public function __construct($rsc = '')
    {
        parent::__construct($rsc);
    }

    public function setInputType($input_type)
    {
        $this->input_type = $input_type;
    }

    /**
     * テキストフィールド付きチェックボックス
     */
    public function checkboxesWithTexts($name, Array $opts = array(), $br = '', Array $texts = array())
    {
        // setPaddingByJquery
        if ($this->dom_class) $this->outputJsCode();


        $buff = '';
        $i = 0;

        $buff .= ($this->with_hidden) ? '<input type="hidden" name="'.$name.'[]" value="'.$this->hidden_val.'" />'.$this->LF : '';

        $tmp = $this->resource;
        foreach ($this->resource as $k => $v)
        {
            next($tmp);

            $v = ($this->sanitize) ? self::rh($v) : $v;

            $str = (is_array($v)) ? $v[0] : $v;

            // indexes
            if ($this->indexes && in_array($k, $this->indexes) != $this->indexes_bool) continue;

            // label for
            if (isset($opts['id'])) {
                $id = $this->label_tag.'_'.$i;
                $str = '<label style="cursor:pointer" for="'.$id.'">'.$str.'</label>';
            }

            $buff .= $this->prefix;
            $buff .= '<input type="checkbox" name="'."{$name}[{$i}]".'" value="'.$k.'"';
            foreach ($opts as $key => $val) {
                if ($key === 'id') {
                    $buff .= ' '.$key.'="'.$id.'"';
                } else {
                    $buff .= ' '.$key.'="'.$val.'"';
                }
            }

            //$delim = (current($tmp) !== false) ? $this->delimiter : '';
            $delim = $this->delimiter;

            if (is_array($this->default) && array_search($k, $this->default) !== false) {
                $buff .= ' checked="checked" />'.$this->middle.$str.$this->suffix.$delim.$this->LF;
            } else {
                $buff .= ' />'.$this->middle.$str.$this->suffix.$delim.$this->LF;
            }

            if (isset($texts[$k])) {
                $buff .= '<input type="'.$this->input_type.'" name="'.$name.'_text['.$i.']" value="'.$texts[$k].'">';
            } else {
                $buff .= '<input type="'.$this->input_type.'" name="'.$name.'_text['.$i.']" value="">';
            }

            if ($br && (($i+1) % $br === 0)) {
                $buff .= '<br />'.$this->LF;
            }
            $i++;
        }

        echo $buff;
        $this->initialize();
    }

    /**
     * 既往歴のチェックボックスと年月プルダウン
     *
     * @depend Date class
     */
    public function kioureki($name, Array $opts = array(), $br = '', $start_year = null, Array $years = array(), Array $months = array())
    {
        require_once 'Date.php';

        // setPaddingByJquery
        if ($this->dom_class) $this->outputJsCode();


        $buff = '';
        $i = 0;

        $buff .= ($this->with_hidden) ? '<input type="hidden" name="'.$name.'[]" value="'.$this->hidden_val.'" />'.$this->LF : '';

        $tmp = $this->resource;
        foreach ($this->resource as $k => $v)
        {
            next($tmp);

            $v = ($this->sanitize) ? self::rh($v) : $v;

            $str = (is_array($v)) ? $v[0] : $v;

            // indexes
            if ($this->indexes && in_array($k, $this->indexes) != $this->indexes_bool) continue;

            // label for
            if (isset($opts['id'])) {
                $id = $this->label_tag.'_'.$i;
                $str = '<label style="cursor:pointer" for="'.$id.'">'.$str.'</label>';
            }

            $buff .= $this->prefix;
            $buff .= '<input type="checkbox" name="'."{$name}[{$i}]".'" value="'.$k.'"';
            foreach ($opts as $key => $val) {
                if ($key === 'id') {
                    $buff .= ' '.$key.'="'.$id.'"';
                } else {
                    $buff .= ' '.$key.'="'.$val.'"';
                }
            }

            //$delim = (current($tmp) !== false) ? $this->delimiter : '';
            $delim = $this->delimiter;

            if (is_array($this->default) && array_search($k, $this->default) !== false) {
                $buff .= ' checked="checked" />'.$this->middle.$str.$this->suffix.$delim.$this->LF;
            } else {
                $buff .= ' />'.$this->middle.$str.$this->suffix.$delim.$this->LF;
            }

            // 年月プルダウン
            if ($v !== 'その他') {
                $buff .= '<span>';
                $buff .= '<select name="'.$name.'_y['.$i.']" style="width:100px">';
                $buff .= '<option value="">--</option>';
                for ($yyyy = $start_year; $yyyy <= date('Y'); $yyyy++) {
                    $wareki = Date::getWareki($yyyy, $yyyy, '%wareki%');
                    $selected = (isset($years[$i]) && (int)$years[$i] === (int)$yyyy) ? ' selected' : '';
                    $buff .= '<option value="' . $yyyy . '"' . $selected . '>' . $wareki[$yyyy]  . '</option>';
                }
                $buff .= '</select>年 ';
                $buff .= '<select name="'.$name.'_m['.$i.']" style="width:80px">';
                $buff .= '<option value="">--</option>';
                for ($mm = 1; $mm <= 12; $mm++) {
                    $selected = (isset($months[$i]) && (int)$months[$i] === (int)$mm) ? ' selected' : '';
                    $buff .= '<option value="' . $mm . '"' . $selected . '>' . $mm  . '</option>';
                }
                $buff .= '</select>月頃から';
                $buff .= '</span>';
            }

            if ($br && (($i+1) % $br === 0)) {
                $buff .= '<br />'.$this->LF;
            }
            $i++;
        }

        echo $buff;
        $this->initialize();
    }


} // -- End of class


