<?php
/**
 * ジャバスクリプト Class
 * 
 * @package Lambda/lib
 * @author  rooth
 * @version 0.0.1
 *
 * PHP version 5
 */

class Javascript
{
    protected static $charset = 'utf-8';

    public static function setCharset($charset)
    {
        self::$charset = $charset;
    }
    public static function getCharset()
    {
        return self::$charset;
    }

    /**
     * location.href='{$href}';
     */
    public static function redirect($href, $msg = '', $bgcolor = '#cccccc')
    {
        echo "<meta http-equiv='content-type' content='text/html; charset=".self::getCharset()."'>";
        echo "<body bgcolor='{$bgcolor}'>";
        echo "<script type='text/javascript'>";
        if ($msg !== '') echo "alert('{$msg}');";
        //echo "location.href='{$href}';"; // FFでパラメータが勝手にエンコードされるので廃止
        echo "</script>";
        echo '<meta http-equiv="Refresh" content="0; URL='.$href.'">';
        exit;
    }

    /**
     * history.back();
     */
    public static function backHistory($msg = '', $bgcolor = '#cccccc')
    {
        echo "<meta http-equiv='content-type' content='text/html; charset=".self::getCharset()."'>";
        echo "<body bgcolor='{$bgcolor}'>";
        echo "<script type='text/javascript'>";
        if ($msg !== '') echo "alert('{$msg}');";
        echo "history.back();";
        echo "</script>";
        exit;
    }

    /**
     * window.location = document.referrer+'{$param}';
     */
    public static function backReferer($msg = '', $param = '', $bgcolor = '#cccccc')
    {
        echo "<meta http-equiv='content-type' content='text/html; charset=".self::getCharset()."'>";
        echo "<body bgcolor='{$bgcolor}'>";
        if ($msg != ''){
            echo "<script type='text/javascript'>alert('$msg');</script>";
        }
        echo "<script type='text/javascript'>window.location = document.referrer+'{$param}';</script>";
        exit;
    }

    /**
     * json_encode
     *
     *   SPEC: 一次元配列のみ
     */
    public static function jsonEncode(Array $arr)
    {
        $buf = array();
        foreach ($arr as $k => $v) {
            $k = self::jsonEscape($k);
            $v = self::jsonEscape($v);
            $buf[] = '"'. $k. '":"'. $v .'"';
        }
        return '{'.implode(',', $buf).'}';
    }
    private static function jsonEscape($v)
    {
        $v = addcslashes($v, '\"');
        $v = str_replace(array("\r", "\n", "\t"), array('\r', '\n', '\t'), $v);
        return $v;
    }

    /**
     * toArray
     *
     *   phpの配列をjsの配列に変換する
     *
     *   SPEC: 一次元配列のみ
     */
    public static function toArray(Array $arr)
    {
        $buf = array();
        foreach ($arr as $v) {
            $v = addcslashes($v, '\"');
            $buf[] = '"'. $v .'"';
        }
        return '['.implode(', ', $buf).']';
    }



} // -- End of class


