<?php
/**
 * Pager Class
 *
 * @package Lambda/lib
 * @author  rooth
 * @version 0.0.1
 *
 * PHP version 5
 * 
 *<pre>
 *
 * [usage]
 * 
 *   === PHP ===
 *   // RPP
 *   define('RPP', 10);
 *   
 *   // ページ番号初期化, offset, limit
 *   $page   = $lmd->getHttpGet('page', 1, '/^[0-9]+$/');
 *   $offset = ($page - 1) * RPP;
 *   $limit  = RPP;
 *   
 *   // get data
 *   $dao = Factory::load('DB/DAO_hoge')->getInstance();
 *   $res = $dao->fetchAll($offset, $limit);
 *   $total_rows = $dao->foundRows();
 *   
 *   // asign Pager
 *   Factory::import('Pager');
 *   $lmd->setResponse(array(
 *       'pager' => Pager::GETParam($page, $limit, $total_rows)
 *   ), Lambda::INSANITATION);
 *   
 *   === HTML ===
 *   <!-- pager -->
 *   <link type="text/css" rel="stylesheet" href="<?= APP_ROOT ?>/css/Pager/skyblue.css">
 *   <div id="pager"><div class="mtop mbot"><?php echo $pager ?></div></div>
 *   <!-- pager -->
 * 
 *   <!-- for PHPDocumentor -->
 *   &lt;!-- pager --&gt;
 *   &lt;link type="text/css" rel="stylesheet" href="&lt;?= APP_ROOT ?&gt;/css/Pager/skyblue.css"&gt;
 *   &lt;div id="pager">&lt;div class="mtop mbot"&gt;&lt;?php echo $pager ?&gt;&lt;/div&gt;&lt;/div&gt;
 *   &lt;!-- pager --&gt;
 *
 *</pre>
 */
class Pager
{
    /**
     * GET パラメータ ぺージャ
     * @param int $page          現在のページ番号(初期値は1)
     * @param int $rows_per_page 1ページに表示するリスト件数
     * @param int $rows_total    合計レコード数
     * @param int $modulus       最大何ページ分のページ番号を並べるか(奇数で定義)
     * @param str $param_name    パラメータ名(変数名)
     * 
     * @return str ページャ文字列(リンク付き)
     *
     * @access public
     * @static
     */ 
    public static function GETParam($page, $rows_per_page, $rows_total, $modulus = 11, $param_name = 'page')
    {
        $page = (ctype_digit((string)$page)) ? $page : 1;
        $modulus = ($modulus % 2 != 0) ? $modulus - 1 : $modulus;
        $page_total = ceil($rows_total / $rows_per_page);

        $regex = '[?&]'.$param_name.'=([0-9]+)?';
        $path = preg_replace("/$regex/", '', $_SERVER['REQUEST_URI']);

        $param = (strpos($path, '?') === false) ? "?{$param_name}=" : "&{$param_name}=";

        $pages = array();
        for ($i = 1; $i <= $page_total; $i++) {
            $pages[$i] = '<a href="' . $path . $param . $i . '">' . $i . '</a>';
        }

        $pager = '';
        for ($i = $page - floor($modulus / 2); $i < $page; $i++) {
            if (isset($pages[$i])) $pager .= $pages[$i];
        }
        $pager .= ($page_total <= 1) ? '' : '<span class="on">'.$page.'</span>';
        for ($i = $page + 1; $i <= $page + floor($modulus / 2); $i++) {
            if (isset($pages[$i])) $pager .= $pages[$i];
        }

        $next_rows = isset($pages[$page + 2]) ? $rows_per_page : $rows_total - ($rows_per_page * $page);
        $prev_label = "&lt;&nbsp;前の{$rows_per_page}件";
        $next_label = "次の{$next_rows}件&nbsp;&gt;";

        $prev = '';
        if (isset($pages[$page - 1])) {
            $prev  = '<a href="' . $path . $param . ($page - 1) . '">';
            $prev .= $prev_label . '</a>&nbsp;&nbsp;';
        }
        $next = '';
        if (isset($pages[$page + 1])) {
            $next  = '&nbsp;&nbsp;<a href="' . $path . $param . ($page + 1) . '">';
            $next .= $next_label . '</a>';
        }

        return $prev . $pager . $next;
    }

    /**
     * SEO ぺージャ
     * @param int $page          現在のページ番号(初期値は1)
     * @param int $rows_per_page 1ページに表示するリスト件数
     * @param int $rows_total    合計レコード数
     * @param int $modulus       最大何ページ分のページ番号を並べるか(奇数で定義)
     * @param arr $defs          パラメータ定義
     * 
     * @return str ページャ文字列(リンク付き)
     *
     * @access public
     * @static
     */ 
    public static function SEO($page, $rows_per_page, $rows_total, $modulus = 11, $defs = array())
    {
        // 下記デフォルト定義は `/path/to/hoge/p_1.html' のような URI で動作する。
        $param_name  = (isset($defs['param_name'])) ? $defs['param_name']   : 'p';     // パラメータ名
        $param_delim = (isset($defs['param_delim'])) ? $defs['param_delim'] : '/';     // パラメータ区切り文字
        $param_join  = (isset($defs['param_join'])) ? $defs['param_join']   : '_';     // パラメータ連結文字
        $extension   = (isset($defs['extension'])) ? $defs['extension']     : '.html'; // 拡張子

        $page = (ctype_digit((string)$page)) ? $page : 1;
        $modulus = ($modulus % 2 != 0) ? $modulus - 1 : $modulus;
        $page_total = ceil($rows_total / $rows_per_page);

        $regex = preg_quote($extension).'$';
        $path = preg_replace("/$regex/", '', $_SERVER['REQUEST_URI']);

        $regex = preg_quote($param_delim.$param_name.$param_join, '/').'([0-9]+)?';
        $path = preg_replace("/$regex/", '', $path);

        $pages = array();
        for ($i = 1; $i <= $page_total; $i++) {
            if ($i === 1) {
                $pages[$i] = '<a href="' . $path . '">' . $i . '</a>';
            } else {
                $pages[$i] = '<a href="' . $path . $param_delim.$param_name.$param_join.($i).$extension . '">' . $i . '</a>';
            }
        }

        $pager = '';
        for ($i = $page - floor($modulus / 2); $i < $page; $i++) {
            if (isset($pages[$i])) $pager .= $pages[$i];
        }
        $pager .= ($page_total <= 1) ? '' : '<span class="on">'.$page.'</span>';
        for ($i = $page + 1; $i <= $page + floor($modulus / 2); $i++) {
            if (isset($pages[$i])) $pager .= $pages[$i];
        }

        $next_rows = isset($pages[$page + 2]) ? $rows_per_page : $rows_total - ($rows_per_page * $page);
        $prev_label = "&lt;&nbsp;前の{$rows_per_page}件";
        $next_label = "次の{$next_rows}件&nbsp;&gt;";

        $prev = '';
        if (isset($pages[$page - 1])) {
            if ($i === 1) {
                $pages[$i] = '<a href="' . $path . '">' . $i . '</a>';
            } else {
                $pages[$i] = '<a href="' . $path . $param_delim.$param_name.$param_join.($i).$extension . '">' . $i . '</a>';
            }
        }
        $next = '';
        if (isset($pages[$page + 1])) {
            $next  = '&nbsp;&nbsp;<a href="' . $path . $param_delim.$param_name.$param_join.($page + 1).$extension . '">';
            $next .= $next_label . '</a>';
        }

        return $prev . $pager . $next;
    }



} // -- End of class


