<?php
/**
 * Pager2 Class
 *
 * @package Lambda/lib
 * @author  rooth
 * @version 0.0.1
 *
 * PHP version 5
 * 
 *<pre>
 *
 * [usage]
 * 
 *   === PHP ===
 *   // RPP
 *   define('RPP', 10);
 *   
 *   // ページ番号初期化, offset, limit
 *   $page   = $lmd->getHttpGet('page', 1, '/^[0-9]+$/');
 *   $offset = ($page - 1) * RPP;
 *   $limit  = RPP;
 *   
 *   // get data
 *   $dao = Factory::load('DB/DAO_hoge')->getInstance();
 *   $res = $dao->fetchAll($offset, $limit);
 *   $total_rows = $dao->foundRows();
 *   
 *   // asign Pager
 *   Factory::import('Pager');
 *   $lmd->setResponse(array(
 *       'pager' => Pager::GETParam($page, $limit, $total_rows)
 *   ), Lambda::INSANITATION);
 *   
 *   === HTML ===
 *   <!-- pager -->
 *   <link type="text/css" rel="stylesheet" href="<?= APP_ROOT ?>/css/Pager/skyblue.css">
 *   <div id="pager"><div class="mtop mbot"><?php echo $pager ?></div></div>
 *   <!-- pager -->
 * 
 *   <!-- for PHPDocumentor -->
 *   &lt;!-- pager --&gt;
 *   &lt;link type="text/css" rel="stylesheet" href="&lt;?= APP_ROOT ?&gt;/css/Pager/skyblue.css"&gt;
 *   &lt;div id="pager">&lt;div class="mtop mbot"&gt;&lt;?php echo $pager ?&gt;&lt;/div&gt;&lt;/div&gt;
 *   &lt;!-- pager --&gt;
 *
 *</pre>
 */
class Pager2
{
    protected static $page;
    protected static $rows_per_page;
    protected static $rows_total;
    protected static $modulus;
    protected static $page_total;

    /**
     * GET パラメータ ぺージャ
     * @param int $page          現在のページ番号(初期値は1)
     * @param int $rows_per_page 1ページに表示するリスト件数
     * @param int $rows_total    合計レコード数
     * @param int $modulus       最大何ページ分のページ番号を並べるか(奇数で定義。5以上)
     * @param array $opt         array(
     *                               'param_name' => パラメータ名, // def: page
     *                               'delimiter'  => ページ番号の区切り文字, // def: ' | '
     *                               'separator'  => 最初/最後ページの区切り文字, // def: ' … '
     *                           )
     * 
     * @return str ページャ文字列(リンク付き)
     *
     * @access public
     * @static
     */ 
    public static function GETParam($page, $rows_per_page, $rows_total, $modulus = 11, Array $opt = array())
    {
        self::init($page, $rows_per_page, $rows_total, $modulus);

        // only 1page: process abort.
        if (self::getPageTotal() < 2) return;

        $param_name = isset($opt['param_name']) ? $opt['param_name'] : 'page';

        $regex = '[?&]'.$param_name.'=([0-9]+)?';
        $uri = preg_replace("/$regex/", '', $_SERVER['REQUEST_URI']);

        $path = (strpos($uri, '?') === false) ? "?{$param_name}=" : "&{$param_name}=";

        return self::pager($path, $opt);
    }

    /**
     * SEO ぺージャ
     * @param int $page          現在のページ番号(初期値は1)
     * @param int $rows_per_page 1ページに表示するリスト件数
     * @param int $rows_total    合計レコード数
     * @param int $modulus       最大何ページ分のページ番号を並べるか(奇数で定義。5以上)
     * @param array $opt         array(
     *                               'param_name' => パラメータ名, // def: 'p'
     *                               'param_name' => パラメータ区切り文字, // def: '/'
     *                               'param_name' => パラメータ連結文字, // def: '_'
     *                               'delimiter'  => ページ番号の区切り文字, // def: ' | '
     *                               'separator'  => 最初/最後ページの区切り文字, // def: ' … '
     *                               'extension'  => 拡張子, // def: '.html'
     *                           )
     * 
     * @return str ページャ文字列(リンク付き)
     *
     * @access public
     * @static
     */
    public static function SEO($page, $rows_per_page, $rows_total, $modulus = 11, Array $opt = array())
    {
        self::init($page, $rows_per_page, $rows_total, $modulus);

        // only 1page: process abort.
        if (self::getPageTotal() < 2) return;

        /**
         * 下記デフォルト定義は `/path/to/hoge/p_1.html' のような URI で動作する。
         */
        $param_name  = isset($opt['param_name']) ? $opt['param_name']   : 'p';     // パラメータ名
        $param_delim = isset($opt['param_delim']) ? $opt['param_delim'] : '/';     // パラメータ区切り文字
        $param_join  = isset($opt['param_join']) ? $opt['param_join']   : '_';     // パラメータ連結文字
        $extension   = isset($opt['extension']) ? $opt['extension']     : '.html'; // 拡張子

        $regex = preg_quote($extension).'$';
        $uri   = preg_replace("/$regex/", '', $_SERVER['REQUEST_URI']);

        $regex = preg_quote($param_delim.$param_name.$param_join, '/').'([0-9]+)?';
        $uri = preg_replace("/$regex/", '', $uri);

        $path = rtrim($uri, '/') . $param_delim . $param_name . $param_join;

        return self::pager($path, $opt, $extension);
    }



    protected static function init($page, $rows_per_page, $rows_total, $modulus)
    {
        self::$page = (ctype_digit((string)$page)) ? $page : 1;
        self::$rows_per_page = $rows_per_page;
        self::$rows_total = $rows_total;
        self::$modulus = ($modulus % 2 === 0) ? $modulus - 1 : $modulus;
        self::$page_total = ceil($rows_total / $rows_per_page);

        // 5未満を認めない
        if (self::$modulus < 5) self::$modulus = 5;
    }

    protected static function getPageTotal()
    {
        return (int)self::$page_total;
    }

    protected static function pager($path, $opt, $extension = '')
    {
        $delimiter = isset($opt['delimiter']) ? $opt['delimiter'] : ' | '; // ページ番号の区切り文字
        $separator = isset($opt['separator']) ? $opt['separator'] : ' … '; // 最初/最後ページの区切り文字

        $delimiter  = htmlspecialchars($delimiter, ENT_QUOTES);
        $separator  = htmlspecialchars($separator, ENT_QUOTES);

        $pages = array();
        $pages[self::$page] = self::$page;
        for ($i = self::$page + 1, $j = self::$page - 1 ; $i <= self::$page + self::$modulus; $i++, $j--) {
            if ($i < self::$page_total + 1) {
                $pages[$i] = '<a href="' . $path . ($i) . $extension . '">' . $i . '</a>';
                if (count($pages) >= self::$modulus) break;
            }
            if ($j > 0) {
                $pages[$j] = '<a href="' . $path . ($j) . $extension . '">' . $j . '</a>';
                if (count($pages) >= self::$modulus) break;
            }
        }

        if (count($pages) === 1) {
            // only 1page: unset;
            $pages = array();
        }

        $next_rows = isset($pages[self::$page + 2]) ? self::$rows_per_page : self::$rows_total - (self::$rows_per_page * self::$page);
        $prev_label = '&lt;&nbsp;前の'.self::$rows_per_page.'件';
        $next_label = "次の{$next_rows}件&nbsp;&gt;";
        $prev = '';
        if (isset($pages[self::$page - 1])) {
            $prev  = '<a href="' . $path . (self::$page - 1) . $extension . '">';
            $prev .= $prev_label . '</a>&nbsp;&nbsp;';
        }
        $next = '';
        if (self::$page != self::$page_total) {
            $next  = '&nbsp;&nbsp;<a href="' . $path . (self::$page + 1) . $extension . '">';
            $next .= $next_label . '</a>';
        }

        $start = '';
        if ($pages && ! isset($pages[1])) {
            $start = '<a href="' . $path . '1' . $extension . '">1</a>' . $separator;
            if (isset($pages[2])) unset($pages[2]);
        }
        $end = '';
        if ($pages && ! isset($pages[self::$page_total])) {
            $end = $separator.'<a href="' . $path . (self::$page_total) . $extension . '">' . self::$page_total . '</a>';
            if (isset($pages[self::$page_total - 1])) unset($pages[self::$page_total - 1]);
        }

        ksort($pages);

        return $prev . $start . implode($delimiter, $pages) . $end . $next;
    }



} // -- End of class


