<?php
/**
 * レスポンス class
 *
 * PHP version 5
 */
class Response
{
    protected $type;
    protected $data;
    protected $output_encoding;
    
    protected $callback;
    
    public function __construct($type, $data)
    {
        $this->type = $type;
        $this->data = $data;
    }
    
    public function setCallback($callback)
    {
        $this->callback = htmlspecialchars($callback, ENT_QUOTES);
    }
    
    public function setOutputEncoding($output_encoding)
    {
        $this->output_encoding = $output_encoding;
    }

    public function execute()
    {
        switch ($this->type) {
            case 'json':
                if ($this->output_encoding) {
                    header("Content-type: application/json; charset={$this->output_encoding}");
                    mb_convert_variables($this->output_encoding, 'utf-8', $this->data);
                    echo self::jsonEncode($this->data);
                } else {
                    header('Content-type: application/json; charset=UTF-8');
                    echo self::jsonEncode($this->data);
                }
                exit;
            
            case 'jsonp':
                if ($this->output_encoding) {
                    header("Content-type: application/javascript; charset={$this->output_encoding}");
                    mb_convert_variables($this->output_encoding, 'utf-8', $this->data);
                    echo "{$this->callback}(".self::jsonEncode($this->data).')';
                } else {
                    header('Content-type: application/javascript; charset=UTF-8');
                    echo "{$this->callback}(".self::jsonEncode($this->data).')';
                }
                exit;
            
            case 'php':
                if ($this->output_encoding) {
                    header("Content-type: text/plain; charset={$this->output_encoding}");
                    mb_convert_variables($this->output_encoding, 'utf-8', $this->data);
                    echo serialize($this->data);
                } else {
                    header('Content-type: text/plain; charset=UTF-8');
                    echo serialize($this->data);
                }
                exit;
                
            default:
                exit('Response: Fatal: invalid response type.');
        }
    }
    
    /**
     * jsonEncode
     */
    private static function jsonEncode(Array $arr)
    {
        return json_encode($arr);
    }



} // --- End of Response class
