<?php

/**
 * Crypt :: Vigenere class
 *
 *  ヴィジュネル暗号 による 暗号化・復号化
 *
 * @package Crypt
 *
 * PHP version 5
 *
 */

class Vigenere
{
    private static $map = array();

    public static function encrypt($string, $key)
    {
        self::$map || self::mkMap();

        $strings = str_split($string, 1);
        $keys    = str_split($key, 1);

        $sc = count($strings);
        $kc = count($keys);
        $mc = count(self::$map);
        $enc = '';
        for ($i = 0; $i < $sc; $i++) {
            $str_idx = array_search($strings[$i], self::$map);
            $key_idx = array_search($keys[$i % $kc], self::$map);
            $enc .= self::$map[($str_idx + $key_idx) % $mc];
        }

        return self::base64_urlencode($enc);
    }

    public static function decrypt($string, $key)
    {
        self::$map || self::mkMap();

        $strings = str_split(self::base64_urldecode($string), 1);
        $keys    = str_split($key, 1);

        $sc = count($strings);
        $kc = count($keys);
        $mc = count(self::$map);
        $dec = '';
        for ($i = 0; $i < $sc; $i++) {
            $str_idx = array_search($strings[$i], self::$map);
            $key_idx = array_search($keys[$i % $kc], self::$map);
            if ($str_idx > $key_idx) {
                $dec .= self::$map[($str_idx - $key_idx) % $mc];
            } else {
                $dec .= self::$map[($str_idx - $key_idx + $mc) % $mc];
            }
        }

        return $dec;
    }

    private static function mkMap()
    {
        self::$map[] = "\t"; 
        self::$map[] = "\n"; 
        self::$map[] = "\r"; 

        
        for ($i = 32; $i < 127; $i++) self::$map[] = chr($i);
    }

    
    private static function base64_urlencode($str)
    {
        $str = base64_encode($str);
        return str_replace(array('+', '/', '='), array('-', '_', ''), $str);
    }

    
    private static function base64_urldecode($str)
    {
        $str = str_replace(array('-', '_'), array('+', '/'), $str);
        $paddig_num = (4 - (strlen($str) % 4)) % 4; 
        return base64_decode($str.str_repeat('=', $paddig_num));
    }



} 


