<?php
//session_start();
/**
 * ラムダ | dispatcher
 *
 * index.php for Lambda
 *
 */

/**
 * Lambda ディレクトリは、このファイルを基準にして何階層上に存在しますか？
 * 
 *    この階層と同じ階層の場合は「0」
 *    1階層上の場合は「1」, 2階層上の場合は「2」, ...
 * 
 *    ※ 0 以上を設定してください。
 * 
 *    [note]
 *    可能であれば、WEBブラウザがアクセスできない階層に Lambda ディレクトリを配置することが推奨されます。
 */
define('LAMBDA_HIERARCHYNUM', 1);

/**
 * このWEBアプリケーションのアプリケーションディレクトリ名(<APP_DIR>)を設定してください。
 * 
 *    /path/to/Lambda/apps/frontend
 *                         ^^^^^^^^
 *    ※ デフォルトは「frontend」です。
 */
define('LAMBDA_APPDIRNAME', 'frontend');

/**
 * キャッシュコントロール
*/
if ( ! getenv('PATH_INFO') && ! getenv('ORIG_PATH_INFO')) {
    // トップページ: キャッシュさせない
    // noop.
} elseif (preg_match('/\/step(4|41|453|5)\/?$/', $_SERVER['REQUEST_URI'])) {
    // 患者側: STEP4/STEP41/STEP453/STEP5 はキャッシュさせない
    // noop.
} elseif (preg_match('/\/doctor/', $_SERVER['REQUEST_URI'])) {
    // ドクター側: キャッシュさせない
    // noop.
} elseif (preg_match('/\/kiou_edit/', $_SERVER['REQUEST_URI'])) {
    // ドクター側/既往修正: キャッシュさせない
    // noop.
} elseif (preg_match('/\/agent\/login/', $_SERVER['REQUEST_URI'])) {
    // 代理入力側ログイン: キャッシュさせない
    // noop.
} else {
    // 上記以外： キャッシュさせる
    //  ⇒ history.back で前回の入力値を復元させるため
    session_cache_limiter('public');
}



/* =============== ▼これ以降は変更の必要はありません =============== */

ini_set('error_reporting', E_ALL);
ini_set('display_errors',  1); // Don't edit
define('LAMBDA_DISPATCHDIR',  dirname(__FILE__));

define('DS', DIRECTORY_SEPARATOR);

/**
 * LAMBDA_BASEDIR
 */
define('LAMBDA_BASEDIR', LAMBDA_DISPATCHDIR.DS.str_repeat('..'.DS, LAMBDA_HIERARCHYNUM).'Lambda');

/**
 * LAMBDA_APPDIR
 */
define('LAMBDA_APPDIR',  LAMBDA_BASEDIR.DS.'apps'.DS.LAMBDA_APPDIRNAME);

/**
 * include Lambda.class.php.
 */
require LAMBDA_BASEDIR.DS.'Lambda.class.php';
