
doKiouAdult = function(DAT, DEF, age)
{
    /** --------------------------------------------------------------------------------------------
     * HTMLレンダリング
     */
    $(function(){
        for (var i in DAT) {
            var v = DAT[i];
            var id   = v.id;
            var type = v.ans_type.toLowerCase();
            var gid  = v.gid;
            var ques_text = v.ques_text;
            var ques_suffix = v.ques_suffix;

            var item_id  = 'ques_item_'+id;
            var label_id = 'label_'+id;
            var input_class = 'input_'+id;
            var input_id = 'input_'+id;
            var ques_text_id = 'ques_text_'+id;

            if (age < 20 && (id == 74 || id == 75 || id == 76)) {
                // 二十歳以上を前提とした質問の為、二十歳未満の場合は表示しない
                /*
                    20歳以降で一番体重が軽かったときは何kgでしたか
                    その時の年齢は
                    20歳のときの体重はどのくらいでしたか
                */
                continue;
            }

            var name = input_id;
            if (type == 'checkbox') name = name + '[]';

            var html = '';

            if (gid) {
                html += '<div class="ques_item ques_grp_'+gid+'" id="'+item_id+'">';
            } else {
                html += '<div class="ques_item" id="'+item_id+'">';
            }

            if (ques_text !== '') {
                html += '<p id="'+ques_text_id+'">'+ques_text+'</p>';
            }

            if (type == 'checkbox' || type == 'radio' || type == 'select') {
                if (type == 'select') {
                    html += '<select name="'+name+'" class="'+input_class+'" id="'+input_id+'">';
                }

                var idx = 0;
                var arr = [];
                if (id == 75) {
                    // 20歳以降で一番体重が軽かったときは何kgでしたか ⇒　その時の年齢は
                    arr.push(':--');
                    for (var age_idx = age; age_idx >= 20; age_idx--) {
                        arr.push(age_idx + ':' + age_idx);
                    }
                } else if (ques_suffix == '歳') {
                    arr.push(':--');
                    for (var age_idx = age; age_idx >= 0; age_idx--) {
                        arr.push(age_idx + ':' + age_idx);
                    }
                } else if (ques_suffix == '年前') {
                    arr.push(':--');
                    for (var age_idx = 1; age_idx <= age; age_idx++) {
                        arr.push(age_idx + ':' + age_idx);
                    }
                } else if (ques_suffix == '年') {
                    arr.push(':--');
                    arr.push('lt1:1年未満');
                    for (var age_idx = 1; age_idx <= age; age_idx++) {
                        arr.push(age_idx + ':' + age_idx);
                    }
                } else {
                    arr = v.ans_option.split('|');
                }
                for (var j in arr) {
                    var key = arr[j].split(':')[0];
                    var val = arr[j].split(':')[1];
                    var label_id_idx = label_id+'_'+idx;
                    var input_id_idx = input_id+'_'+idx;

                    switch (type) {
                        case 'checkbox':
                            html += '<input type="checkbox" class="'+input_class+'" id="'+input_id_idx+'" name="'+name+'" value="'+key+'"><label for="'+input_id_idx+'">'+val+'</label>'+ques_suffix;
                            break;

                        case 'radio':
                            html += '<input type="radio" class="'+input_class+'" id="'+input_id_idx+'" name="'+name+'" value="'+key+'"><label for="'+input_id_idx+'">'+val+'</label>'+ques_suffix;
                            break;

                        case 'select':
                            html += '<option value="'+key+'">'+val+'</option>';
                    }

                    idx++;
                }

                if (type == 'select') {
                    html += '</select>'+ques_suffix;
                }

            } else if (type == 'text' || type == 'textarea') {
                switch (type) {
                    case 'text':
                        html += '<label id="'+label_id+'"><input type="text" class="'+input_class+'" id="'+input_id+'" name="'+name+'"></label>'+ques_suffix;
                        break;

                    case 'textarea':
                        html += '<label id="'+label_id+'"><textarea class="'+input_class+'" id="'+input_id+'" name="'+name+'"></textarea></label>'+ques_suffix;
                        break;
                }
            }

            $('#stage').append(html + '</div>');

            var next_key = parseInt(i) + 1;
            if (DAT[next_key]) {
                if (DAT[next_key].ques_text == '') {
                    // noop.
                } else if (DAT[next_key].gid == '') {
                    $('#stage').append('<hr>');
                }
            }
        }
    });

    /** --------------------------------------------------------------------------------------------
     * デフォルト値設定
     */
    $(function(){
        for (var k in DEF) {
            var input_class = '.'+k;
            var val = DEF[k];
            var type = $(input_class).attr('type') ? $(input_class).attr('type').toLowerCase() : '';
            var tagName = '';
            try {
                tagName = $(input_class) ? $(input_class)[0].tagName.toLowerCase() : '';
            } catch(e) {}

            if (type == 'radio') {
                $(input_class).val([val]);
            }
            if (type == 'checkbox' || type == 'text' || tagName == 'textarea' || tagName == 'select') {
            //if (type == 'checkbox' || type == 'text' || type == 'textarea' || type == 'select') {
                $(input_class).val(val);
            }
        }

        try {
            highlightCheckboxAndRadio();
        } catch(e) {}
    });

    /** --------------------------------------------------------------------------------------------
     * イベント登録
     */
    $(function(){
        for (var i in DAT) {
            var v = DAT[i];
            var id = v.id;
            var if_contain = v.if_contain;
            var act_gid = v.act_gid;
            var gid = v.gid;
            var cid = v.cid;
            var input_class = 'input_'+id;
            var type = v.ans_type;

            if (gid) {
                $('.ques_grp_'+gid).hide();
            }

            (function(type, input_class, if_contain, act_gid, cid){
                var proc = function(){
                    if (if_contain) {
                        var if_contains = if_contain.split(':');
                        var act_gids = act_gid.split(':');
                        var cids = cid.split(':');

                        for (var i in act_gids) {
                            $('.ques_grp_'+act_gids[i]).hide();
                        }

                        if (type == 'radio' || type == 'select') {
                            var selection = '';
                            if (type == 'radio') {
                                selection = $('.'+input_class).filter(':checked').val();
                            }
                            if (type == 'select') {
                                selection = $('.'+input_class).val();
                            }
                            var key = $.inArray(selection, if_contains);
                            if ($.inArray(selection, if_contains) != -1) {
                                $('.ques_grp_'+act_gids[key]).show();
                            } else {
                                for (var j in cids) {
                                    $('.ques_grp_'+cids[j]).hide();
                                    $('.ques_grp_'+cids[j]+' input:radio').attr('checked', false);
                                    $('.ques_grp_'+cids[j]+' input:checkbox').attr('checked', false);
                                    $('.ques_grp_'+cids[j]+' input:text').val('');
                                    $('.ques_grp_'+cids[j]+' select').val('');
                                    $('.ques_grp_'+cids[j]+' textarea').val('');
                                }
                            }
                        }

                        if (type == 'checkbox') {
                            var visibles = [];
                            $('.'+input_class).each(function(){
                                var pos = $.inArray($(this).val(), if_contains);
                                if ($(this).attr('checked') && pos != -1) {
                                    if ($.inArray(act_gids[pos], visibles) == -1) visibles.push(act_gids[pos]);
                                }
                            });
                            for (var k in act_gids) {
                                if ($.inArray(act_gids[k], visibles) != -1) {
                                    $('.ques_grp_'+act_gids[k]).show();
                                } else {
                                    //$('.ques_grp_'+act_gids[k]).hide();
                                    //$('.ques_grp_'+act_gids[k]+' input:radio').attr('checked', false);
                                    //$('.ques_grp_'+act_gids[k]+' select').val('');
                                    var cids_child = cids[k].split('-');
                                    for (var kk in cids_child) {
                                        $('.ques_grp_'+cids_child[kk]).hide();
                                        $('.ques_grp_'+cids_child[kk]+' input:radio').attr('checked', false);
                                        $('.ques_grp_'+cids_child[kk]+' input:checkbox').attr('checked', false);
                                        $('.ques_grp_'+cids_child[kk]+' input:text').val('');
                                        $('.ques_grp_'+cids_child[kk]+' select').val('');
                                        $('.ques_grp_'+cids_child[kk]+' textarea').val('');
                                    }
                                }
                            }
                        }

                        try {
                            highlightCheckboxAndRadio();
                        } catch(e) {}
                    }
                }
                $(proc);
                $('.'+input_class).click(proc);

            })(type, input_class, if_contain, act_gid, cid);
        }
    });
}
