<?php
/* vim:se et ts=4 sw=4 sts=4: */

/**
 * 問診アプリ
 */
class Monshin
{
    /**
     * Constructor
     */
    public function __construct()
    {
        //$this->_url = 'http://monshin.root-n.com/2_api.php';
        $this->_url = 'http://127.0.0.1/2_api.php';
        //$this->_exam_no = '11111111';
        //$this->_exam_no = '1'; // 存在する
        //$this->_exam_no = '20'; // 存在しない
        //$this->_exam_no = '9999998'; // 存在する
        $this->_exam_no = $_SERVER['argv'][1]; // 存在する
        $this->_code = '000';
        $this->_msg = '';
    }

    /**
     * Check Patient
     * @return boolean
     */
    public function isPatient()
    {
        $result = $this->_checkExamNo();
        if ($result === '000') {
            echo("存在する\n");
        } elseif ($result === '001') {
            echo("存在しない\n");
        } else {
            echo("エラー\n");
            print_r($this->getError());
        }
    }

    /**
     * Get Result
     * @return array
     */
    public function getError()
    {
        $result = array();
        $result['code'] = $this->_code;
        $result['msg']  = $this->_msg;
        return $result;
    }

    /**
     * Get Request Url
     * @return string Url
     */
    private function _getRequestUrl()
    {
        $url = $this->_url;
        $url .= '?exam_no=' . $this->_exam_no;
        return $url;
    }

    /**
     * Put Error
     * @param string $code : Error Code
     * @param string $msg  : Error Message
     * @return void
     */
    private function _putError($code, $msg)
    {
        $this->_code = $code;
        $this->_msg = $msg;
    }

    /**
     * Check Exam No
     * @return boolean
     */
    private function _checkExamNo()
    {
        $result = FALSE;
        $info = parse_url($this->_getRequestUrl());
        $fp = fsockopen($info['host'], 80, $errno, $errstr, 30);
        if (!$fp) {
            $msg = "中間APIへの接続に失敗しました($errno:$errstr)";
            $this->_putError('100', $msg);
echo("fail fsockopen\n");
        } else {
            $out = "GET {$info['path']}?{$info['query']} HTTP/1.1\r\n";
            $out .= "Host: {$info['host']}\r\n";
            $out .= "Connection: Close\r\n\r\n";
            fwrite($fp, $out);
            $body = FALSE;
            $code = NULL;
            while (($line = fgets($fp, 1024)) !== FALSE) {
                $line = trim($line);
                if (empty($line)) {
                    $body = TRUE;
                    continue;
                }
                if ($body !== FALSE) {
                    $code = $line;
                    break;
                }
            }
            fclose($fp);
            switch (TRUE) {
                case ($code === '000' || $code === '001') :
                    // 存在する(000) or 存在しない(001)
                    $result = $code;
                    break;
                case $code === '200' :
                    $msg = '通信エラー';
                    $this->_putError('200', $msg);
                    break;
                case $code === '999' :
                    $msg = 'システムエラー';
                    $this->_putError('999', $msg);
                    break;
                default :
                    $msg = "中間APIの結果取得に失敗しました($code)";
                    $this->_putError('100', $msg);
echo("switch default\n");
            }
        }
        return $result;
    }
}

$mon = new Monshin;
$mon->isPatient();

?>
