<?php
/* vim:se et ts=4 sw=4 sts=4: */

/**
 * Sanyo Stab
 */
class Sanyo
{

    private $_invalid_exam_no = array(
                            '18181818',
                                );
    public $_enc = 'SJIS';

    /**
     * Constructor
     */
    public function __construct()
    {
    }

    /**
     * Get Result
     */
    public function getResult($data)
    {
        $result = '';
        $stat = $this->_validate($data, $code);
        if ($stat === FALSE) {
            $result = $this->_getErrorData($code);
            echo("Error($code) : Error Data\n");
        } else {
            $d1 = substr($data, 0, 1); // 1 STX(要求) or ENQ(確認)
            if ($d1 === "\x02") {       // STX
                echo("STX : Patient Data\n");
                $result = $this->_getPatientData();
            } elseif ($d1 === "\x05") { // ENQ
                echo("ENQ : Sanyo System OK\n");
                $result = "\x06"; // return ACK
            }
        }
        return $result;
    }

    /**
     * Validate
     */
    private function _validate($data, &$code)
    {
        //return $this->_validateAA1($data, $code);
        return $this->_validateA11($data, $code);
    }

    private function _validateAA1($data, &$code)
    {
        $result = FALSE;
        $code = NULL;
        $d1 = substr($data, 0, 1);   // 1 STX
        $d2 = substr($data, 1, 2);   // 2 拡張部
        $d3 = substr($data, 3, 4);   // 4 電文区分
        $d4 = substr($data, 7, 3);   // 3 ブロック区分
        $d5 = substr($data, 10, 1);  // 1 予備
        $d6 = substr($data, 11, 3);  // 3 データ区分
        $d7 = substr($data, 14, 1);  // 1 サブ区分
        $d8 = substr($data, 15, 1);  // 1 情報種別
        $d9 = substr($data, 16, 18); // 18 患者コード/患者ID
        $this->_exam_no = trim($d9);
        $d10 = substr($data, 34, 7); // 7 特定情報
        $d11 = substr($data, 41, 6); // 6 RSV
        $d12 = substr($data, 47, 1); // 1 ETX
        if ($d1 === "\x05") {
            // 動作確認モード(ENQ)の場合は、何もしない...
        } elseif (strlen($data) != 48) {
            $code = '023'; // 全体のテキスト長が不正
            return $result;
        } elseif ($d1 !== "\x02" && $d1 !== "\x10" && $d1 !== "\x05") {
            $code = '010'; // 開始コードが不正(STX/DLE/ENQ以外の場合)
            return $result;
        } elseif ($d1 === "\x02" && $d12 !== "\x03") {
            $code = '011'; // 開始コード(STX)時に終了コード(ETX)が無い
            return $result;
        } elseif ($d3 != 'SRD0' && $d3 != 'SRA0') {
            $code = '020'; // 電文区分が不正
            return $result;
        } elseif ($d6 != 'AA1' && $d6 != 'AB1' && $d6 != 'AB2' && $d6 != 'AC1') {
            $code = '021'; // データ区分又は問合せ区分が不正
            return $result;
        } elseif ($d8 != 'N' && $d8 != 'C' && $d8 != 'R') {
            $code = '022'; // 情報種別が不正
            return $result;
        } elseif (in_array($this->_exam_no, $this->_invalid_exam_no)) {
            $code = '001'; // 患者未登録
            return $result;
        }
        $result = TRUE;
        return $result;
        // 以下は保留...
        $code = '050'; // 要求情報、問合せ情報の形式が間違っている
        $code = '054'; // 保険種別が不正
        $code = '055'; // 外来/入院が不正
    }

    private function _validateA11($data, &$code)
    {
        $result = FALSE;
        $code = NULL;
        $d1 = substr($data, 0, 1);   // 1 STX
        $d2 = substr($data, 1, 2);   // 2 拡張部
        $d3 = substr($data, 3, 4);   // 4 電文区分
        $d4 = substr($data, 7, 3);   // 3 ブロック区分
        $d5 = substr($data, 10, 1);  // 1 予備
        $d6 = substr($data, 11, 3);  // 3 データ区分
        $d7 = substr($data, 14, 1);  // 1 サブ区分
        $d8 = substr($data, 15, 1);  // 1 情報種別
        $d9 = substr($data, 16, 10); // 10 患者コード/患者ID
        $this->_exam_no = trim($d9);
        $d10 = substr($data, 26, 6); // 6 特定情報
        $d11 = substr($data, 32, 6); // 6 RSV
        $d12 = substr($data, 38, 1); // 1 ETX
        if ($d1 === "\x05") {
            // 動作確認モード(ENQ)の場合は、何もしない...
        } elseif (strlen($data) != 39) {
            $code = '023'; // 全体のテキスト長が不正
            return $result;
        } elseif ($d1 !== "\x02" && $d1 !== "\x10" && $d1 !== "\x05") {
            $code = '010'; // 開始コードが不正(STX/DLE/ENQ以外の場合)
            return $result;
        } elseif ($d1 === "\x02" && $d12 !== "\x03") {
            $code = '011'; // 開始コード(STX)時に終了コード(ETX)が無い
            return $result;
        } elseif ($d3 != 'SRD0' && $d3 != 'SRA0') {
            $code = '020'; // 電文区分が不正
            return $result;
        } elseif ($d6 != 'A01' && $d6 != 'A11' && $d6 != 'A12' && $d6 != 'A21') {
            $code = '021'; // データ区分又は問合せ区分が不正
            return $result;
        } elseif ($d8 != 'N' && $d8 != 'C' && $d8 != 'R') {
            $code = '022'; // 情報種別が不正
            return $result;
        } elseif (in_array($this->_exam_no, $this->_invalid_exam_no)) {
            $code = '001'; // 患者未登録
            return $result;
        }
        $result = TRUE;
        return $result;
        // 以下は保留...
        $code = '050'; // 要求情報、問合せ情報の形式が間違っている
        $code = '054'; // 保険種別が不正
        $code = '055'; // 外来/入院が不正
    }

    /**
     * Get PatientData
     */
    private function _getPatientData()
    {
        //return $this->_getPatientAA1();
        return $this->_getPatientA11();
    }

    private function _getPatientAA1()
    {
        $exam_no = substr(md5($this->_exam_no), 0, 13);
        $len = strlen($exam_no);
        $s = "\x02";    // 1 STX
        $data = '00';   // 2 拡張部
        $data .= 'MDT0'; // 4 電文区分
        $data .= 'E01';  // 3 ブロック区分
        $data .= ' ';    // 1 予備
        $data .= 'AA1';  // 3 データ区分
        $data .= '0';    // 1 サブ区分
        $data .= 'C';    // 1 情報種別
        $data .= $exam_no . str_repeat(' ', (13 - $len)); // 13 患者コード
        $data .= 'ﾅｲ ';  // 3 主科
        $data .= '1';    // 1 外/入
        $data .= '001';  // 3 保険組No
        $data .= '  ';   // 2 RSV
        $data .= '1';    // 1 年齢区分
        $data .= '1';    // 1 所得区分
        $data .= '1';    // 1 認定区分
        $data .= ' ';    // 1 医療/介護フラグ
        $data .= str_repeat(' ', 13);  // 13 RSV
        $data .= '000000000000000008'; // 18 患者ID
        $data .= 'H00603';   // 6 最終来院月
        $data .= 'ｻﾝﾖｳ ﾀﾛｳ                                          '; // 40 カナ氏名
        $data .= 'KI三洋　タロウ　　　　　　　　　　　　　　　　　　　KO'; // 44 漢字氏名
        $data .= '1';        // 1 性別
        $data .= 'KI平成KO'; // 8 漢字元号
        $data .= 'H0020304'; // 8 生年月日
        $e = "\x03";       // 1 ETX
        $data = $s . mb_convert_encoding($data, $this->_enc, 'UTF-8') . $e;
        return $data;
    }

    public function _getPatientA11()
    {
        $exam_no = substr(md5($this->_exam_no), 0, 10);
        $len = strlen($exam_no);
        $s = "\x02";    // 1 STX
        $data = '00';   // 2 拡張部
        $data .= 'MDT0'; // 4 電文区分
        $data .= 'E01';  // 3 ブロック区分
        $data .= ' ';    // 1 予備
        $data .= 'A11';  // 3 データ区分
        $data .= '0';    // 1 サブ区分
        $data .= 'C';    // 1 情報種別
        $data .= $exam_no . str_repeat(' ', (10 - $len)); // 10 患者コード
        $data .= 'ﾅ ';   // 2 主科
        $data .= '1';    // 1 外/入
        $data .= '001';  // 3 保険組No
        $data .= '  ';   // 2 RSV
        $data .= '1';    // 1 年齢区分
        $data .= '1';    // 1 所得区分
        $data .= '1';    // 1 認定区分
        $data .= ' ';    // 1 医療/介護フラグ
        $data .= $exam_no . str_repeat(' ', (10 - $len)); // 10 患者コード
        $data .= '000008'; // 6 患者ID
        $data .= 'H00603'; // 6 最終来院年月
        $data .= 'ｻﾝﾖｳ ﾀﾛｳ        ';     // 16 カナ氏名
        $data .= str_repeat(' ', 10);    // 10 RSV
        $data .= 'KI三洋　タロウ　　KO'; // 20 漢字氏名
        $data .= '1';        // 1 性別
        $data .= 'KI平成KO'; // 8 漢字元号
        $data .= 'H0020304'; // 8 生年月日
        $data .= str_repeat(' ', 1);    // 1 RSV
        $data .= '107     ';            // 8 郵便番号
        $data .= str_repeat(' ', 6);    // 6 RSV
        $data .= str_repeat(' ', 6);    // 6 RSV
        $data .= 'KI東京都千代田区神田６　　　　　　　　　　KO'; // 44 住所1(1行目)
        $data .= 'KI　　　　　　　　　　　　　　　　　　　　KO'; // 44 住所2(2行目)
        $data .= '03-3833-0123'; // 12 電話番号
        $data .= '03-3853-0123'; // 12 連絡先電話番号
        $data .= 'KI会社員　　KO'; // 14 職業
        $data .= str_repeat(' ', 20);    // 20 RSV
        $data .= str_repeat(' ', 20);    // 20 RSV
        $data .= 'KI　　　　　　　　　　　　　　　　　　　　KO'; // 44 メモ(個人コメント)
        $data .= str_repeat(' ', 3);     // 3 RSV
        $data .= str_repeat(' ', 1);     // 1 RSV
        $data .= '1'; // 1 本人/家族
        $data .= 'KI長男KO'; // 8 続柄
        $data .= '      06'; // 8 保険者番号
        $data .= 'KI１００１　　　　　　KO'; // 24 被保険者証・記号
        $data .= 'KI８５２０　　　　　　　　　　　　　　　　KO'; // 44 被保険者証・番号
        $data .= 'H0060708'; // 8 保険証有効期限
        $data .= ' 2345676'; // 8 第1公費負担者番号
        $data .= ' 234567 '; // 8 第1公費受給者番号
        $data .= '        '; // 8 第2公費負担者番号
        $data .= '        '; // 8 第2公費受給者番号
        $data .= 'KI社保単　KO'; // 12 保険名称
        $data .= '001'; // 3 分類A
        $data .= '000'; // 3 分類B
        $data .= '000'; // 3 分類C
        $data .= '000'; // 3 分類D
        $data .= '000'; // 3 保険区分
        $data .= str_repeat(' ', 1); // 1 RSV
        $e = "\x03";       // 1 ETX
        $data = $s . mb_convert_encoding($data, $this->_enc, 'UTF-8') . $e;
        return $data;
    }

    /**
     * Get Error Data
     */
    private function _getErrorData($code)
    {
        $data = "\x10"; // 1 DLE
        $data .= 'MER'; // 3 識別子
        $data .= $code; // 8 エラーコード(最大8バイト)
        $data .= "\x04"; // 1 EOT
        return $data;
    }

}

/**
 * Socket Class from php.net
 */
class Socket {
    // Sockets
    private $sock;
    private $lister;
    // Wait, Porta, Ack
    private $wait;
    private $porta;
    private $ack;
    // Usuario
    private $user;
    
    function __construct($wait, $porta, $ack) {
        $this->wait  = $wait;
        $this->porta = $porta;
        $this->ack   = $ack;
        $this->user['ip'] = $this->user['port'] = NULL;
        // Cria o servidor
        $this->listen();
    }

    function  __destruct() {
        $this->close();
    }
    
    // Cria o Servidor
    public function listen(){
        while( !( $this->lister = @socket_create_listen($this->porta) ) ){
            //echo 'Aguarde..';
            sleep($this->wait);
        }
    }

    // Aguarda um Cliente conectar.
    public function wait(){
        $r = array($this->lister);
        if( socket_select($r,$w = NULL,$e = NULL, $this->wait) ){
            // Conectado
            $this->sock = socket_accept($this->lister);
            socket_getpeername($this->sock, $raddr, $rport);
            $this->user = array('ip'=>$raddr,'port'=>$rport);            
            return true;
        } else {
            // [Time out] - Não conectado a tempo.
            return false;
        }
        
    }
    
    // Fecha a conexão
    public function close(){
        if( is_resource($this->lister) )
            socket_close($this->lister);
    }
    
    // Obtem as informações do usuário
    public function getUserInfo(){
        return $this->user;
    }
    
    // Le todo o sock a cada 1 Byte.
    public function write($message){
        $num = 0;
        $length = strlen($message);
        do{
            $buff = substr($message, $num);
            $num += socket_write($this->sock,$buff);
        }while( $num != $length );
    }

    // Envia o ACK
    public function sendAck(){
        do{
            $num = socket_write($this->sock,$this->ack);
        }while( $num == 0 );
    }

    // Recebe o ACK
    public function waitAck(){
        do {
            $buff = socket_read($this->sock,1,PHP_BINARY_READ);
        }while( $buff != $this->ack );
    }

    // Le todo o sock a cada 1 Byte.
    public function read(){
        $message = '';
        do {
            $buff     = socket_read($this->sock,1,PHP_BINARY_READ);
            $message .= $buff;
        }while( $buff != "\n" );
        return $message;
    }
}

// {{{ Main...
$san = new Sanyo();
// Socket('wait sec', 'port num', 'ack char');
$sok = new Socket(1, 9031, "\x06");
while (1) {
    if ($sok->wait()) {
        $user = $sok->getUserInfo();
        printf("reveive: ip(%s), port(%s)\n", $user['ip'], $user['port']);
        $data = trim($sok->read());
        $message = $san->getResult($data);
        echo("rcv(raw):" . $data . "\n");
        echo("rcv(hex):" . bin2hex($data) . "\n");
        $s = substr($message, 0, 1);
        $e = substr($message, -1);
        $data = substr($message, 1, (strlen($message) -2));
        $data = mb_convert_encoding($data, 'UTF-8', $san->_enc);
        echo("snd(raw):" . $data . "\n");
        echo("snd(hex):" . bin2hex($message) . "\n");
        $sok->write($message);
        if ($message !== "\x06") {
            // ACK以外を送信した場合は、相手からのACKを待つ
            $sok->waitAck();
            $sok->sendAck();
        }
    }
}
// }}}

?>
