<?php
/* vim:se et ts=4 sw=4 sts=4: */

class CarteXml
{
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->x = new DOMDocument('1.0', 'UTF-8');
        $this->x->formatOutput = true;
        $this->x->preserveWhiteSpace = false;
    }

    /**
     * Execute
     */
    public function execute()
    {
        $data = array();
        // SystemInfo...
        $data['SystemInfo'] = $this->_getSystemInfo();
        // Patient_Info...
        $data['Consultation_Data'][0]['Patient_Info'] = $this->_getPatientInfo();
        // Basic_Info...
        $data['Consultation_Data'][0]['Consultation'][0]['Basic_Info'] = $this->_getBasic_Info();
        // Order_Info...
        $data['Consultation_Data'][0]['Consultation'][0]['Order_Info'][0][]['Order_Category'] = $this->_getOrder_Category();
        $data['Consultation_Data'][0]['Consultation'][0]['Order_Info'][0][]['Order_Category'] = $this->_getOrder_Category();
        $el = $this->_xmlElement('Consultation_Datas', $data, array('S_Version' => '0200'));
        $this->x->appendChild($el);
        return $this->x->saveXML();
    }

    /**
     * Get SystemInfo
     */
    private function _getSystemInfo()
    {
        $data[0] = array('SystemName' => array('ABCDEFG'));
        return  $data;
    }

    /**
     * Get Patient_Info
     */
    private function _getPatientInfo()
    {
        $data[0] = array('Patient_ID' => array('123456'));
        return  $data;
    }

    /**
     * Get Basic_Info
     */
    private function _getBasic_Info()
    {
        $data[0]['InPatientFlag']           = array('入院');
        $data[0]['Consultation_Date']       = array('20110929120000');
        $data[0]['Consultation_Doctor']     = array('山田　タロウ', array('doctorid' => 'user1'));
        $data[0]['Consultation_Type']       = array('初診');
        $data[0]['Consultation_Department'] = array('内科', array('departmentid' => '\\\\'));
        $data[0]['Insurance']               = array('国保', array('insuranceid' => '001'));
        $data[0]['Prescription_INOUT']      = array('院外');
        $data[0]['Message']                 = array('ネプライザーの種類を間違えていたので修正');
        $data[1] = array('Consultation_DataID' => '123456890');
        return $data;
    }

    /**
     * Get Order_Category
     */
    private function _getOrder_Category()
    {
        $data[0]['Order_Units'] = $this->_getOrder_Units();
        $data[1] = array('Category' => '診察');
        return $data;
    }

    /**
     * Get Order_Units
     */
    private function _getOrder_Units()
    {
        $data[0][] = array('Order' => $this->_getOrder());
        $data[0][] = array('Order' => $this->_getOrder());
        $data[0][] = array('Order_Administration' => array('', array(
                                                            'Code' => '',
                                                            'Usage' => '',
                                                            'Count' => '1',
                                                            'Unit' => '回'
                                                        )));
        $data[0][] = array('OrderUnits_Memo' => array('メモ内容'));
        $data[1] = array(
                        'Order_UnitsID' => '999999999',
                        'Order_type' => '',
                        'Application' => '診察',
                        'InputUserCode' => 'user1',
                        'InputUserName' => '医師 太郎',
                        'InputTime' => '20080228115959',
                        'LastUpdateTime' => '20080228115959'
                        );
        return $data;
    }

    /**
     * Get Order
     */
    private function _getOrder()
    {
        $data[0] = '';
        $data[1] = array('Code' => '1216', 'Name' => '特定疾患療養管理科', 'Count' => '1', 'Unit' => '', 'Cutoff' => '', 'SeqNo' => '1');
        return $data;
    }

    /**
     * Create Xml Element
     */
    private function _xmlElement($name, $text = '', $attr = array())
    {
        if (is_object($text)) {
            $el = $this->x->createElement($name);
            $el->appendChild($text);
        } elseif (is_array($text)) {
            $el = $this->x->createElement($name);
            foreach ($text as $key => $val) {
                if (! is_object($val)) {
                    if (preg_match('/^\d+$/', $key)) {
                        foreach ($val as $k => $v) {
                            if (isset($v[1])) {
                                $val = $this->_xmlElement($k, $v[0], $v[1]);
                            } else {
                                $val = $this->_xmlElement($k, $v[0]);
                            }
                        }
                    } elseif (isset($val[1])) {
                        $val = $this->_xmlElement($key, $val[0], $val[1]);
                    } else {
                        $val = $this->_xmlElement($key, $val[0]);
                    }
                }
                $el->appendChild($val);
            }
        } else {
            $el = $this->x->createElement($name, $text);
        }
        if (! empty($attr)) {
            $el = $this->_xmlAttribute($el, $attr);
        }
        return $el;
    }

    /**
     * Create Xml Attribute on Element
     */
    private function _xmlAttribute($el, $attr)
    {
        foreach ((array)$attr as $key => $val) {
            $el->setAttribute($key, $val);
        }
        return $el;
    }
}

$obj = new CarteXml();
echo $obj->execute();
exit;

//$x = new XMLWriter();
//$x->openMemory();
//$x->startDocument('1.0', 'UTF-8');
//$x->startElement('test');
//$x->startAttribute('code');
//$x->text('10101');
//$x->endAttribute();
//$x->text('Hello World!!');
//$x->endElement();
//$x->endDocument();
////echo($x->outputMemory(TRUE));
//$x->outputMemory(FALSE);

//$x = new DOMDocument('1.0', 'UTF-8');
//$x->formatOutput = true;
//$x->preserveWhiteSpace = false;
//$el1 = $x->createElement('test1', 'hoge');
//$el1->setAttribute('gaga', 'hehe');
//$el2 = $x->createElement('test2', 'foo');
//$el = $x->createElement('result');
//$el->appendChild($el1);
//$el->appendChild($el2);
//$x->appendChild($el);
//$data = $x->saveXML();
//echo($data);

//require_once 'XML/Serializer.php';
//$x = new XML_Serializer();
//$data['result']['test1'] = array('attribute'=>'aaaa', 'text'=>'ckckckck');
//$data['result']['test2'] = 'bbbb';
//$res = $x->serialize($data);
//$res = $x->getSerializedData();
//echo($res);

?>
