<?php
/* vim:se et ts=4 sw=4 sts=4: */
/**
 * Xml Pickup Api
 * 
 * LICENSE: 
 * 
 * @copyright 2011 Topazos, Inc.
 * @license http://www.topazos.co.jp/license/3_0.txt PHP License 3.0
 * @version CVS: $Id: $
 * @link http://www.topazos.co.jp/package/PackageName
 * @since File available since Release 1.0.0
 */

/**
 * Pickup Xml
 */
class PickupXml
{

    private $_list = array();
    private $_kind = '';
    private $_host = 'monshin.local.net';
    private $_dir =  '/tmp/';
    private $_err = array();

    public function __construct($kind = 'xml_recipe')
    {
        $this->_path = '/' . str_replace('_', '/', $kind);
        $this->_kind = $kind;
    }

    public function prepare()
    {
        $url = 'http://' . $this->_host . $this->_path;
        $res = file_get_contents($url);
        $res = trim(mb_convert_encoding($res, 'UTF-8', 'SJIS'));
        if (empty($res)) {
            // No Xml Data...
            // Do Nothing...
        } elseif (strpos($res, '--get_error--') === FALSE) {
            // Xml Data...
            $tmp = explode("\n--{$this->_kind}--\n", $res);
            foreach ($tmp as $key => $val) {
                $pos = strpos($val, "\n");
                $file = substr($val, 0, $pos);
                $xml = substr($val, $pos);
                list($dummy, $name) = explode(':', $file);
                $this->_list[] = array(
                                    'name' => trim($name),
                                    'xml' => trim($xml),
                                );
            }
        } else {
            // Error...
            $this->_err[] = $res;
        }
    }

    public function validate()
    {
        $result = empty($this->_err) && count($this->_list) > 0;
        return $result;
    }

    public function execute()
    {
        foreach ($this->_list as $val) {
            $path = $this->_dir . '/' . $val['name'];
            $dir = dirname($path);
            if (! is_dir($dir)) {
                $this->autoPrepareDir($dir, 0777);
            }
            if (($fp = fopen($path, 'w')) !== FALSE) {
                if (flock($fp, LOCK_EX)) {
                    fwrite($fp, $val['xml']);
                    flock($fp, LOCK_UN);
                }
                fclose($fp);
            }
        }
    }

    public function complete()
    {
    }

    // {{{ Prepare Dir...
    /**
     * 指定ディレクトリの確認作成
     * 
     * ディレクトリが存在しない場合は作成を試みます。
     * 
     * @param string  $inDirPath : ディレクトリパス
     * @param integer $inPerm    : パーミッション
     * 
     * @return mixed (成功)ディレクトリパス or (失敗)FALSE
     * @access public
     */
    function prepareDir($inDirPath, $inPerm)
    {
        $theResult = TRUE;
        if (! is_dir($inDirPath)) {
            umask(0);
            $theResult = @mkdir($inDirPath, $inPerm);
        } else {
            clearstatcache();
            if (is_writable($inDirPath)) {
                $thePerm = fileperms($inDirPath);
                if ($thePerm != $inPerm) {
                    $theResult = @chmod($inDirPath, $inPerm);
                }
            } else {
                $theResult = FALSE;
            }
        }
        if ($theResult) {
            $theResult = $inDirPath;
        }
        return $theResult;
    }

    /**
     * Auto Prepare Directory Recurcive
     * 
     * Try to Create Dir and Modify Permission
     * 
     * @param string  $inDirPath    : Main Directory Path
     * @param integer $inPerm       : Permission to Create Dir
     * @param string  $inParentPath : Parent Path
     * @param integer $inChildPath  : Child Path
     * 
     * @return mixed Main Directory Path or FALSE
     * @see prepareDir
     * @access public
     */
    function autoPrepareDir($inDirPath, $inPerm, $inParentPath = FALSE, $inChildPath = FALSE)
    {
        $theResult = FALSE;
        $theParent = ($inParentPath !== FALSE ? $inParentPath : $inDirPath);
        $theChild  = ($inChildPath !== FALSE ? $inChildPath : $theParent);
        if (! is_dir($theParent)) {
            $theResult = $this->autoPrepareDir($inDirPath, $inPerm, dirname($theParent), $theParent);
            if ($inDirPath != $theResult) {
                $theResult = $this->autoPrepareDir($inDirPath, $inPerm, $theParent, $theChild);
            }
        } else {
            $theResult = $this->prepareDir($theChild, $inPerm);
        }
        return $theResult;
    }
    // }}}

}

?>
