<?php
/* -------------------------------------------------------------
 * 
 * Lambda.init.php.
 * 
 * ---------------------------------------------------------- */

/***************************************************************
 * proc0: benchmark start.
 **************************************************************/
if (false) {
    if (is_readable(LAMBDA_BASEDIR.DS.'components'.DS.'Benchmark.php')) {
        require LAMBDA_BASEDIR.DS.'components'.DS.'Benchmark.php';
        $_Lambda_proc0_benchmark = new Benchmark();
        $_Lambda_proc0_benchmark->start();
    }
}

/***************************************************************
 * debug. _v _ve
 **************************************************************/
if (is_readable(LAMBDA_BASEDIR.DS.'components'.DS.'debug.php')) {
    require LAMBDA_BASEDIR.DS.'components'.DS.'debug.php';
}

/***************************************************************
 * custom error handling
 **************************************************************/
function lambda_custom_error_handler($errno, $errmsg, $filename, $linenum)
{
    /**
     *  以下のエラータイプは、ユーザ定義の関数では扱えません。(PHPマニュアルより)
     *  E_ERROR, E_PARSE, E_CORE_ERROR, E_CORE_WARNING, E_COMPILE_ERROR, E_COMPILE_WARNING
     */
    $errortypes = array (
            1 => 'E_ERROR',
            2 => 'E_WARNING',
            4 => 'E_PARSE',
            8 => 'E_NOTICE',
           16 => 'E_CORE_ERROR',
           32 => 'E_CORE_WARNING',
           64 => 'E_COMPILE_ERROR',
          128 => 'E_COMPILE_WARNING',
          256 => 'E_USER_ERROR',
         1024 => 'E_USER_WARNING',
         2048 => 'E_USER_NOTICE',
         4096 => 'E_STRICT',
         8192 => 'E_RECOVERABLE_ERROR',
        16384 => 'E_DEPRECATED',
    );
    // E_ALLの値は、PHP バージョンに依存

    $dt = (version_compare(PHP_VERSION, '5.2.0', '>=')) ? date('Y-m-d H:i:s') : date('d-M-Y H:i:s');
    $error = isset($errortypes[$errno]) ? $errortypes[$errno] : 'UNKNOWN_ERROR';
    $ref = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : 'none';
    $eol = (defined('LAMBDA_HTML_ERRORS') && LAMBDA_HTML_ERRORS) ? "<br />\n" : "\n";

    ob_start();
    ob_implicit_flush(false);
        echo "[$dt] PHP {$error}: {$errmsg} in {$filename} on line {$linenum} - ";
        echo "URL: http://{$_SERVER['HTTP_HOST']}{$_SERVER['REQUEST_URI']} - ";
        echo "Ref: {$ref}{$eol}";
    $output = ob_get_clean();

    if (ini_get('display_errors')) echo $output;

    if (defined('LAMBDA_LOG_ERRORS') && LAMBDA_LOG_ERRORS) {
        if (defined('LAMBDA_ERROR_LOG') && LAMBDA_ERROR_LOG) {
            $pi = pathinfo(LAMBDA_ERROR_LOG);
            if (isset($pi['dirname']) && is_writable($pi['dirname'])) {
                error_log($output, 3, LAMBDA_ERROR_LOG);
            } else {
                echo 'WARNING: Directory not found (or permission denied): '.$pi['dirname']."<br />\n";
            }
        }
    }
}

/***************************************************************
 * custom shutdown handling
 **************************************************************/
function lambda_custom_shutdown_handler()
{
    $is_error = false;
    if ($error = error_get_last()) {
        switch ($error['type']) {
            case E_ERROR:
            case E_PARSE:
            case E_CORE_ERROR:
            case E_CORE_WARNING:
            case E_COMPILE_ERROR:
            case E_COMPILE_WARNING:
                $is_error = true;
                break;
        }
    }
    if ($is_error) {
        lambda_custom_error_handler(
            $error['type'], $error['message'], $error['file'], $error['line']
        );
    }
}

/***************************************************************
 * require components.
 **************************************************************/
/**
 * require Factory.php.
 */
if (is_readable(LAMBDA_BASEDIR.DS.'components'.DS.'Factory.php')) {
    require LAMBDA_BASEDIR.DS.'components'.DS.'Factory.php';
    Factory::setBaseDir(LAMBDA_BASEDIR.DS.'libs');
}

/**
 * require Resource.php.
 */
if (is_readable(LAMBDA_BASEDIR.DS.'components'.DS.'Resource.php')) {
    require LAMBDA_BASEDIR.DS.'components'.DS.'Resource.php';
    Resource::setBaseDir(LAMBDA_BASEDIR.DS.'resources');
}

/**
 * require Constant.php.
 */
if (is_readable(LAMBDA_BASEDIR.DS.'components'.DS.'Constant.php')) {
    require LAMBDA_BASEDIR.DS.'components'.DS.'Constant.php';
}

/**
 * require Mail.php.
 */
if (is_readable(LAMBDA_BASEDIR.DS.'components'.DS.'Mail.php')) {
    require LAMBDA_BASEDIR.DS.'components'.DS.'Mail.php';
    Mail::setTemplateDir(LAMBDA_BASEDIR.DS.'mailtemplates');
}

/**
 * require Device.php.
 */
if (is_readable(LAMBDA_BASEDIR.DS.'components'.DS.'Device.php')) {
    require LAMBDA_BASEDIR.DS.'components'.DS.'Device.php';
}


