<?php
/* -------------------------------------------------------------
 * app.env / application environment
 * 
 * アプリケーション環境設定
 * 
 * ---------------------------------------------------------- */

/**
 * DEBUG_MODE
 * 
 * デバッグモードの有効/無効を設定します。
 * 
 *  1：有効 / 0：無効
 * 
 *  本番運用時は 0：無効 を設定することが推奨されます。
 * 
 * 有効時：
 *  PHPのエラーが画面に出力されます。エラーレベルは E_ALL | E_STRICT です。
 * 
 * 無効時：
 *  PHPのエラーが画面出力されることを抑制します。
 *  エラーログは、Lambda/logs/php_error/<APP_DIR>.yyyymmdd に出力されます。(デフォルト)
 *  出力先の変更は、このファイル(app.env.php)の LAMBDA_APP_ERROR_LOG です。
 * 
 */
define('DEBUG_MODE', IS_DEV ? 1 : 0);

/**
 * Lambda Environment
 */
Lambda::setEnv(array(
    /**
     * date.timezone
     */
    'date.timezone' => 'Asia/Tokyo',

    /**
     * uri_notation
     * @value URI_REWRITE_STATIC | URI_REWRITE_DYNAMIC | URI_REWRITE_HYBRID | URI_NORMAL
     */
    'uri_notation' => Lambda::URI_REWRITE_HYBRID,

    /**
     * uri_sticky_params
     * @value array(param_name [, param_name])
     * 
     * [example]
     *  .htaccess
     *  RewriteRule ^(.+)/?(.*)$ index.php/module1-key1-$1/$2 [L,QSA]
     * 
     *  request
     *  http://example.com/a/b/c-ccc
     * 
     *  case1:
     *   'uri_sticky_params' => array() # empty array or not define.
     * 
     *   getting params are below
     *    $module = module1
     *    $key1 = 'a'
     *    $b    = ''
     *    $c    = 'ccc'
     * 
     *  case2:
     *   'uri_sticky_params' => array('key1') # set param name 'key1'.
     * 
     *   getting params are below
     *    $module = module1
     *    $key1 = 'a/b'
     *    $c    = 'ccc'
     */
    //'uri_sticky_params' => array('genre'),

    /**
     * uri_dummy_ext
     *  if uri_notation == Lambda::URI_REWRITE_STATIC && necessary.
     */
    'uri_dummy_ext' => '.html', // .html

    /**
     * http_header
     */
    //'http_header' => array(
    //    'Content-Type' => (Device::isDocomo()) ? 'application/xhtml+xml' : 'text/html',
    //),

    /**
     * mobile
     */
    //'is_mobile'     => _isMobile(),
    'mobile_subdir' => 'mobile',

    /**
     * display_filter
     */
    //'display_filter' => array('/^ +/m' => ''),

    /**
     * session_start
     */
    //'session_start' => true,
));





/**
 * error handling
 *
 *  以下のエラータイプは、ユーザ定義の関数では扱えません。(PHPマニュアルより)
 *  E_ERROR, E_PARSE, E_CORE_ERROR, E_CORE_WARNING, E_COMPILE_ERROR, E_COMPILE_WARNING
 */
define('LAMBDA_ENABLE_CUSTOM_ERROR', 1);

if ( ! defined('LAMBDA_APPDIRNAME')) {
    define('LAMBDA_APPDIRNAME', substr(dirname(__FILE__), strrpos(dirname(__FILE__), '/') + 1));
}

define('LAMBDA_APP_ERROR_LOG', LAMBDA_BASEDIR.DS.'logs'.DS.'php_error'.DS.LAMBDA_APPDIRNAME.'.'.date('Ymd'));

if (version_compare(PHP_VERSION, '5.2.0', '>=')) {
    // PHP 5 >= 5.2.0
    if (LAMBDA_ENABLE_CUSTOM_ERROR) {
        define('LAMBDA_ERROR_REPORTING', E_ALL);
        define('LAMBDA_LOG_ERRORS',      DEBUG_MODE ? 0 : 1);
        define('LAMBDA_ERROR_LOG',       LAMBDA_APP_ERROR_LOG);
        define('LAMBDA_HTML_ERRORS',     0);
    } else {
        ini_set('error_reporting', E_ALL);
        ini_set('log_errors',      DEBUG_MODE ? 0 : 1);
        ini_set('error_log',       LAMBDA_APP_ERROR_LOG);
        ini_set('html_errors',     0);
    }
} else {
    // PHP 5 < 5.2.0
    if (LAMBDA_ENABLE_CUSTOM_ERROR) {
        define('LAMBDA_ERROR_REPORTING', E_WARNING | E_NOTICE); // E_WARNING | E_NOTICE
        define('LAMBDA_LOG_ERRORS',      DEBUG_MODE ? 0 : 1);
        define('LAMBDA_ERROR_LOG',       LAMBDA_APP_ERROR_LOG);
        define('LAMBDA_HTML_ERRORS',     0);
    }
    ini_set('error_reporting', E_ALL);
    ini_set('log_errors',      DEBUG_MODE ? 0 : 1);
    ini_set('error_log',       LAMBDA_APP_ERROR_LOG);
    ini_set('html_errors',     0);
}

// display_errors
ini_set('display_errors',  DEBUG_MODE ? 1 : 0);


