<?php
/* -------------------------------------------------------------
 * app.conf / application configuration
 * 
 * アプリケーション設定
 * 
 * ---------------------------------------------------------- */

/**
 * 成育問診側 緊急フローのON/OFFフラグ
 * ON(TRUE) or FALSE(OFF)
 */
define('SEIIKU_MONSHIN_KINKYU_FLAG', TRUE);

/**
 * 重症度判定のラベル名を定義
 * 利用環境に応じて以下のラベル種類A or Bをコメントアウトする
 */
// ラベル種類A (通常はこちらがデフォルト)
define('SEVERITY_LABEL_SUPERHIGH', '蘇生');
define('SEVERITY_LABEL_HIGH',      '緊急');
define('SEVERITY_LABEL_MIDDLE',    '準緊急');
define('SEVERITY_LABEL_LOW',       '非緊急');
// ラベル種類B
//define('SEVERITY_LABEL_SUPERHIGH', '超重症');
//define('SEVERITY_LABEL_HIGH',      '重症');
//define('SEVERITY_LABEL_MIDDLE',    '中等症');
//define('SEVERITY_LABEL_LOW',       '軽症');


/*
require_once 'Microsoft/WindowsAzure/Storage/Table.php';
require_once 'Microsoft/WindowsAzure/SessionHandler.php';

$host = Microsoft_WindowsAzure_Storage::URL_CLOUD_TABLE;
$accountName = azure_getconfig('StorageAccountName');
$accountKey = azure_getconfig('StorageAccountKey');
$usePathStyleUri = false;

$cli = new Microsoft_WindowsAzure_Storage_Table(
                              $host,
                              $accountName,
                              $accountKey,
                              $usePathStyleUri
                              //$retryPolicy
);
$h = new Microsoft_WindowsAzure_SessionHandler($cli, 'sess_table', 'mysession');
$h->register();
*/

/**
 * SITE_NAME
 * 
 * <html>タグの <title>...</title> に反映されます。
 * 
 *     ページごとに <title>タグを変更したい場合は、サブモジュールに
 *     パラメーター「title」をセットすることで対応できます。
 * 
 *     <?php
 *         $lmd->invokeModule('common.head', array(
 *             'title' => 'よくある質問 │ '.SITE_NAME,
 *         ));
 *     ?>
 * 
 */
define('SITE_NAME', '@:' . APP_ENV);



/**
 * WEB_ROOT [http path]
 * 
 * WEBのルートディレクトのパスを設定します。
 * 
 * WEB_ROOT の設定は下記【利用例】のように、おもにビューの HTML で js, css, href, img 等の
 * プレフィクスとして利用します。
 * こうしておくことで、万一 ディレクトリ構造が変化した場合でも、柔軟に対応可能になります。
 * 
 * 設定するパスは下記のどちらかになります。
 * 
 *  a) ブラウザが認識する / からの絶対パス
 *  b) http:// からの絶対URL
 * 
 * 
 *【利用例】
 * 
 *    js
 *    <script type="text/javascript" src="<?php echo WEB_ROOT ?>/js/jquery.js"></script>
 * 
 *    css
 *    <link rel="stylesheet" href="<?php echo WEB_ROOT ?>/css/base.css" type="text/css" />
 * 
 *    href
 *    <a href="<?php echo WEB_ROOT ?>/path/to/">ここをクリック</a>
 * 
 *    img
 *    <img src="<?php echo WEB_ROOT ?>/img/hoge.jpg" />
 * 
 * 
 * ※この設定は必須でありませんが、設定しておくことが推奨されます。
 * 
 */
define('WEB_ROOT', '/' . APP_ENV_PREFIX . APP_ENV . APP_ENV_SUFFIX);



/**
 * APP_ROOT [http path]
 * 
 * WEBアプリケーションディレクトのパスを設定します。
 * 
 * APP_ROOT の設定は下記【利用例】のように、ロジックやビューのプレフィクスとして利用します。
 * こうしておくことで、アプリケーションを http://example.com/app/ のようなサブディレクトリで
 * 運用している場合で、万一 ディレクトリ構造が変化した場合でも、柔軟に対応可能になります。
 * 
 * 設定するパスは下記のどちらかになります。
 * 
 *  a) ブラウザが認識する / からの絶対パス
 *  b) http:// からの絶対URL
 * 
 * 
 *【利用例】
 * 
 *    ロジック
 *    $lmd->redirect(APP_ROOT.'/');
 * 
 *    ビュー
 *    <a href="<?php echo APP_ROOT ?>/path/to/">ここをクリック</a>
 * 
 * 
 * ※この設定は必須でありませんが、設定しておくことが推奨されます。
 * 
 */
define('APP_ROOT', WEB_ROOT.'');

/* *****************************************************
//
// ▼モバイルに対応する場合は、下記に置き換えてください。
//
if (function_exists('_isMobile') && _isMobile()) {
    // MOBILE
    define('APP_ROOT', WEB_ROOT.'/mobile'); // サブディレクトリ「mobile」で運用する場合
} else {
    // PC
    define('APP_ROOT', WEB_ROOT.'');
}
***************************************************** */



/**
 * WEB_DIR [server path]
 * 
 * WEB_DIR は、ドキュメントルートのパスを設定します。
 * ※設定されるパスは「サーバー内のパス」です。
 * 
 * デフォルトでは、$_SERVER['DOCUMENT_ROOT'] から自動設定を試みます。
 * 下記のエラーが発生する場合は、自動設定に失敗していますので、
 * ドキュメントルートをハードコードしてください。
 *
 *  [error] Unknown: DOCUMENT_ROOT in /path/to/app.conf.php
 * 
 * ハードコードの例）
 *  define('WEB_DIR', '/path/to/public_html');
 * 
 * 
 * ※この設定は必須でありませんが、設定しておくことが推奨されます。
 * 
 * 
 *【利用シーン】
 *
 *    フロンエンドからドキュメントルートにアクセスする際の
 *    ショートカットとしての利用を想定しています。
 * 
 */
define('WEB_DIR', 
    (isset($_SERVER['DOCUMENT_ROOT']) && $_SERVER['DOCUMENT_ROOT']) ? 
    rtrim($_SERVER['DOCUMENT_ROOT'], DS) : exit('[error] Unknown: DOCUMENT_ROOT in '.__FILE__)
);



/**
 * APP_DIR [server path]
 * 
 * APP_DIR は、ディスパッチャ(フロントコントローラー)である index.php が格納されている
 * WEBサイドのアプリケーションディレクトリのパスを設定します。
 * ※設定されるパスは「サーバー内のパス」です。
 * 
 * デフォルトでは、index.php で設定された定数「LAMBDA_DISPATCHDIR」を割り当てます。
 * 通常利用において、この値を変更する必要はありません。
 * 
 * 
 * ※この設定は必須でありませんが、設定しておくことが推奨されます。
 * 
 * 
 *【利用シーン】
 *
 *    フロンエンドからWEBサイドのアプリケーションディレクトリにアクセスする際の
 *    ショートカットとしての利用を想定しています。
 * 
 */
define('APP_DIR', LAMBDA_DISPATCHDIR);



/***************************************************************
 * mail の設定
 **************************************************************/
//define('MAILTO_ADMIN',   '');
//define('MAILFROM_ADMIN', '');



define('TAB', "\t");
define('FEVER_ID', 1); // DB: DiseaseNameTable.DiseaseID の「発熱」の値
define('FEVER_CHECK_TEMP', 37.5); // maxtemp/nowtemp がこの値以上だったら気になる症状の「発熱」を自動的にチェックする
define('PATIENT_CHECKED_COLOR', '#0000ff'); // 患者側：チェックされた選択肢の色



/**
 * _isMobile
 * 
 * モバイルからのリクエストの判定をしたり、
 * モバイルリソースへのリクエストの判定を行います。
 * (WEBアプリケーションの仕様により、定義を変更してください)
 * 
 * この関数は、ロジックやビュー内から呼び出して利用するのはもちろんのこと、
 * アプリケーション環境設定ファイル(app.env.php)の Lambda::setEnv メソッドの
 * `is_mobile' 項目で利用されることを想定しています。
 * 
 */
function _isMobile()
{
    static $ret = null;
    if ($ret !== null) return $ret;

    // CLIから呼ばれた場合
    if ( ! class_exists('Lambda')) {
        return $ret = false;
    }

    /**
     * /mobile へのリクエストをモバイルとみなす。
     * PC で /mobile にリクエストしても、モバイル用 View を見せる仕様の場合。
     */
    return $ret = (bool)(strpos(Lambda::httpRequestUri(), '/mobile') === 0);

    /**
     * ユーザーエージェントでモバイルを判定する。
     */
    //return $ret = Device::isMobile();
}
