<?php
/**
 * ログイン
 */

if ($lmd->hasHttpPost('qq_login')) {
    // [/agent] ログイン画面から救急入力ボタンで遷移してきた場合。(既にセッション、クッキー初期化済み)
    _setAgentFlag(true);
    $lmd->redirect(APP_ROOT.'/step1?' . _getCacheKey());
}

$username = $lmd->httpPost('username');
$passwd   = $lmd->httpPost('passwd');
$dao = Factory::load('DB/DAO_doctors')->getInstance();
if ($res = $dao->fetch_active_BY_username_AND_passwd($username, $passwd)) {
    // [/agent] ログイン画面から遷移してきた場合。(既にセッション、クッキー初期化済み)
    DocCookie::setUserName($username);
    DocCookie::setUserId($res['doctor_id']);
    DocCookie::setUserDiv($res['user_div_code']);

    _setAgentFlag(true);
    $lmd->redirect(APP_ROOT.'/step1?' . _getCacheKey());
}

if (DocCookie::getUserId()) {
    // 既にログイン済み(問診開始ボタンから遷移)の場合
    // セッション削除
    $_SESSION = array();
    //session_destroy(); // destroy すると以下でAgentFlagをセットできないので実行しない
    // エージェントフラグON
    _setAgentFlag(true);
    //$lmd->redirect(APP_ROOT.'/step1?' . md5(microtime())); // キャッシュを抑制するため、ハッシュ値を付加
    $lmd->redirect(APP_ROOT.'/step1?' . _getCacheKey());
}

// ログイン失敗の場合の処理
if ($username !== '') {
    $lmd->redirect(APP_ROOT."/agent/?username={$username}");
} else {
    $lmd->redirect(APP_ROOT.'/agent/');
}
