<?php
/* -------------------------------------------------------------
 * app.init / application initial process
 * 
 * アプリケーション初動プロセス
 * 
 * ---------------------------------------------------------- */

/**
 * include files
 */
Factory::import('FormElement');
Factory::import('Javascript');
Factory::import('DocCookie');
Factory::import('String');
Factory::import('App/Answer');
Factory::import('App/Severity');

/**
 * Benchmark
 */
if (false) {
    if (is_readable(LAMBDA_BASEDIR.DS.'components'.DS.'Benchmark.php')) {
        require_once LAMBDA_BASEDIR.DS.'components'.DS.'Benchmark.php';
        $_benchmark = new Benchmark();
        $_benchmark->start();
    }
}

/**
 * 認証
 */
if ($lmd->isMainModuleGroup('doctor') || $lmd->isMainModuleGroup('doctor_tab')) {
    switch ($lmd->getMainModule())
    {
        // 認証をスルー
        case 'doctor.index':
        case 'doctor.login':
        case 'doctor.logout':
            break;

        default:
            if ( ! DocCookie::getUserName()) $lmd->redirect(APP_ROOT.'/doctor/');

    }
}



/**
 * 初期化
 */
$_answer_id   = $lmd->httpGet('answer_id', $lmd->httpPost('answer_id'));
$_answer_code = $lmd->httpGet('answer_code', $lmd->httpPost('answer_code'));

if ( ! _isAgent()) {
    _setOriginalAnswer($_answer_code, $lmd);
    //_VE(Answer::getOriginal());
}

// doctor_last_url
if (_isDoctor()) _setDoctorLastURL();



if ( ! $lmd->httpGet()) {
    // GETパラメーターが何もない時は、すべて選択とする。
    $_age_div   = array('u15', 'o16');
    $_diagnosis = array('done', 'yet');
    $_severity  = array(Severity::LEVEL_LOW, Severity::LEVEL_MIDDLE, Severity::LEVEL_HIGH, Severity::LEVEL_SUPERHIGH);
    $_sort      = 'new';
    $_ymd = date('Ymd');
} else {
    $_age_div   = $lmd->httpGet('age_div', array());
    $_diagnosis = $lmd->httpGet('diagnosis', array());
    $_severity  = $lmd->httpGet('severity', array());
    $_sort      = $lmd->httpGet('sort', 'new', '/^(new|high|low)$/');
    $_ymd = $lmd->httpGet('ymd', date('Ymd'));
}


/**
 * グローバル関数
 */
function _invalidRequest()
{
    Javascript::redirect(APP_ROOT.'/', '不正なリクエストです');
    exit;
}

function _calcLifeDays($y, $m, $d)
{
    if ( ! checkdate($m, $d, $y)) Javascript::backHistory('[エラー] 年月日を正しく入力してください');

    $life_days = strtotime('today') - strtotime("{$y}/{$m}/{$d}");
    $life_days = $life_days / 60 / 60 / 24;

    return $life_days;
}

function _getAgeAndMonth($days)
{
    $age = (int)floor($days / 365);
    $mon = (int)floor(($days % 365) / 30);
    return array($age, $mon);
}

/**
 * 年齢表記を返却する
 * 
 * @param integer $days 生存日数
 * @param string $mode 表記モード en:英語 (デフォルト:日本語)
 * @return string 年齢表記
 * 
 * 生後50日まで
 * 　⇒　日齢1～50日
 * 
 * 生後11ヶ月まで(12ヶ月未満)
 * 　⇒　月齢2～11ヶ月
 * 
 * 生後2歳まで(3歳未満)
 * 　⇒　1歳0ヶ月～2歳11ヶ月
 * 
 * 生後3歳以上
 * 　⇒　3歳～
 */
function _getAgeNotation($days, $mode = null)
{
    $days = (int)$days;
    list($y, $m) = _getAgeAndMonth($days);

    switch (true) {
        case $days <= 50: // 生後50日まで
            $ret = ($mode === 'en') ? sprintf('%dd', $days) : sprintf('日齢%d日', $days);
            break;

        case $days < 365: // 生後11ヶ月まで(12ヶ月未満)
            $ret = ($mode === 'en') ? sprintf('%dm', $m) : sprintf('月齢%dヶ月', $m);
            break;

        case $days < 1095: // 生後2歳まで(3歳未満): 1095 = 365日 * 3歳
            $ret = ($mode === 'en') ? sprintf('%dy%dm', $y, $m) : sprintf('%d歳%dヶ月', $y, $m);
            break;

        case $days >= 1095: // 生後3歳以上: 
            $ret = ($mode === 'en') ? sprintf('%dy', $y) : sprintf('%d歳', $y);
            break;

        default:
            $ret = '';
    }

    return $ret;
}

/**
 * 性別が女性か否か
 */
function _isWoman()
{
    if (_isDoctor()) {
        $gender = Answer::getOriginal('gender');
    } else {
        $gender = Answer::get('1', 'gender');
    }
    return (bool)((int)$gender === 2);
}

/**
 * 患者が子供か否か
 *  子供の定義：年齢が16歳未満
 */
function _isChild($age = null)
{
    if  ($age !== null) {
        // 引数判定用
        $_age = $age;
    } elseif (_isDoctor()) {
        if (_isAgent()) {
            // 代理入力用
            $_age = Answer::get('2', 'age');
        } else {
            // 修正タブ用
            $_age = Answer::getOriginal('age');
        }
    } else {
        // 患者入力用
        $_age = Answer::get('2', 'age');
    }
    return (bool)($_age < 16);
}

/**
 * ドクター側(http://example.com/doctor/)でログインしたユーザーか否か
 */
function _isDoctor()
{
    return (bool)DocCookie::getUserName();
}

/**
 * 代理入力画面(http://example.com/agent/)でログインしたユーザーか否か
 */
function _isAgent()
{
    return (bool)Answer::get(0, 'isAgent');
}

/**
 * 代理入力フラグのセット
 */
function _setAgentFlag($bool)
{
    Answer::set(0, array(
        'isAgent' => $bool, 
    ));
}

/**
 * 代理入力　救急(入力)か否か
 */
function _isQQAgent()
{
    switch (TRUE) {
        case _isRoleDoctor() :
            return FALSE;
        case _isRoleResident() :
            return FALSE;
        case _isRoleNurse() :
            return FALSE;
        case _isRoleClerk() :
            return FALSE;
        default :
            return (strpos(Answer::get(0, 'card_number'), QQ_CARDNUMBER_PREFIX) === 0);
    }
}

/**
 * 医師 or 小児科医 の権限を持っているか否か
 */
function _isRoleDoctor()
{
    /**
     * $user_div
     *  D = 医師
     *  P = 小児科医
     */
    $user_div = DocCookie::getUserDiv();

    return (bool)($user_div === 'D' || $user_div === 'P');
}

/**
 * レジデント の権限を持っているか否か
 */
function _isRoleResident()
{
    /**
     * $user_div
     *  R1  = 前期レジ(1年目)
     *  R2  = 前期レジ(2年目)
     *  SR3 = 後期レジ(3年目)
     *  SR4 = 後期レジ(4年目)
     *  SR5 = 後期レジ(5年目)
     */
    $user_div = DocCookie::getUserDiv();

    return (bool)preg_match('/^R[1-2]$|^SR[3-5]$/', $user_div);
}

/**
 * 看護師 の権限を持っているか否か
 */
function _isRoleNurse()
{
    /**
     * $user_div
     *  N = 看護師
     */
    $user_div = DocCookie::getUserDiv();

    return (bool)($user_div === 'N');
}

/**
 * 事務 の権限を持っているか否か
 */
function _isRoleClerk()
{
    /**
     * $user_div
     *  C = 事務
     */
    $user_div = DocCookie::getUserDiv();

    return (bool)($user_div === 'C');
}

function _setOriginalAnswer($answer_code, &$lmd)
{
    if ( ! _isDoctor()) {
        Answer::setOriginal(array());
        return;
    }

    if ( ! $answer_code) return;

    if ($lmd->isMainModule('step1.index')) {
        Answer::setOriginal(array());
    }

    // 同じ患者を参照している時は、これ以降の処理をスキップする
    if ($answer_code == Answer::getOriginal('answer_code')) return;

    $arr = Factory::load('DB/DAO_answers')->getInstance()->fetchNewest_BY_answer_code($answer_code);
    if ($arr) {
        $answer_id = $arr['answer_id'];

        // severity_level/risk_level/serious_level
        $mode = _isChild($arr['age']) ? Severity::CHILD : Severity::ADULT;
        $isRoleDoctor = _isRoleDoctor();

        $severity = Factory::load('App/Severity')->getInstance($mode);
        $severity->judge($answer_id, $severity, $isRoleDoctor);

        $arr['severitys']['severity_level'] = $severity->getSeverityLevel();
        $arr['severitys']['risk_level']     = $severity->getRiskLevel();
        $arr['severitys']['serious_level']  = $severity->getSeriousLevel();

        // hasOutpatientCarte
        $out = Factory::load('DB/DAO_outpatient_carte')->getInstance()->fetchAll_BY_answer_code($answer_code);
        $arr['hasOutpatientCarte'] = $out ? true : false;
    }

    Answer::setOriginal($arr ? $arr : array());
}

/**
 * 内因系の患者か否か
 */
function _isInternalSymptom()
{
    return (bool)($_SESSION['AnswerOriginal']['severitys']['serious_level'] === null);
}
/**
 * 外傷系の患者か否か
 */
function _isExternalSymptom()
{
    return ! _isInternalSymptom();
}

/**
 * 外来カルテのレコードが存在するか否か
 */
function _hasOutpatientCarte()
{
    return (bool)(isset($_SESSION['AnswerOriginal']['hasOutpatientCarte']) && $_SESSION['AnswerOriginal']['hasOutpatientCarte']);
}

function _setDoctorLastURL()
{
    global $lmd;

    $main_module = $lmd->getMainModule();
    switch ($main_module) {
        case 'doctor.top':
        case 'doctor_tab.exa':
            $_SESSION['doctor_last_url'][$main_module] = $lmd->httpHost(true).$lmd->httpRequestUri();
            break;
    }
}

function _getDoctorLastURL($main_module)
{
    if (isset($_SESSION['doctor_last_url'][$main_module]) && $_SESSION['doctor_last_url'][$main_module]) {
        return $_SESSION['doctor_last_url'][$main_module];
    } else {
        return '';
    }
}

function _getWhen($step31_when)
{
    $when = array();
    if ($step31_when) {
        foreach (explode(',', $step31_when) as $v) {
            list($key, $val) = explode(':', $v);
            $when[$key] = $val;
        }
    }

    return $when;
}

function _getCacheKey()
{
    $hash = md5(microtime());
    return sprintf("cid=%s", $hash);
}

if (isset($_REQUEST['cid'])) {
    output_add_rewrite_var('cid', $_REQUEST['cid']);
}

function _array_isset($array, $name, $def = '')
{
    return isset($array[$name]) ? $array[$name] : $def;
}


