<?php

$type = 2;

if (! $type) {
    $response = Factory::load('Response')->getInstance('json', array());
    $response->execute();
}

$dao = Factory::load('DB/DAO_tx_treatment')->getInstance();
$ite = Factory::load('DB/DAO_internal_tx_items')->getInstance();
$treatment = $dao->fetchAll_TreatmentList($type);
$category  = $dao->fetchAll_Category();
$group     = $dao->fetchAll_Group();

// {{{ 治療セットのエイリアスデータ生成
foreach ($group as $val) {
    if (! empty($val['alias_id'])) {
        $list = $ite->getRecipe($val['alias_id']);
        if (! empty($list)) {
            $done = array();
            foreach ($list as $v) {
                $name = $ite->getRecipeName($v);
                if (in_array($name, $done)) { continue; }
                $quant = ($v['weight_calc_flg'] && $v['kg_dose_min'] && $v['kg_dose_max']);
                $tx_treatment_id = 'set_diag_id';
                $tx_treatment_id .= '_' . $v['internal_tx_diagnosis_name_id'];
                $tx_treatment_id .= '_' . $v['internal_tx_item_id'];
                $tx_recipe_id = 'set_item_id';
                $tx_recipe_id .= '_' . $v['internal_tx_item_id'];
                $data = array(
                        'tx_treatment_id' => $tx_treatment_id,
                        'monshin_type'    => 2,
                        'tx_recipe_id'    => $tx_recipe_id,
                        'recipe_name'     => $name,
                        'quantity_flag'   => $quant ? 1 : 0,
                        'unit'            => $v['kg_dose_unit'],
                        'tx_group_id'     => $val['tx_group_id'],
                        'group_name'      => $val['group_name'],
                        'alias_id'        => $val['alias_id'],
                        'tx_category_id'  => $val['tx_category_id'],
                        'category_name'   => $val['category_name'],
                        );
                $treatment[] = $data;
                $done[] = $name;
            }
        }
    }
}
// }}}


$response = Factory::load('Response')->getInstance('json', array(
    'treatment' => $treatment,
    'category'  => $category,
    'group'     => $group,
));
$response->execute();


