<?php

$diagnosis_ids = $lmd->httpGet('diagnosis_ids', array());
$level         = $lmd->httpGet('level');
$weight        = $lmd->httpGet('weight');

if ( ! $diagnosis_ids || ! is_array($diagnosis_ids)) {
    $response = Factory::load('Response')->getInstance('json', array());
    $response->execute();
}

$dao = Factory::load('DB/DAO_internal_tx_items')->getInstance();
$dao->setLevel($level);
$res = $dao->getRecipe($diagnosis_ids[0]);

$data = array();
$idx  = 0;
foreach ($res as $v) {
    if ($v['level'.$level] === '') continue;

    $data[$idx] = $v;

    $data[$idx]['kg_dose_by_weight'] = '';
    if ($v['weight_calc_flg'] && $v['kg_dose_min'] && $v['kg_dose_max']) {
        $min_by_weight = preg_replace('/\.0$/', '', sprintf('%01.1f', $weight * $v['kg_dose_min']));
        $max_by_weight = preg_replace('/\.0$/', '', sprintf('%01.1f', $weight * $v['kg_dose_max']));
        $kg_dose_by_weight = ($min_by_weight === $max_by_weight) ? $min_by_weight : "{$min_by_weight} - {$max_by_weight}";
        $data[$idx]['kg_dose_by_weight'] = ($v['max_dose_max'] && $v['max_dose_max'] < $kg_dose_by_weight) ? $v['max_dose_max'] : $kg_dose_by_weight;
    }

    ++$idx;
}

$response = Factory::load('Response')->getInstance('json', $data);
$response->execute();
