<?php

$lmd->setResponse(array(
    'charset' => ini_get('default_charset') ? ini_get('default_charset') : 'utf-8',
    'title' => $lmd->param('title'),

    'card_number' => $lmd->param('card_number'),
));

$meta = '';
foreach ($lmd->param('meta', array()) as $v) {
    $meta .= $v."\n";
}

$link = '';
foreach ($lmd->param('link', array()) as $v) {
    $link .= $v."\n";
}

$script = '';
foreach ($lmd->param('script', array()) as $v) {
    $script .= $v."\n";
}

$lmd->setResponse(array(
    'meta'  => $meta,
    'link'  => $link,
    'script' => $script,
), Lambda::INSANITATION);



$dao = Factory::load('DB/DAO_answers')->getInstance();
$answer_date = array();
foreach ($dao->fetchAll_answer_date() as $v) {
    $key = str_replace('-', '', $v['answer_date']);
    $answer_date[$key] = str_replace('-', '/', $v['answer_date']);
}

$buf = $dao->fetchNewest_BY_answer_code($_answer_code);
$answer_id = isset($buf['answer_id']) ? $buf['answer_id'] : '';

// 外来カルテ取得...
if (! $lmd->isMainModule('doctor.top')) {
    $dao   = Factory::load('DB/DAO_outpatient_carte')->getInstance();
    $cartes = $dao->fetchAll_BY_answer_code($_answer_code);
    $carte = $cartes ? $cartes[0] : array('data' => '');
} else {
    // ドクター側TOPの場合は、空のまま...
    $carte = array();
}

$lmd->setResponse(array(
    'age_div_u15' => in_array('u15', $_age_div),
    'age_div_o16' => in_array('o16', $_age_div),

    'diagnosis_done' => in_array('done', $_diagnosis),
    'diagnosis_yet'  => in_array('yet', $_diagnosis),

    'severity_l'  => in_array(Severity::LEVEL_LOW, $_severity),
    'severity_m'  => in_array(Severity::LEVEL_MIDDLE, $_severity),
    'severity_h'  => in_array(Severity::LEVEL_HIGH, $_severity),
    'severity_sh' => in_array(Severity::LEVEL_SUPERHIGH, $_severity),

    'sort' => $_sort, 

    'answer_id' => $answer_id, 

    'ymd'  => $_ymd,
    'answer_date' => $answer_date,
    'ans' => $buf,
    'carte' => $carte, 
    //'carte_data' => json_decode(isset($carte['data']) ? $carte['data'] : '', TRUE),

    'vital' => Factory::load('DB/DAO_vital_sign')->getInstance()->fetch_BY_answer_code($_answer_code),
));
