<?php

$dao = Factory::load(_isChild() ? 'DB/DAO_kiou_child' : 'DB/DAO_kiou_adult')->getInstance();
$Res = $dao->fetch_BY_answer_code($_answer_code);
$kiou = String::rh($Res);
$q17_disease    = (isset($Res['q17_disease']) && $Res['q17_disease']) ? unserialize($Res['q17_disease']) : array();
$q17_other_text = (isset($Res['q17_other_text']) && $Res['q17_other_text']) ? unserialize($Res['q17_other_text']) : '';

function convWarekiDate($timestamp, $date_flag = true)
{
    $epoch = strtotime($timestamp);
    $j = date('j', $epoch);
    $n = date('n', $epoch);
    $yyyy = date('Y', $epoch);

    $y = (int)$yyyy;
    if (1926 <= $y && $y <= 1988) {
        $wareki = 'S'. ($y - 1925);
    } elseif (1989 <= $y) {
        $wareki = 'H'. ($y - 1988);
    } else {
        $wareki = '';
    }

    if ($date_flag) {
        return sprintf('%s.%d.%d', $wareki, $n, $j);
    } else {
        return sprintf('%s.%d', $wareki, $n);
    }
}
?>

<style type="text/css">

#left-menu {
    position: fixed;
    top: 114px;
    left: 0px;
    width:130px;
    background: #ddd;
    padding: 5px 0;
}
#main-wrap, #cne_wrap, #flexible_frame, #ctrl-menu, .diagnosis_list {
    margin-left: 140px;
}
.left-menu-tbl {
    width: 120PX;
    border: 1px #888 solid;
    border-collapse: collapse;
    border-spacing: 0;
    margin: 0 auto;
}

.left-menu-tbl th {
    padding: 5px;
    border: #888 solid;
    border-width: 0 0 1px 1px;
    background: #bbb;
    font-weight: bold;
    line-height: 120%;
    text-align: left;
}
.left-menu-tbl td {
    padding: 5px;
    border: 1px #888 solid;
    border-width: 0 0 1px 1px;
    background: #fff;
    text-align: left;
    line-height: 1.4;
}

#lm_value_s {
    font-size: 12px;
}

//.list-row {
    display: block;
    width: 645px;
    /*border: 1px #000 solid;*/
    margin-left: 6px;
    padding: 10px;
    position: relative;
    top: -8px;
    float: left;
}
</style>

<div id="left-menu">
    <div style="width:130px; background-color:#ddd;">

        <table class="left-menu-tbl">

        <tr>
            <th style="background-color:#bbb; text-align:center">
                <a href="<?php echo APP_ROOT ?>/doctor_tab/history/?answer_code=<?php echo $_answer_code ?>&?KeepThis=true&TB_iframe=true&height=500&width=600" class="thickbox" title="受診歴">
                受診歴
                </a>
            </th>
        </tr>

        <tr>
            <td style="background-color:<?php echo $first['severity_color'] ?>">
                <a href="<?php echo APP_ROOT ?>/doctor_tab/exa?answer_code=<?php echo $first['answer_code'] ?>">
                <div id="lm_value_s">初診</div>
                <div id="lm_value_s"><?php echo convWarekiDate($first['timestamp']) ?></div>
                <div id="lm_value_s"><?php echo(empty($first['diagnosis']) ? $first['primaryShojo'] : $first['diagnosis']); ?></div>
                </a>
            </td>
        </tr>

        <?php $loop = 1; if($res): foreach($res as $v): if($loop > 5) break; ?>
        <tr>
            <td style="background-color:<?php echo $v['severity_color'] ?>">
                <a href="<?php echo APP_ROOT ?>/doctor_tab/exa?answer_code=<?php echo $v['answer_code'] ?>">
                <div id="lm_value_s"><?php echo convWarekiDate($v['timestamp']) ?></div>
                <div id="lm_value_s"><?php echo(empty($v['diagnosis']) ? $v['primaryShojo'] : $v['diagnosis']); ?></div>
                </a>
            </td>
        </tr>
        <?php ++$loop; endforeach; endif; ?>

        </table>



        <table class="left-menu-tbl">

        <tr>
            <th style="background-color:#bbb; text-align:center">
            既往歴
            </th>
        </tr>

        <?php if(_isChild()): ?>
            <?php if($q17_disease): foreach($q17_disease as $v): if((int)$v['value'] === 200) continue; /* 200:その他 */ ?>
            <tr>
                <td>
                    <?php if($v['y'] && $v['m']): ?>
                        <div id="lm_value_s"><?php echo convWarekiDate(date('Ymd', strtotime("{$v['y']}/{$v['m']}/1")), false) ?></div>
                    <?php endif; ?>
                    <div id="lm_value_s"><?php echo Resource::get('kiou_disease', $v['value'], '') ?></div>
                </td>
            </tr>
            <?php endforeach; endif; ?>

            <?php if($q17_other_text): $v = $q17_other_text; ?>
            <tr>
                <td>
                    <?php if($v['y'] && $v['m']): ?>
                        <div id="lm_value_s"><?php echo convWarekiDate(date('Ymd', strtotime("{$v['y']}/{$v['m']}/1")), false) ?></div>
                    <?php endif; ?>
                    <div id="lm_value_s"><?php echo $v['text'] ?></div>
                </td>
            </tr>
            <?php endif; ?>
        <?php else: ?>
            <?php if($kiou['diseases']): foreach(explode("\t", $kiou['diseases']) as $v): ?>
            <tr>
                <td>
                    <div id="lm_value_s"><?php echo $v ?></div>
                </td>
            </tr>
            <?php endforeach; endif; ?>
        <?php endif; ?>

        </table>



        <table class="left-menu-tbl">
        <tr>
            <th style="background-color:#bbb; text-align:center">
            入院歴
            </th>
        </tr>
        </table>



        <table class="left-menu-tbl">
        <tr>
            <th style="background-color:#bbb; text-align:center">
            処方歴
            </th>
        </tr>
        </table>



        <?php if(_isChild()): ?>
            <table class="left-menu-tbl">
            <tr>
                <th style="background-color:#bbb; text-align:center">
                予防接種歴
                </th>
            </tr>
            <tr>
                <td>
                    <div id="lm_value_s">
                    <?php 
                        $answers = array();
                        if ($kiou['q5']) foreach (explode(',', $kiou['q5']) as $v) {
                            if ($ret = Resource::get('child.yobou', $v)) {
                                if ($ret !== 'その他') $answers[] = Resource::get('child.yobou', $v);
                            }
                        }
                        if ($kiou['q5_other_text'] !== '') $answers[] = $kiou['q5_other_text'];
                        echo implode('、', $answers);
                    ?>
                    </div>
                </td>
            <tr>
            </table>
        <?php endif; ?>



        <table class="left-menu-tbl">
        <tr>
            <th style="background-color:#bbb; text-align:center">
            健診歴
            </th>
        </tr>
        </table>



    </div>
</div>

