<?php

Factory::import('App/Severity');

// 小児科(16歳未満)
$dis_child = Factory::load('DB/DAO_CarteDisRelationTable01')->getInstance();
// 内科(16歳以上)
$dis_adult = Factory::load('DB/DAO_INT_CarteDisRelationTable01')->getInstance();

//define('LPP', 30);
define('LPP', 999999);

// ページ番号初期化
$page = $lmd->httpGet('page', 1, '/^[0-9]+$/');

// offset, limit
$offset = ($page - 1) * LPP;
$limit  = LPP;



/**
 * doctor/top 以外は list.prep へ
 */
//if ($lmd->isMainModule('doctor_tab.history')) {
if ( ! $lmd->isMainModule('doctor.top')) {
    return $lmd->setResponse(array(
        'first' => $lmd->param('first'),
        'res' => $lmd->param('history'),
        'total_rows' => $lmd->param('total_rows'),
        'dis_child' => $dis_child,
        'dis_adult' => $dis_adult,
    ));
}



$age_div   = $_age_div;
$diagnosis = $_diagnosis;
$severity  = $_severity;
$sort      = $_sort;
$ymd       = $_ymd;

$dao = Factory::load('DB/DAO_answers')->getInstance();
$keys = array();
$keys['under16'] = in_array('u15', $age_div);
$keys['over16']  = in_array('o16', $age_div);
$keys['diagnosis_done'] = in_array('done', $diagnosis);
$keys['diagnosis_yet']  = in_array('yet', $diagnosis);
//$keys['severity_2']  = in_array('2', $severity);
//$keys['severity_4']  = in_array('4', $severity);
//$keys['severity_4h'] = in_array('4h', $severity);
//$keys['severity_5']  = in_array('5', $severity);
//$keys['severity_6']  = in_array('6', $severity);
//$buf = $dao->fetchAll_max_answer_id_DISTINCT_answer_code_BY_yyyymmdd($ymd, $keys);
$buf = $dao->fetchAll_max_answer_id_DISTINCT_answer_code_BY_yyyymmdd($ymd, $keys, $sort);
$ids = array();
foreach ($buf as $v) {
    $ids[] = $v['max_answer_id'];
}

$res = $ids ? $dao->fetchAll_LEFT_JOIN_severitys_LEFT_JOIN_outpatient_carte_BY_ids($ids, $sort, $offset, $limit) : array();
$total_rows = $dao->foundRows();

$lmd->setResponse(array(
    'res'  => $res,
    'total_rows' => $total_rows,
    'dis_child' => $dis_child,
    'dis_adult' => $dis_adult,
), Lambda::INSANITATION);

/*Factory::import('Pager2');
$lmd->setResponse(array(
    'pager' => Pager2::GETParam($page, $limit, $total_rows)
), Lambda::INSANITATION);*/

