<?php

/*

リスト一覧色付けに関して

1　外来カルテ記録が一件も無い場合
総合判定が超重症の場合・・・#FF7777
総合判定が重症の場合・・・#F4B3C2
総合判定が中等症の場合
　①リスクが高の場合・・・#F3BF88;
　②①以外の場合・・・#F8E58C
総合判定が軽症の場合・・・#EEFFDD
且つ、列内文字を黒にする

2　外来カルテ記録が一件以上ある場合
どの場合も、列色をsilver、文字を（＊）とする
＊黒とシルバーの中間でギャラタブで見やすいものを出してみてください


なお、判定結果、とは
超重症(=6)・重症(=5)・中等症(=4)・軽症(=2)
のことです。

----------
class
----------
超: severity_60
重: severity_50
中(高): severity_45
中: severity_40
軽: severity_20

*/

//Factory::import('App/Severity');

$res = $lmd->getResponse('res');
$res = $res ? $res : array();

foreach ($res as $k => $v) {
    list($severity_level, $risk_level) = getSeverityAndRisk($v['age'], $v['answer_id']);
    $res[$k]['severity_level'] = $severity_level;
    $res[$k]['risk_level']     = $risk_level;
    // 外来カルテ保存されているか、またはアセスメント[帰宅/処置検査後診察/入院]が指定されていれば、処理済み背景色とする
    $has_carte = $v['has_carte'] || (isset($v['assessment_flag']) && preg_match('/^[123]$/', $v['assessment_flag'])) ? TRUE : FALSE;
    $res[$k]['severity_color'] = Severity::getBackgroundColor($severity_level, $has_carte);
}

$response = array();
$response['res'] = $res;

$first = $lmd->getResponse('first');
if ( ! empty($first)) {
    list($severity_level, $risk_level) = getSeverityAndRisk($first['age'], $first['answer_id']);
    $first['severity_level'] = $severity_level;
    $first['risk_level']     = $risk_level;
    $first['severity_color'] = Severity::getBackgroundColor($severity_level, $first['has_carte']);
    $response['first'] = $first;
}

$lmd->setResponse($response);



if ( ! $lmd->isMainModule('doctor_tab.history') && ! $lmd->isMainModule('doctor.top')) {
    // doctor.left_menu へ遷移
    return $lmd->setPrep('doctor.left_menu');
}





function getSeverityAndRisk($age, $answer_id)
{
    $mode = _isChild($age) ? Severity::CHILD : Severity::ADULT;
    $isRoleDoctor = _isRoleDoctor();

    $severity = Factory::load('App/Severity')->getInstance($mode);
    $severity->judge($answer_id, $severity, $isRoleDoctor);
    $severity_level = $severity->getSeverityLevel();
    $risk_level     = $severity->getRiskLevel();

    return array($severity_level, $risk_level);
}
