<?php

$answer = $lmd->httpGet('answer'); // severity answer id
$level  = $lmd->httpGet('level');  // severity level
$pre_level = $lmd->httpGet('pre_level'); // pre severity level
$pre_risk = $lmd->httpGet('pre_risk');   // pre risk level
$user   = $lmd->httpGet('user');   // user_id

// デフォルトデータセット(エラーが発生した場合は、そのまま戻す)
$data = array(
    'level' => $pre_level,
    'image' => Severity::getLevelImage($pre_level, $pre_risk),
    'risk_level' => $pre_risk,
    'risk_text' => Severity::getRiskText($pre_risk),
);
if ($answer !== '' && $level !== '' && $user !== '') {
    $dao = Factory::load('DB/DAO_severitys')->getInstance();
    $svr = $dao->fetch_LEFT_JOIN_answers_BY_answer_id($answer);
    if (! empty($svr['severity_id'])) {
        $res = $dao->update_final_severity_AND_doctor_id_BY_id($svr['severity_id'], $level, $user);
        if ($res === TRUE) {
            $mode = _isChild($svr['age']) ? Severity::CHILD : Severity::ADULT;
            $app = Factory::load('App/Severity')->getInstance($mode);
            $app->judge($answer, $app, _isRoleDoctor());
            $level = $app->getSeverityLevel();
            $risk  = $app->getRiskLevel();
            $dao = Factory::load('DB/DAO_outpatient_carte')->getInstance();
            $car = $dao->fetchAll_BY_answer_code($svr['answer_code']);
            $has_carte = empty($car) ? '' : $svr['answer_code'];
            $data = array(
                'level' => $level,
                'image' => Severity::getLevelImage($level, $risk),
                'risk_level' => $risk,
                'risk_text' => Severity::getRiskText($risk),
                'color' => Severity::getBackgroundColor($level, $has_carte),
            );
        }
    }
}
$response = Factory::load('Response')->getInstance('json', $data);
$response->execute();

