<?php

$p = array();
$p['answer_code'] = $lmd->httpGet('answer_code');
$p['doctor_id']   = $lmd->httpGet('doctor_id');

$p['body_temperature']       = $lmd->httpGet('body_temperature');
$p['heart_rate']             = $lmd->httpGet('heart_rate');
$p['respiratory_rate']       = $lmd->httpGet('respiratory_rate');
$p['spo2']                   = $lmd->httpGet('spo2');
$p['room_air_flag']          = $lmd->httpGet('room_air_flag');
$p['o2_flag']                = $lmd->httpGet('o2_flag');
$p['o2']                     = $lmd->httpGet('o2');
$p['blood_pressure_lr_flag'] = $lmd->httpGet('blood_pressure_lr_flag');
$p['blood_pressure_low']     = $lmd->httpGet('blood_pressure_low');
$p['blood_pressure_high']    = $lmd->httpGet('blood_pressure_high');
$p['blood_pressure_l_low']   = $lmd->httpGet('blood_pressure_l_low');
$p['blood_pressure_l_high']  = $lmd->httpGet('blood_pressure_l_high');
$p['blood_pressure_r_low']   = $lmd->httpGet('blood_pressure_r_low');
$p['blood_pressure_r_high']  = $lmd->httpGet('blood_pressure_r_high');
$p['dx_flag']                = $lmd->httpGet('dx_flag');
$p['tx_flag']                = $lmd->httpGet('tx_flag');
$p['assessment_flag']        = $lmd->httpGet('assessment_flag');

// check empty '' for flag
// target columns only accept integer value or NULL
function checkflagandparse($p)
{
    $target = array('room_air_flag', 'o2_flag', 'blood_pressure_lr_flag',
                    'dx_flag', 'tx_flag', 'assessment_flag');
    foreach ($target as $name) {
        if (! preg_match('/^\d+$/', $p[$name])) {
            $p[$name] = NULL;
        }
    }
    return $p;
}

$dao = Factory::load('DB/DAO_vital_sign')->getInstance();
$res = $dao->update_BY_answer_code($p['answer_code'], checkflagandparse($p));
if (! $res) {
    // jquery の ajax にエラーとして認識させる
    header('HTTP/1.0 404 Not Found');
    exit('invalid request.');
}

exit;

