<?php
    $lmd->invokeModule('doctor.head', array(
        'title' => SITE_NAME,
        'card_number' => $card_number,
    ));
?>

<!-- {{{ Vital CSS -->
<script type="text/javascript">
$(function(){
    $('#vital input[type="checkbox"]').click(function(){
        vital.check_button($(this));
    });
    $('#vital input[type="radio"]').click(function(){
        var name = $(this).attr('name');
        $('#vital input[name="' + name + '"]').each(function(){
            vital.check_button($(this));
        });

    });
    $('#blood_pressure_lr_flag_label').click(function(){
        vital.check_blood($(this));
    });
    $('#vital input').change(function(){
        vital.update();
    });
    vital.check_default();

<?php if (_isRoleClerk()) : // 事務方は更新不可 ?>
    $('#vital input').attr('disabled', true);
<?php endif; ?>
});
var vital = {
    update: function() {
        var body_temperature = $('[name="body_temperature"]').val();
        var heart_rate = $('[name="heart_rate"]').val();
        var respiratory_rate = $('[name="respiratory_rate"]').val();
        var spo2 = $('[name="spo2"]').val();
        var room_air_flag = $('[name="room_air_flag"]').attr('checked') ? 1 : 0;
        var o2_flag = $('[name="o2_flag"]').attr('checked') ? 1 : 0;
        var o2 = $('[name="o2"]').val();
        // 血圧
        var blood_pressure_lr_flag = $('[name="blood_pressure_lr_flag"]').attr('checked') ? 1 : 0;
        var blood_pressure_low = $('[name="blood_pressure_low"]').val();
        var blood_pressure_high = $('[name="blood_pressure_high"]').val();
        // 左
        var blood_pressure_l_low = $('[name="blood_pressure_l_low"]').val();
        var blood_pressure_l_high = $('[name="blood_pressure_l_high"]').val();
        // 右
        var blood_pressure_r_low = $('[name="blood_pressure_r_low"]').val();
        var blood_pressure_r_high = $('[name="blood_pressure_r_high"]').val();
        if ($('#dx_flag_yes').attr('checked')) {
            var dx_flag = 1;
        } else if ($('#dx_flag_no').attr('checked')) {
            var dx_flag = 0;
        } else {
            var dx_flag = '';
        }
        if ($('#tx_flag_yes').attr('checked')) {
            var tx_flag = 1;
        } else if ($('#tx_flag_no').attr('checked')) {
            var tx_flag = 0;
        } else {
            var tx_flag = '';
        }
        if ($('#assessment_flag_home').attr('checked')) {
            var assessment_flag = 1;
        } else if ($('#assessment_flag_after').attr('checked')) {
            var assessment_flag = 2;
        } else if ($('#assessment_flag_enter').attr('checked')) {
            var assessment_flag = 3;
        } else {
            var assessment_flag = '';
        }
        $.ajax({
            type: 'GET',
            async: false,
            cache: false,
            url: '<?php echo APP_ROOT ?>/doctor/update_vital_sign_outcome',
            data: {
                'doctor_id' : '<?php echo(DocCookie::getUserId()); ?>',
                'answer_code' : '<?php echo($_answer_code); ?>',

                'body_temperature' : body_temperature,
                'heart_rate' : heart_rate,
                'respiratory_rate' : respiratory_rate,
                'spo2' : spo2,
                'room_air_flag' : room_air_flag,
                'o2_flag' : o2_flag,
                'o2' : o2,
                'blood_pressure_lr_flag' : blood_pressure_lr_flag,
                'blood_pressure_low' : blood_pressure_low,
                'blood_pressure_high' : blood_pressure_high,
                'blood_pressure_l_low' : blood_pressure_l_low,
                'blood_pressure_l_high' : blood_pressure_l_high,
                'blood_pressure_r_low' : blood_pressure_r_low,
                'blood_pressure_r_high' : blood_pressure_r_high,
                'dx_flag' : dx_flag,
                'tx_flag' : tx_flag,
                'assessment_flag' : assessment_flag
            },
            success: function(){
                // noop.
            }
        });
    },
    check_button: function(o) {
        if (o.attr('checked')) {
            o.prev().css({'color':'#0000ff','font-weight':'bold'});
        } else {
            o.prev().css({'color':'#000000','font-weight':'normal'});
        }
    },
    check_blood: function(o) {
        if (o.attr('checked')) {
            $('#blood_pressure_input').hide();
            $('#blood_pressure_lr_input').show();
        } else {
            $('#blood_pressure_input').show();
            $('#blood_pressure_lr_input').hide();
        }
    },
    check_default: function() {
        this.check_blood($('#blood_pressure_lr_flag_label'));
        $('#vital input[type="checkbox"], #vital input[type="radio"]').each(function(){
            vital.check_button($(this));
        });
    }
};
</script>



<!--ここからMI加藤手を入れる箇所-->



<style type="text/css">
.sub {
    vertical-align: sub;
}

/*    font-size: 0.8em;*/
/*    line-height: 1.7em;*/
#vital {
    width: 758px;
    border: 1px #E3E3E3 solid;
    margin: 0;
    padding: 0;
    font-size: 1.5em;
    line-height: 1.2em;
}

#vital input {
    width: 30px;
    border: 1px solid #ccc;
}

#vital input[type="radio"],
#vital input[type="checkbox"] {
    display: none;
}

#vital label {
    background-color:gainsboro;
}

#vital label[checked="checked"] {
    font-color: blue;
    font-weight: bold;
}

#vital .lname {
    font-weight: bold;
}

/*    height: 60px;*/
#vital .tr {
    margin: 0;
    padding: 0;
    height: 110px;
    border-bottom: #E3E3E3 solid 1px;
}

/*    height: 50px;*/
#vital .tr .th {
    margin: 0;
    padding: 5px;
    width: 129px;
    height: 100px;
    border-right: #E3E3E3 solid 1px;
    background: #F5F5F5;
    font-weight: bold;
    float: left;
}
#vital .tr .td {
    padding: 5px;
    float: left;
}

</style>
<!-- }}} Vital CSS -->

<style type="text/css">

table.table-01 {
    width: 760px;
    border: 1px #E3E3E3 solid;
    border-collapse: collapse;
    border-spacing: 0;
    /*margin: 0 auto;*/
}

table.table-01 th {
    padding: 5px;
    border: #E3E3E3 solid;
    border-width: 0 0 1px 1px;
    background: #F5F5F5;
    font-weight: bold;
    line-height: 120%;
    text-align: left;
}
table.table-01 td {
    padding: 5px;
    border: 1px #E3E3E3 solid;
    border-width: 0 0 1px 1px;
    text-align: left;
    line-height: 1.4;
}

.a_selected{
    color:#0000ff;
}
.a_unselected{
    color:#aaa;
}

.qa-area{
    border: 1px #E3E3E3 solid;
    width: 738px;
    /*margin: 0 auto;*/
    padding: 10px;
    line-height: 1.4;
}

#print-button {
    padding-left: 10px;
    float: right;
}
#print-button button {
    height: 30px;
    width: 120px;
}
</style>



<!--ここまでMI加藤手を入れる箇所-->



<link rel="stylesheet" href="<?php echo APP_ROOT; ?>/css/dropkick.css" type="text/css" media="all" />
<script src="<?php echo APP_ROOT; ?>/js/jquery.dropkick.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript" charset="utf-8">
<!--
var severity = {
    update: function(level){
        $.ajax({
            type: 'GET',
            async: false,
            cache: false,
            url: '<?php echo APP_ROOT ?>/doctor/update_severity',
            data: {
                'level' : level,
                'pre_level' : '<?php echo($severity_level); ?>',
                'pre_risk' : '<?php echo($risk_level); ?>',
                'user' : '<?php echo(DocCookie::getUserId()); ?>',
                'answer' : '<?php echo($severity_answer_id); ?>'
            },
            success: function(data){
                var level = data['level'];
                var image = data['image'];
                var risk_level = data['risk_level'];
                var risk_text  = data['risk_text'];
                $('#level-image').attr('src', image);
                $('#severity-risk').text(risk_text);
                $('#severity-level option').each(function(){
                    if ($(this).attr('value') == level) {
                        $(this).attr('selected', true);
                    }
                });
                var severity_text = $('#severity-level option:selected').text();
                $('.dk_label').text(severity_text);
            }
        });
    }
};
$(function(){
    $('.level').dropkick({
        change: function(){
            severity.update($(this).val());
        }
    });
    $('.dk_toggle').css({
        width: '50px'
    });
});
//-->
</script>

<?php
    $lmd->invokeModule('doctor.left_menu');
?>

<?php if (Device::isIos()) : ?>
<!--
<script type="text/javascript" src="<?php echo APP_ROOT ?>/js/iscroll.js"></script>
<script type="text/javascript">
var myScroll;
var a = 0;
function loaded() {
    setHeight();
    myScroll = new iScroll('main-wrap', {desktopCompatibility:true});
}
function setHeight() {
    var headerH = 100,
        footerH = 0,
        wrapperH = window.innerHeight - headerH - footerH;
    document.getElementById('wrapper').style.height = wrapperH + 'px';
}
window.addEventListener('onorientationchange' in window ? 'orientationchange' : 'resize', setHeight, false);
document.addEventListener('touchmove', function (e) { e.preventDefault(); }, false);
document.addEventListener('DOMContentLoaded', loaded, false);
</script>
<style type="text/css">
#wrapper {
    position:relative;
    z-index:1;
    width:100% ;
    overflow:hidden;
}

</style>
-->

<div id="wrapper"><!-- wrapper -->
<?php endif; ?>

<div id="main-wrap" style="float:left">
<?php if (_isAgent()) : // 代理入力の場合のみ表示 ?>
<p id="list-button"><button onclick="location.href='<?php echo APP_ROOT ?>/doctor/top';">受診一覧</button></p>
<p id="next-button"><button onclick="location.href='<?php echo APP_ROOT ?>/agent/login';">次の問診をする</button></p>
<?php endif; ?>
<p id="print-button"><button onclick="window.print();">印刷ボタン</button></p>

<?php if (_isAgent()) : // {{{ 代理入力の場合のみ処置対応(患者説明)を表示 ?>
<link rel="stylesheet" href="<?php echo APP_ROOT; ?>/css/agent_exa.css" type="text/css" media="all" />
<?php
    foreach ($zenshin_diagnosis_arr as $k => $v) {
        if ($v['TreatmentContents'] === '特にありません。') unset($zenshin_diagnosis_arr[$k]);
    }
 ?>
<?php if($zenshin_diagnosis_arr): ?>
    <div class="qa-area">
    <h2>全身状態</h2>
    <?php foreach($zenshin_diagnosis_arr as $v): ?>
        <p><?php echo $v['TreatmentContents'] ?></p>
    <?php endforeach; ?>
    </div>
<?php endif; ?>
<?php if($shojo_diagnosis_arr): ?>
    <div class="qa-area">
    <h2>症状</h2>
    <?php foreach($shojo_diagnosis_arr as $v): ?>
        <p><?php echo $v['TreatmentName'] ?></p>
    <?php endforeach; ?>
    </div>
<?php endif; ?>
<?php if($fever_diagnosis): ?>
    <div class="qa-area">
    <h2>発熱</h2>
    <p><?php echo $fever_diagnosis['TreatmentName'] ?></p>
    </div>
<?php endif; ?>
<?php if($gaisho_diagnosis_arr): ?>
    <div class="qa-area">
    <h2>外傷①</h2>
    <?php foreach($gaisho_diagnosis_arr as $v): ?>
        <p><?php echo $v['InjuryCommonTreat'] ?></p>
    <?php endforeach; ?>
    </div>
<?php endif; ?>
<?php if($gaisho_detail_diagnosis_arr): ?>
    <div class="qa-area">
    <h2>外傷②</h2>
    <?php foreach($gaisho_detail_diagnosis_arr as $v): ?>
        <p><?php echo $v['InjuryDetailTreat'] ?></p>
    <?php endforeach; ?>
    </div>
<?php endif; ?>
<?php if($goin_diagnosis_text): ?>
    <div class="qa-area">
    <h2>誤飲</h2>
    <p><?php echo $goin_diagnosis_text ?></p>
    </div>
<?php endif; ?>
<?php endif; // }}} ?>

<table width="760" class="table-01">
<tr>
<th>診察券番号</th>
<td colspan="3"><?php echo $card_number ?></td>
<td colspan="4" rowspan="3" style="text-align:center; vertical-align: middle; padding: 0px;">
    <img id="level-image" src="<?php echo(Severity::getLevelImage($severity_level, $risk_level)); ?>" width="60%" />
</td>
</tr>
<tr>
<th>主訴</th>
<td colspan="3">
<?php echo $primaryShojo ?>
<?php if($s3_other_disease !== ''): ?>
    (<?php echo $s3_other_disease ?>)
<?php endif; ?>
</td>
</tr>
<tr>
<th>判定</th>
<td colspan="3">
<?php if (_isRoleClerk()) : // 事務は編集不可 ?>
    <div style="float:left;width:50px;"><?php echo(Severity::getSeverityText($severity_level)); ?></div>
    <div style="float:left;"> / <?php echo(Severity::getRiskText($risk_level)); ?></div>
<?php else : ?>
<?php
    $fe = new FormElement(Resource::get('severity.level'));
    $fe->setDefault($severity_level);
    $fe->select('severity-level', array('id' => 'severity-level', 'class' => 'level', 'tabindex' => '1'));
?>
&nbsp;/&nbsp;
<span id="severity-risk"><?php echo(Severity::getRiskText($risk_level)) ?></span>
<?php endif; ?>
</td>
</tr>
<tr>
<th>生年月日</th>
<td><?php echo $birth_y ?>/<?php echo $birth_m ?>/<?php echo $birth_d ?></td>
<th>年齢</th>
<td><?php echo _getAgeNotation($life_days) ?></td>
<th>体温</th>
<td><?php echo $nowtemp ?></td>
<th>体重</th>
<td><?php echo $weight ?></td>
</tr>
</table>

<div id="vital"><!-- vital -->
    <div class="tr" id="vitalsign">
        <div class="th">Vital Sign</div>
        <div class="td">
            [体温 <input type="text" name="body_temperature" value="<?php echo(_array_isset($vital, 'body_temperature')); ?>" /> ℃]
            [脈拍 <input type="text" name="heart_rate" value="<?php echo(_array_isset($vital, 'heart_rate')); ?>" /> 回/分]
            [呼吸 <input type="text" name="respiratory_rate" value="<?php echo(_array_isset($vital, 'respiratory_rate')); ?>" /> 数回/分]
<br>
            [SpO<span class="sub">2</span>
                <input type="text" name="spo2" value="<?php echo(_array_isset($vital, 'spo2')); ?>" />
                %(
                <label for="room_air_flag_label">room air</label>
                <input type="checkbox" id="room_air_flag_label" name="room_air_flag" value="1" <?php echo(_array_isset($vital, 'room_air_flag') == 1 ? ' checked="checked"' : ''); ?>/>
                &nbsp;
                <label for="o2_flag_label">O<span class="sub">2</span></label>
                <input type="checkbox" id="o2_flag_label" name="o2_flag" value="1" <?php echo(_array_isset($vital, 'o2_flag') == 1 ? ' checked="checked"' : ''); ?>/>
                /
                <input type="text" name="o2" value="<?php echo(_array_isset($vital, 'o2')); ?>" />
            L )]
            <br />
            <label for="blood_pressure_lr_flag_label">　左右別　</label>
            &nbsp;
            <input type="checkbox" value="1" name="blood_pressure_lr_flag" id="blood_pressure_lr_flag_label" <?php echo(_array_isset($vital, 'blood_pressure_lr_flag') == 1 ? ' checked="checked"' : ''); ?>/>
            <span id="blood_pressure_input">
                血圧
                <input type="text" name="blood_pressure_low" value="<?php echo(_array_isset($vital, 'blood_pressure_low')); ?>" />
                /
                <input type="text" name="blood_pressure_high" value="<?php echo(_array_isset($vital, 'blood_pressure_high')); ?>" />mmHg
            </span>
            <span id="blood_pressure_lr_input">
                血圧
                (左) <input type="text" name="blood_pressure_l_low" value="<?php echo(_array_isset($vital, 'blood_pressure_l_low')); ?>" />
                / <input type="text" name="blood_pressure_l_high" value="<?php echo(_array_isset($vital, 'blood_pressure_l_high')); ?>" /> mmHg
                (右) <input type="text" name="blood_pressure_r_low" value="<?php echo(_array_isset($vital, 'blood_pressure_r_low')); ?>" />
                / <input type="text" name="blood_pressure_r_high" value="<?php echo(_array_isset($vital, 'blood_pressure_r_high')); ?>" /> mmHg
            </span>
        </div>
    </div>
    <div class="tr" id="outcome">
        <div class="th">Outcome</div>
        <div class="td">
            <span class="lname">検査</span>&nbsp;&nbsp;
            <label for="dx_flag_yes">　あり　</label>
            <input type="radio" id="dx_flag_yes" name="dx_flag" value="1" <?php echo(_array_isset($vital, 'dx_flag') === '1' ? ' checked="checked"' : ''); ?>/>
            <label for="dx_flag_no">　なし　</label>
            <input type="radio" id="dx_flag_no" name="dx_flag" value="0" <?php echo(_array_isset($vital, 'dx_flag') === '0' ? ' checked="checked"' : ''); ?>/>
            &nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;
            <span class="lname">処置</span>&nbsp;&nbsp;
            <label for="tx_flag_yes">　あり　</label>
            <input type="radio" id="tx_flag_yes" name="tx_flag" value="1" <?php echo(_array_isset($vital, 'tx_flag') === '1' ? ' checked="checked"' : ''); ?>/>
            <label for="tx_flag_no">　なし　</label>
            <input type="radio" id="tx_flag_no" name="tx_flag" value="0" <?php echo(_array_isset($vital, 'tx_flag') === '0' ? ' checked="checked"' : ''); ?>/>
            <br />
            <label for="assessment_flag_home">　　帰宅　　</label>
            <input type="radio" id="assessment_flag_home" name="assessment_flag" value="1" <?php echo(_array_isset($vital, 'assessment_flag') === '1' ? ' checked="checked"' : ''); ?>/>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <label for="assessment_flag_after">　処置検査後診察　</label>
            <input type="radio" id="assessment_flag_after" name="assessment_flag" value="2" <?php echo(_array_isset($vital, 'assessment_flag') === '2' ? ' checked="checked"' : ''); ?>/>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <label for="assessment_flag_enter">　　入院　　</label>
            <input type="radio" id="assessment_flag_enter" name="assessment_flag" value="3" <?php echo(_array_isset($vital, 'assessment_flag') === '3' ? ' checked="checked"' : ''); ?>/>
        </div>
    </div>
</div><!-- /vital -->

<?php if(isset($step2_questions) && $step2_questions): ?>
    <div class="qa-area">
    <?php foreach($step2_questions as $q_k => $q): ?>

        <p>■ <?php echo $q['GQContents'] ?><!/p><!--加藤ここpカット-->

        <?php foreach($step2_answers[$q['ClassID']] as $a): ?>

            <?php
                if (_isChild()) {
                    $checked = in_array($a['GAContentsID'], $step2_selected_answer) ? ' checked="checked"' : '';
                } else {
                    $checked = ($step2_selected_answer[$q_k] == $a['GAnswerID']) ? ' checked="checked"' : '';
                }
            ?>

            <!p><input type="radio"<?php echo $checked ?> disabled><!--加藤ここpカット-->
            <?php if($checked): ?>
                <span class="a_selected"><?php echo $a['GAContents'] ?></span>
            <?php else: ?>
                <span class="a_unselected"><?php echo $a['GAContents'] ?></span>
            <?php endif; ?>
            <!/p><!--加藤ここpカット-->

        <?php endforeach; ?>
</p><!--加藤ここp追加-->
    <?php endforeach; ?>

    </div>
<?php endif; ?>

<?php if(isset($step31_fever_diseases) && $step31_fever_diseases): ?>
    <div class="qa-area">
    <?php
        if ($step31_fever_diseases) {
            // 発熱
            $lmd->invokeModule('doctor_tab.exa.step31', array(
                'diseases'  => $step31_fever_diseases,
                'questions' => $step31_fever_questions,
                'answers'   => $step31_fever_answers,
                'fromtemp_div_id' => $fromtemp_div_id,
                'selected_answer' => $step31_selected_fever_answers,
            ));
        }
    ?>
    </div>
<?php endif; ?>

<?php if(isset($step31_diseases) && $step31_diseases): ?>
    <div class="qa-area">
    <?php
        $lmd->invokeModule('doctor_tab.exa.step31', array(
            'diseases'  => $step31_diseases,
            'questions' => $step31_questions,
            'answers'   => $step31_answers,
            'when' => $step31_when,
            'selected_answer' => $step31_selected_answer,
        ));
    ?>
    </div>
<?php endif; ?>

<?php if(isset($step212_injurys) && $step212_injurys): ?>
    <div class="qa-area">
    <?php foreach($step212_injurys as $v): $injury_id = $v['InjuryID']; ?>

        <p>■ <?php echo $v['InjuryName'] ?></p>

        <?php foreach($step212_questions[$injury_id] as $v2): $question_id = $v2['IQuestionID']; ?>

            <p style="padding-left:20px"><?php echo $v2['IQContents'] ?><!/p><!--加藤ここpカット-->

            <?php foreach($step212_answers[$question_id] as $v3): $answer_id = $v3['IAnswerID']; ?>

                <?php
                    $checked = in_array($v3['IAnswerID'], $step212_selected_answer) ? ' checked="checked"' : '';
                ?>

                <!p style="padding-left:40px"><input type="radio"<?php echo $checked ?> disabled><!--加藤ここpカット-->
                <?php if($checked): ?>
                    <span class="a_selected"><?php echo $v3['IAContents'] ?></span>
                <?php else: ?>
                    <span class="a_unselected"><?php echo $v3['IAContents'] ?></span>
                <?php endif; ?>
                <!/p><!--加藤ここpカット-->


            <?php endforeach; ?>
</p><!--加藤ここp追加-->
        <?php endforeach; ?>

    <?php endforeach; ?>
    </div>
<?php endif; ?>

<?php if(isset($step22_swallow_object) && $step22_swallow_object): ?>
    <div class="qa-area">

    <p>■ 誤飲<!/p><!--加藤ここpカット-->
    <font style="padding-left:10px"></font><!--加藤ここfont追加-->
    <!p class="a_selected" style="padding-left:20px"><?php echo $step22_swallow_object ?></p><!--加藤ここpカット-->

    </div>
<?php endif; ?>


<?php
    $lmd->invokeModule('doctor_tab.exa.kiou', array(
        'kiou' => $kiou,
        'q12_family' => $q12_family,
        'q13_family' => $q13_family,
    ));
?>

</div><!-- /main-wrap -->

<?php if (Device::isIos()) : ?>
</div><!-- /wraper -->
<?php endif; ?>

<br>
<br>
<br>
<br>
<br>
<script type="text/javascript">
<!--
$(function(){

    // {{{ ある／なし動的表示コントロール
    // 打った
    arunasi(4,29,'ある');
    arunasi(5,34,'痛がる');
    arunasi(6,37,'ある');
    arunasi(8,43,'ある');
    arunasi(9,47,'ある');
    arunasi(11,54,'ある');
    // 切った
    arunasi(18,100,'ある');
    // 挟んだ／つぶした
    arunasi(27,144,'ある');
    // 捻った
    arunasi(30,167,'ある');
    arunasi(32,174,'ある');
    // やけどした
    arunasi(63,374,'はい');
    // }}}
});
function arunasi(qid, nasival, arutext)
{
    // 回答項目「ある」のラベルを調整
    $('label[aruid="'+qid+'"]').each(function(){
        var txt = $(this).text().replace(arutext + '　', '');
        txt = txt.replace(arutext + '、', '');
        $(this).text(txt);
    });
    // 「ある」トリガーボタンテキストのセット
    $('[for="aru_item'+qid+'"]').text(arutext + '　　');
}

$(function(){
    // 未選択の回答を非表示にする
    $('.qa-area input:radio, .qa-area input:checkbox').each(function(){
        if ( ! $(this).attr('checked')) {
            $(this).hide();
            $(this).next().hide();
        }
    });
});
//-->
</script>

<?php
    $lmd->invokeModule('doctor.foot');
?>
