<?php

list($card_number, ) = explode('-', $_answer_code);
$dao = Factory::load('DB/DAO_family_history')->getInstance();
$family = $dao->fetchAll_BY_card_number($card_number);
function getAnswer()
{
    global $_answer_code;

    $dao = Factory::load('DB/DAO_answers')->getInstance();
    $answer = $dao->fetchNewest_LEFT_JOIN_severitys_BY_answer_code($_answer_code);

    return $answer;
}
$answer = getAnswer();

// JSONノードの作成
$cols = array('family_history_id', 'type', 'label', 'alive', 'age'
, 'serious_disease', 'serious_disease_name', 'serious_disease_y'
, 'serious_disease_status', 'gender_div_id', 'generation'
, 'twins_div_id', 'disease_status_div_id');

$node = array(
            'ff' => '{}',
            'fm' => '{}',
            'mf' => '{}',
            'mm' => '{}',
            'f' => '{}',
            'm' => '{}',
            'c' => array()
        );
foreach ($family as $val) {
    $tmp = array();
    foreach ($val as $k => $v) {
        if (in_array($k, $cols)) {
            $tmp[$k] = $v;
        }
    }
    // 年齢が指定されていない場合は、左寄せで表示する(JSで対応)
    //if ($tmp['age'] === '') {
    //    $tmp['age'] = '0';
    //}
    $json = json_encode($tmp);
    switch ($val['type']) {
        case 'F_GF' :
            $node['ff'] = $json;
            break;
        case 'F_GM' :
            $node['fm'] = $json;
            break;
        case 'M_GF' :
            $node['mf'] = $json;
            break;
        case 'M_GM' :
            $node['mm'] = $json;
            break;
        case 'FATHER' :
            $node['f'] = $json;
            break;
        case 'MOTHER' :
            $node['m'] = $json;
            break;
        default :
            $node['c'][] = $json;
    }
    if ($val['twins_div_id'] > 0) {
        $twins[$val['age']] = $val['twins_div_id'];
    }
}

// 自分(患者)のJSONデータ作成
if (! empty($family)) {
    $self = array(
        'family_history_id' => '9999999999',
        'type'  => 'SELF',
        'label' => '自分(患者)',
        'alive' => '10',
        'age'   => $answer['age'],
        'serious_disease' => '',
        'serious_disease_name' => '',
        'serious_disease_y' => '',
        'serious_disease_status' => '',
        'gender_div_id' => $answer['gender_div_id'],
        'generation' => '3',
        'twins_div_id' => isset($twins[$answer['age']]) ? $twins[$answer['age']] : '0',
        'disease_status_div_id' => '',
    );
    $node['c'][] = json_encode($self);
}

$lmd->setResponse(array(
    'node'   => $node,
    'family' => $family,
), Lambda::INSANITATION);
