<div id="family_canvas"></div>
<div id="family_ctrl">
    <input type="button" class="family_entry" value="家族図に追加する" />
    <div class="disease"></div>
    <div class="disease"></div>
    <div class="disease"></div>
</div>
<style type="text/css">
#family_canvas {
    float: left;
    margin-bottom: 10px;
    margin-right: 15px;
}
#family_ctrl {
    float: left;
    width: 400px;
    height: 150px;
}
#family_ctrl input[type="button"] {
    margin-bottom: 5px;
}
#family_comment {
    width: 400px;
    height: 150px;
}
</style>
<script type="text/javascript" src="<?php echo WEB_ROOT ?>/js/jquery.js"></script>
<script type="text/javascript" src="<?php echo WEB_ROOT ?>/js/raphael-min.js"></script>
<script type="text/javascript">
<!--

// {{{ Male
var Male = function(paper, size) {
    this.gender = 'male';
    this.paper = paper;
    this.size = size;
    this.half = size / 2;
    this.person = paper.rect(0, 0, size, size).attr({'stroke-width': 2});
    this.person.attr({fill: 'white'});
    this.pos = {x:0,y:0};
    this.display = true;
    this.update = false;
}
Male.prototype = {
    type: new Array(),
    info: {},
    parse: function() {
        if (this.info.family_history_id) {
            var attr = new Array();
            switch (this.info.disease_status_div_id) {
                case '2' :
                    attr.push('genetic');
                    break;
                case '3' :
                    attr.push('onset');
                    break;
                default :
                    attr.push('normal');
            }
            if (this.info.alive == '20') {
                attr.push('dead');
            }
            this.attr(attr.join(','));
            if (this.info.type == 'SELF') { return; }
            if (this.update) {
                var data = {
                                id    : this.info.family_history_id,
                                label : this.info.label,
                                age   : this.info.age
                           };
                var event = function(){
                    var mes = this.data('label') + "／" + this.data('age') + "歳\n";
                    mes += "編集しますか？";
                    if (confirm(mes)) {
                        var url = '<?php echo APP_ROOT ?>/doctor_tab/monshin?answer_code=<?php echo($_answer_code); ?>&fh_id=' + this.data('id');
                        window.location = url;
                    }
                };
                var mousein = function() {
                    console.log('mousein');
                };
                var mouseout = function() {
                    console.log('mouseout');
                };
                if (this.parts) {
                    this.paper.set(
                        this.person,
                        this.parts
                    ).click(event).data(data);
                    //).hover(mousein, mouseout).data(data);
                } else {
                    this.person.click(event).data(data);
                    //this.person.hover(mousein, mouseout).data(data);
                }
                this.person.attr({cursor: 'hand'});
            }
        }
    },
    moveTo: function(x, y) {
        this.person.attr({x:x, y:y});
        this.pos = {x:x,y:y};
    },
    attr: function(type) {
        var t = type.split(/,/);
        for (var i = 0; i < t.length; i++) {
            switch (t[i]) {
                case 'dead' :
                    this.dead();
                    break;
                case 'genetic' :
                    this.genetic();
                    break;
                case 'onset' :
                    this.onset();
                    break;
                default :
                    this.normal();
            }
        }
    },
    dead: function() {
        var pos = this.person.attr('x,y');
        var margin = 5;
        var sx = pos.x - margin;
        var sy = pos.y + margin + this.size;
        var ex = pos.x + margin + this.size;
        var ey = pos.y - margin;
        this.parts = this.paper.path('M' + sx + ' ' + sy + 'L' + ex + ' ' + ey).attr({'stroke-width': 2, 'stroke-linecap': 'round'});
        this.type.push('dead');
    },
    genetic: function() {
        var pos = this.person.attr('x,y');
        var size = this.size / 4;
        var margin = size * 2;
        var x = pos.x + margin;
        var y = pos.y + margin;
        this.parts = this.paper.circle(x, y, size).attr({fill: 'black'});
        this.type.push('genetic');
    },
    onset: function() {
        this.person.attr({fill: 'black'});
        this.type.push('onset');
    },
    normal: function() {
        if (this.parts) {
            this.parts.remove();
        }
        this.type = new Array('normal');
    },
    show: function() {
        this.display = true;
        this.person.attr({stroke: 'black'});
    },
    hide: function() {
        this.display = false;
        this.person.attr({stroke: 'white'});
    },
    pcenter: function(o) {
        var s = this.pside('center');
        var e = o.pside('center');
        var result = {
                        x: (s.x < e.x ? (s.x + ((e.x - s.x) / 2)) : (e.x + ((s.x - e.x) / 2))),
                        y: (s.y < e.y ? (s.y + ((e.y - s.y) / 2)) : (e.y + ((s.y - e.y) / 2)))
                     };
        return result;
    },
    pside: function(direction) {
        var result = this.pos;
        switch (direction) {
            case 'top' :
                result = {x:(this.pos.x + this.half), y:this.pos.y};
                break;
            case 'bottom' :
                result = {x:(this.pos.x + this.half), y:(this.pos.y + this.size)};
                break;
            case 'left' :
                result = {x:this.pos.x, y:(this.pos.y + this.half)};
                break;
            case 'right' :
                result = {x:(this.pos.x + this.size), y:(this.pos.y + this.half)};
                break;
            case 'center' :
                result = {x:(this.pos.x + this.half), y:(this.pos.y + this.half)};
                break;
            default :
        }
        return result;
    }
};
// }}}

// {{{ Female
var Female = function(paper, size) {
    this.gender = 'female';
    this.paper = paper;
    this.size = size;
    this.half = size / 2;
    this.person = paper.circle(0, 0, this.half).attr({'stroke-width': 2});
    this.person.attr({fill: 'white'});
    this.pos = {x:0,y:0};
    this.display = true;
    this.update = false;
}
Female.prototype = {
    type: new Array(),
    info: {},
    parse: function() {
        if (this.info.family_history_id) {
            var attr = new Array();
            switch (this.info.disease_status_div_id) {
                case '2' :
                    attr.push('genetic');
                    break;
                case '3' :
                    attr.push('onset');
                    break;
                default :
                    attr.push('normal');
            }
            if (this.info.alive == '20') {
                attr.push('dead');
            }
            this.attr(attr.join(','));
            if (this.info.type == 'SELF') { return; }
            if (this.update) {
                var data = {
                                id    : this.info.family_history_id,
                                label : this.info.label,
                                age   : this.info.age
                           };
                var event = function(){
                    var mes = this.data('label') + "／" + this.data('age') + "歳\n";
                    mes += "編集しますか？";
                    if (confirm(mes)) {
                        var url = '<?php echo APP_ROOT ?>/doctor_tab/monshin?answer_code=<?php echo($_answer_code); ?>&fh_id=' + this.data('id');
                        window.location = url;
                    }
                };
                var mousein = function() {
                    this.ca.style.cursor = 'pointer';
                };
                var mouseout = function() {
                    this.ca.style.cursor = 'auto';
                };
                if (this.parts) {
                    this.paper.set(
                        this.person,
                        this.parts
                    ).click(event)
                    //.hover(mousein, mouseout)
                    .data(data);
                } else {
                    this.person.click(event)
                    //.hover(mousein, mouseout)
                    .data(data);
                }
                this.person.attr({cursor: 'hand'});
            }
        }
    },
    moveTo: function(x, y) {
        var cx = x + this.half;
        var cy = y + this.half;
        this.person.attr({cx:cx, cy:cy});
        this.pos = {x:x,y:y};
    },
    attr: function(type) {
        var t = type.split(/,/);
        for (var i = 0; i < t.length; i++) {
            switch (t[i]) {
                case 'dead' :
                    this.dead();
                    break;
                case 'genetic' :
                    this.genetic();
                    break;
                case 'onset' :
                    this.onset();
                    break;
                default :
                    this.normal();
            }
        }
    },
    dead: function() {
        var pos = this.person.attr('cx,cy');
        var margin = 5;
        var sx = pos.cx - this.half - margin;
        var sy = pos.cy - this.half + margin + this.size;
        var ex = pos.cx - this.half + margin + this.size;
        var ey = pos.cy - this.half - margin;
        this.parts = this.paper.path('M' + sx + ' ' + sy + 'L' + ex + ' ' + ey).attr({'stroke-width': '2', 'stroke-linecap': 'round'});
        this.type.push('dead');
    },
    genetic: function() {
        var pos = this.person.attr('cx,cy');
        var size = this.size / 4;
        var margin = size / 32;
        var x = pos.cx + margin;
        var y = pos.cy + margin;
        this.parts = this.paper.circle(x, y, size).attr({fill: 'black'});
        this.type.push('genetic');
    },
    onset: function() {
        this.person.attr({fill: 'black'});
        this.type.push('onset');
    },
    normal: function() {
        if (this.parts) {
            this.parts.remove();
        }
        this.type = new Array('normal');
    },
    show: function() {
        this.display = true;
        this.person.attr({stroke: 'black'});
    },
    hide: function() {
        this.display = false;
        this.person.attr({stroke: 'white'});
    },
    pcenter: function(o) {
        var s = this.pside('center');
        var e = o.pside('center');
        var result = {
                        x: (s.x < e.x ? (s.x + ((e.x - s.x) / 2)) : (e.x + ((s.x - e.x) / 2))),
                        y: (s.y < e.y ? (s.y + ((e.y - s.y) / 2)) : (e.y + ((s.y - e.y) / 2)))
                     };
        return result;
    },
    pside: function(direction) {
        var result = this.pos;
        switch (direction) {
            case 'top' :
                result = {x:(this.pos.x + this.half), y:this.pos.y};
                break;
            case 'bottom' :
                result = {x:(this.pos.x + this.half), y:(this.pos.y + this.size)};
                break;
            case 'left' :
                result = {x:this.pos.x, y:(this.pos.y + this.half)};
                break;
            case 'right' :
                result = {x:(this.pos.x + this.size), y:(this.pos.y + this.half)};
                break;
            case 'center' :
                result = {x:(this.pos.x + this.half), y:(this.pos.y + this.half)};
                break;
            default :
        }
        return result;
    }
};
// }}}

// {{{ Family
var Family = {

    isRoleDoctor: <?php echo((_isRoleDoctor() ? 'true' : 'false')); ?>,

    canvas_size: {w:500, h:300},

    tree: { // {{{
        1 : {
            father : {
                father : {},
                mother : {}
            },
            mother : {
                father : {},
                mother : {}
            }
        },
        2 : {
            father : {},
            mother : {}
        },
        3 : []
    }, // }}}

    canvas: function(grand_num, child_num) { // {{{
        this.nsize = 30;
        this.ntop  = 30;
        this.nleft = 60;
        this.gtop = {1:this.ntop,2:this.ntop + 100,3:this.ntop + 210};
        this.gspn = {1:90,2:180,3:40};
        this.line_attr = {'stroke':'black','stroke-width':'2'};
        var canvas_name = 'family_canvas';
        var canvas_size = this.getCanvasSize(grand_num, child_num);
        this.ca = document.getElementById(canvas_name);
        this.setCanvasSize(canvas_size.w, canvas_size.h);
        this.paper  = Raphael(canvas_name, this.canvas_size.w, this.canvas_size.h);
        this.dis = Disease;
        this.dis.new();
    }, // }}}

    isNode: false,

    checkin: function(info, obj, t) { // {{{
        obj.info = info;
        obj.update = this.isRoleDoctor;
        if (! info.family_history_id) {
            obj.hide();
        } else {
            this.isNode = true;
        }
        if (info.type == 'SELF') {
            obj.info.self = true;
        }
        switch (t.length) {
            case 2 :
                this.tree[1][t[0]][t[1]] = obj;
                break;
            case 1 :
                this.tree[2][t[0]] = obj;
                break;
            default :
//console.log('===== ' + obj.info.family_history_id + ' =====');
                if (this.tree[3].length > 0) {
                    var tmp = new Array();
                    var twn = {};
                    var inj = false;
                    for (var i = 0; i < this.tree[3].length; i++) {
                        var child = this.tree[3][i];
//console.log('child age: ' + child.info.family_history_id + '.age = ' + child.info.age);
//console.log('child.age[' + child.info.age + '] > obj.info.age[' + obj.info.age + ']');
                        if (child.info.age === '') {
                            // 年齢が指定されていない場合は、そのままPUSH
                            tmp.push(child);
                        } else if (eval(child.info.age) > eval(obj.info.age)) {
                            // 年上
                            tmp.push(child);
//console.log(child.info.family_history_id + ' older than ' + obj.info.family_history_id);
                        } else if (child.info.age == obj.info.age) {
                            // 同年(双子)
                            if (child.info.gender_div_id == obj.info.gender_div_id) {
                                // 性別が同じ場合
                                if (obj.info.self) {
                                    // 患者がobjの場合
                                    if (! inj) { tmp.push(obj); }
                                    tmp.push(child);
                                } else {
                                    // 患者がchildの場合
                                    tmp.push(child);
                                    if (! inj) { tmp.push(obj); }
                                }
                            } else {
                                // 性別が異なる場合
                                if (obj.info.gender_div_id == 1) {
                                    // 男がobjの場合
                                    if (! inj) { tmp.push(obj); }
                                    tmp.push(child);
                                } else {
                                    // 男がchildの場合
                                    tmp.push(child);
                                    if (! inj) { tmp.push(obj); }
                                }
                            }
                            inj = true;
                        } else {
//console.log(obj.info.family_history_id + ' younger than ' + child.info.family_history_id);
                            // 年下
                            if (! inj) { tmp.push(obj); inj = true; }
                            tmp.push(child);
                        }
                    }
                    if (! inj) {
                        // 患者が末っ子の場合
                        tmp.push(obj);
                        inj = true;
                    }
                    for (var c in tmp) {
                        // 年齢別のグルーピング(双子用)
                        if (! twn[tmp[c].info.age]) {
                            twn[tmp[c].info.age] = new Array();
                        }
                        twn[tmp[c].info.age].push(c);
                    }
                    for (var age in twn) {
                        if (twn[age].length > 1) {
                            // ex. twn[12] = [0,1] see. 年齢別のグルーピング
                            for (var i = 0; i < twn[age].length; i++) {
                                var num = twn[age][i];
                                var cld = tmp[num];
                                if (cld.info.twins_flg != '0') {
                                    cld.twins = {};
                                    var kind = this.twins_kind(cld.info.twins_div_id);
                                    cld.twins.year = age;
                                    cld.twins.kind = kind;
                                    cld.twins.number = twn[age];
                                }
                            }
                        }
                    }
                    this.tree[3] = tmp;
                } else {
                    this.tree[3] = new Array(obj);
                }
//for (var x in this.tree[3]) {
//    console.log(this.tree[3][x].info.family_history_id);
//}
        }
    }, // }}}

    twins_kind: function(div_id) { // {{{
        switch (div_id) {
            case '1' :
                var kind = 'monozygotic';
                break;
            case '2' :
                var kind = 'dizygotic';
                break;
            default :
                var kind = false;
        }
        return kind;
    }, // }}}

    node: function(type, info) { // {{{
        switch (type) {
            case 'ff' :
                this.checkin(
                    info,
                    new Male(this.paper, this.nsize),
                    new Array('father','father')
                );
                break;
            case 'fm' :
                this.checkin(
                    info,
                    new Female(this.paper, this.nsize),
                    new Array('father','mother')
                );
                break;
            case 'mf' :
                this.checkin(
                    info,
                    new Male(this.paper, this.nsize),
                    new Array('mother','father')
                );
                break;
            case 'mm' :
                this.checkin(
                    info,
                    new Female(this.paper, this.nsize),
                    new Array('mother','mother')
                );
                break;
            case 'f' :
                this.checkin(
                    info,
                    new Male(this.paper, this.nsize),
                    new Array('father')
                );
                break;
            case 'm' :
                this.checkin(
                    info,
                    new Female(this.paper, this.nsize),
                    new Array('mother')
                );
                break;
            case 'c' :
                var obj = info.gender_div_id == 1 ? new Male(this.paper, this.nsize) : new Female(this.paper, this.nsize);
                this.checkin(
                    info,
                    obj,
                    new Array()
                );
                break;
            default :
        }
    }, // }}}

    setAsciiText: function(x,y,text,size) { // {{{
        this.paper.text(x,y,text).attr({'font-size':size});
    }, // }}}

    setNumber: function(p, num) { // {{{
        p.number = num;
        var size = 14;
        var pos = p.pside('bottom');
        this.setAsciiText(pos.x, (pos.y + size), num, size);
    }, // }}}

    setCursor: function(p) { // {{{
        var sgap = 12;
        var egap = 2;
        var hgap = (sgap - egap) / 4;
        var pos = p.pside('bottom');
        var shift = 5;
        var s = {
                    x: (pos.x - (this.nsize / 2 + sgap)) + shift,
                    y: (pos.y + sgap) + shift
                };
        var e = {
                    x: (pos.x - (this.nsize / 2 + egap)) + shift,
                    y: (pos.y + egap) + shift
                };
        this.setRelationLine(s.x, s.y, e.x, e.y);
        this.setRelationLine(s.x+hgap, e.y, e.x, e.y);
        this.setRelationLine(e.x, s.y-hgap, e.x, e.y);
    }, // }}}

    setCanvasSize: function(w, h) { // {{{
        if (w < 600) {
            w = 600;
        }
        this.canvas_size = {w:w, h:h};
        this.ca.style.width  = w + 'px';
        this.ca.style.height = h + 'px';
    }, // }}}

    getCanvasSize: function(g, c) { // {{{
        var clen = this.gspn[3] * (c - 1);
        var glen = this.gspn[1] * (g - 1);
        if (clen > glen) {
            // 3世代目のWIDTHが大きい場合
            var len = clen;
            var cmid = clen / 2;
            var pmid = cmid - (this.gspn[2] / 2);
            var gmid = pmid - (this.gspn[1] / 2);
            this.indent = {
                            1: this.nleft + gmid,
                            2: this.nleft + pmid,
                            3: this.nleft
                        };
        } else {
            // 1世代目のWIDTHが大きい場合
            var len = glen;
            var gmid = glen / 2;
            var pmid = gmid - (this.gspn[2] / 2);
            var cmid = gmid - (clen / 2);
            this.indent = {
                            1: this.nleft,
                            2: this.nleft + pmid,
                            3: this.nleft + cmid
                        };
        }
        var size = {w:(len + (this.nleft * 2)), h:this.canvas_size.h};
        return size;
    }, // }}}

    draw: function() { // {{{
        this.setGenNumber();
        if (! this.isNode) { return; }
        // Grand...
        this.grand();
        // Parent...
        this.parent();
        // Child...
        this.children();
        // Disease Info...
        this.dis.draw();
    }, // }}}

    grand: function() { // {{{
        var l = this.indent[1];
        var n = 1;
        // Father.Father
        var ff = this.tree[1].father.father;
        ff.moveTo(l + (this.gspn[1] * 0), this.gtop[1]);
        ff.parse();
        if (ff.display) {
            this.setNumber(ff, n++);
            this.dis.set('ff', ff);
        }
        // Father.Mother
        var fm = this.tree[1].father.mother;
        fm.moveTo(l + (this.gspn[1] * 1), this.gtop[1]);
        fm.parse();
        if (fm.display) {
            this.setNumber(fm, n++);
            this.dis.set('fm', fm);
        }
        if (ff.display && fm.display) {
            this.married(ff, fm);
        }
        // Mother.Father
        var mf = this.tree[1].mother.father;
        mf.moveTo(l + (this.gspn[1] * 2), this.gtop[1]);
        mf.parse();
        if (mf.display) {
            this.setNumber(mf, n++);
            this.dis.set('mf', mf);
        }
        // Mother.Mother
        var mm = this.tree[1].mother.mother;
        mm.moveTo(l + (this.gspn[1] * 3), this.gtop[1]);
        mm.parse();
        if (mm.display) {
            this.setNumber(mm, n++);
            this.dis.set('mm', mm);
        }
        if (mf.display && mm.display) {
            this.married(mf, mm);
        }
    }, // }}}

    parent: function () { // {{{
        var l = this.indent[2];
        var n = 1;
        // Father
        var f = this.tree[2].father;
        f.moveTo(l + (this.gspn[2] * 0), this.gtop[2]);
        f.parse();
        this.child(this.tree[1].father.father, this.tree[1].father.mother, f);
        if (f.display) {
            this.setNumber(f, n++);
            this.dis.set('f', f);
        }
        // Mother
        var m = this.tree[2].mother;
        m.moveTo(l + (this.gspn[2] * 1), this.gtop[2]);
        m.parse();
        this.child(this.tree[1].mother.father, this.tree[1].mother.mother, m);
        if (m.display) {
            this.setNumber(m, n++);
            this.dis.set('m', m);
        }
        if (f.display && m.display) {
            this.married(f, m);
        }
    }, // }}}

    children: function() { // {{{
        var f = this.tree[2].father;
        var m = this.tree[2].mother;
        var c = this.tree[3];
        var l = this.indent[3];
        if (c.length == 1) {
            // 一人っ子の場合
            c[0].moveTo(l + (this.gspn[3] * 0), this.gtop[3]);
            c[0].parse();
            this.child(f, m, c[0]);
            return;
        }
        // 各childノードの移動(配置は先に行う必要あり。罫線の計算の為)
        for (var i = 0; i < c.length; i++) {
            c[i].moveTo(l + (this.gspn[3] * i), this.gtop[3]);
            c[i].parse();
            this.setNumber(c[i], (i + 1));
            this.dis.set('c', c[i]);
        }
        // 垂直線の分岐点を取得
        var vs = f.pcenter(m);
        var ve = {x: vs.x, y: this.gtop[3] - 30};
        // 各childノードの罫線出力
        var o = new Array();
        var mono = {};
        for (var i = 0; i < c.length; i++) {
            if (c[i].info.self) {
                this.setCursor(c[i]);
            }
            o.push(c[i].pside('top'));
            if (c[i].twins != undefined) {
                // 双子
                var year = c[i].twins.year;
                var kind = c[i].twins.kind;
                var nums = c[i].twins.number;
                var tpos = c[nums[0]].pcenter(c[nums[(nums.length-1)]]);
                var cline = {sx:tpos.x, sy:ve.y, ex:o[i].x, ey:o[i].y};
                if (kind == 'monozygotic') {
                    // 一卵性双生児
                    if (! mono[year]) {
                        mono[year] = new Array();
                    }
                    mono[year].push(c[i]);
                }
                if (i == 0) {
                    // 左端なので、水平線開始ポジションを取得
                    var hs = {x:tpos.x, y:ve.y};
                }
            } else {
                // 通常
                var cline = {sx:o[i].x, sy:ve.y, ex:o[i].x, ey:o[i].y};
            }
            this.setRelationLine(cline.sx, cline.sy, cline.ex, cline.ey);
            if (i == 0) {
                // 左端なので、水平線開始ポジションを取得
                var hs = {x:cline.sx, y:cline.sy};
            } else if (i == (o.length - 1)) {
                // 右端なので、水平線終了ポジションを取得
                var he = {x:cline.sx, y:cline.sy};
            }
        }
        // 垂直線
        this.setRelationLine(vs.x, vs.y, ve.x, ve.y);
        // 水平線
        this.setRelationLine(hs.x, hs.y, he.x, he.y);
        for (var y in mono) {
            // 一卵性双生児
            for (var i = 0; i < mono[y].length; i++) {
                var next = i + 1;
                if (mono[y][next]) {
                    var s = mono[y][i].pside('right');
                    var e = mono[y][next].pside('left');
                    this.setRelationLine(s.x, s.y, e.x, e.y);
                }
            }
        }
    }, // }}}

    setGenNumber: function() { // {{{
        var left = 30;
        var gh  = this.canvas_size.h / 3;
        var gt  = gh / 2;
        var top = {1:gt,2:(gh + gt),3:((gh * 2) + gt)};
        this.setAsciiText(left, top[1], 'I.', 18);
        this.setAsciiText(left, top[2], 'II.', 18);
        this.setAsciiText(left, top[3], 'III.', 18);
    }, // }}}

    setRelationLine: function(sx,sy,ex,ey) { // {{{
        this.paper.path("M" + sx + " " + sy + "L" + ex + " " + ey).attr(this.line_attr);
    }, // }}}

    married: function(a, b) { // {{{
        var apos = a.pside('right');
        var bpos = b.pside('left');
        this.setRelationLine(apos.x, apos.y, bpos.x, bpos.y);
    }, // }}}

    child: function(f, m, c) { // {{{
        if (! f.display && ! m.display) { return; }
        var s = f.pcenter(m);
        var e = c.pside('top');
        this.setRelationLine(s.x, s.y, e.x, e.y);
        if (! f.display) {
            var pos = m.pside('left');
            this.setRelationLine(s.x, s.y, pos.x, pos.y);
        }
        if (! m.display) {
            var pos = f.pside('right');
            this.setRelationLine(s.x, s.y, pos.x, pos.y);
        }
    }, // }}}

    rowline: function() { // {{{
        var attr = {'stroke': '#666', 'stroke-width': 1};
        var s = this.canvas_size.h / 3
        for (var i = 1; i <= 2; i++) {
            var h = s * i;
            this.paper.path("M0 " + h + "L" + this.canvas_size.w + " " + h).attr(attr);
        }
        this.ca.style.border = 'solid 1px black';
    }, // }}}

    scaleon: function() { // {{{
        var attr = {'stroke': '#ccc', 'stroke-width': 1};
        var span = this.nsize;
        for (var i = 0; i < this.canvas_size.h; i += span) {
            this.paper.path("M0 " + i + "L5 " + i).attr("stroke", "#ccc");
            this.paper.path("M" + this.canvas_size.w + " " + i + "L" + (this.canvas_size.w - 5) + " " + i).attr(attr);
        }
        for (var i = 0; i < this.canvas_size.w; i += span) {
            this.paper.path("M" + i + " 0L" + i + " 5").attr(attr);
            this.paper.path("M" + i + " " + this.canvas_size.h + "L" + i + " " + (this.canvas_size.h - 5)).attr(attr);
        }
    } // }}}

};
// }}}

// {{{ Disease
var Disease = {
    new: function() {
        this.ctrl = $('#family_ctrl');
    },
    node: {
        'ff' : {},
        'fm' : {},
        'mf' : {},
        'mm' : {},
        'f' : {},
        'm' : {},
        'c'  : []
    },
    set: function(kind, obj) {
        if (kind == 'c') {
            this.node[kind].push(obj);
        } else {
            this.node[kind] = obj;
        }
    },
    draw: function() {
        // Grand...
        var gen1 = this.ctrl.find('.disease:eq(0)');
        var txt1 = new Array();
        if (this.node['ff'].info && this.node['ff'].info.serious_disease_name) { txt1.push('I-' + this.node['ff'].number + '：' + this.text(this.node['ff'].info)); }
        if (this.node['fm'].info && this.node['fm'].info.serious_disease_name) { txt1.push('I-' + this.node['fm'].number + '：' + this.text(this.node['fm'].info)); }
        if (this.node['mf'].info && this.node['mf'].info.serious_disease_name) { txt1.push('I-' + this.node['mf'].number + '：' + this.text(this.node['mf'].info)); }
        if (this.node['mm'].info && this.node['mm'].info.serious_disease_name) { txt1.push('I-' + this.node['mm'].number + '：' + this.text(this.node['mm'].info)); }
        gen1.html(txt1.join('<br />'));
        // Parent...
        var gen2 = this.ctrl.find('.disease:eq(1)');
        var txt2 = new Array();
        if (this.node['f'].info && this.node['f'].info.serious_disease_name) { txt2.push('II-' + this.node['f'].number + '：' + this.text(this.node['f'].info)); }
        if (this.node['m'].info && this.node['m'].info.serious_disease_name) { txt2.push('II-' + this.node['m'].number + '：' + this.text(this.node['m'].info)); }
        gen2.html(txt2.join('<br />'));
        // Child...
        var gen3 = this.ctrl.find('.disease:eq(2)');
        var txt3 = new Array();
        for (var i in this.node['c']) {
            var child = this.node['c'][i];
            if (child.info.serious_disease_name) { txt3.push('III-' + child.number + '：' + this.text(child.info)); }
        }
        gen3.html(txt3.join('<br />'));
    },
    wareki: function(y) {
        y = eval(y);
        var reki = '';
        if (y <= 1911) {
            // 明治 1868.9.8 -
            reki = 'M' + (y - 1868);
        } else if (1912 <= y && y <= 1926) {
            // 大正 1912.7.30 -
            reki = 'T' + (y - 1911);
        } else if (1927 <= y && y <= 1988) {
            // 昭和 1926.12.25 -
            reki = 'S' + (y - 1925);
        } else if (1989 <= y) {
            // 平成 1989.1.8 -
            reki = 'H' + (y - 1988);
        }
        return reki;
    },
    text: function(info) {
        var res = info.serious_disease_name;
        res += '(' + this.wareki(info.serious_disease_y) + '〜)';
        return res;
    }
};
// }}}

// {{{ Entry
$(function() {
    if (Family.isRoleDoctor) {
        $('input.family_entry').click(function(){
            if (confirm('家族を新規登録しますか？')) {
                var url = '<?php echo APP_ROOT ?>/doctor_tab/monshin?answer_code=<?php echo($_answer_code); ?>&fh_id=new';
                window.location = url;
            }
        });
    } else {
        $('.family_entry').hide();
    }
});
// }}}

// {{{ Main Stream
// 家族図...
var g_num = 4;
var c_num = <?php echo($node['c'] ? count($node['c']) : 0); ?>;
Family.canvas(g_num, c_num);
// 1:祖父祖母
Family.node('ff', <?php echo($node['ff']); ?>);
Family.node('fm', <?php echo($node['fm']); ?>);
Family.node('mf', <?php echo($node['mf']); ?>);
Family.node('mm', <?php echo($node['mm']); ?>);
// 2:父母
Family.node('f', <?php echo($node['f']); ?>);
Family.node('m', <?php echo($node['m']); ?>);
// 3:子供
<?php foreach ($node['c'] as $child) : ?>
Family.node('c', <?php echo($child); ?>);
<?php endforeach; ?>
Family.draw();
Family.rowline();
Family.scaleon();
// }}}

//-->
</script>
