<?php
/**
 * 家族歴: Family History
 */

$v = $lmd->param('v');
$card_number = $lmd->param('card_number');
$fh_id = $lmd->param('fh_id');

$dao = Factory::load('DB/DAO_family_history')->getInstance();

// 各兄弟の数
$big_bro_num = $big_sis_num = $kid_bro_num = $kid_sis_num = 0;
foreach ($dao->fetchAll_BY_card_number($card_number) as $v) {
    switch ($v['class']) {
        case 'BIG_BRO':
            ++$big_bro_num;
            break;

        case 'BIG_SIS':
            ++$big_sis_num;
            break;

        case 'KID_BRO':
            ++$kid_bro_num;
            break;

        case 'KID_SIS':
            ++$kid_sis_num;
            break;
    }
}

// 初期値
$family_history_map = array(
    'F_GF' => array(
        'klass' => 'GRANDFATHER', 
        'label' => '父方祖父', 
    ), 
    'F_GM' => array(
        'klass' => 'GRANDMOTHER', 
        'label' => '父方祖母', 
    ), 
    'M_GF' => array(
        'klass' => 'GRANDFATHER', 
        'label' => '母方祖父', 
    ), 
    'M_GM' => array(
        'klass' => 'GRANDMOTHER', 
        'label' => '母方祖母', 
    ), 
    'FATHER' => array(
        'klass' => 'FATHER', 
        'label' => '父', 
    ), 
    'MOTHER' => array(
        'klass' => 'MOTHER', 
        'label' => '母', 
    ), 
);

foreach ($dao->fetchAll_BY_card_number($card_number) as $v) {
    $family_history_map[$v['type']] = array(
        'family_history_id' => $v['family_history_id'], 
        'checked' => true, 
        'klass' => $v['class'], 
        'label' => $v['label'], 
        'alive' => $v['alive'], 
        'cohabitation' => $v['cohabitation'], 
        'age' => $v['age'], 
        'serious_disease' => $v['serious_disease'], 
        'serious_disease_name' => $v['serious_disease_name'], 
        'serious_disease_y' => $v['serious_disease_y'], 
        'serious_disease_m' => $v['serious_disease_m'], 
        'serious_disease_d' => $v['serious_disease_d'], 
        'serious_disease_status' => $v['serious_disease_status'], 
        'allergy' => $v['allergy'], 
        'allergy_items' => ($v['allergy_items'] !== '') ? explode(',', $v['allergy_items']) : array(), 
        'allergy_y' => $v['allergy_y'], 
        'allergy_m' => $v['allergy_m'], 
        'allergy_d' => $v['allergy_d'], 
        'allergy_status' => $v['allergy_status'], 
        'card_number' => $v['self_card_number'], 
        'disease_status_div_id' => $v['disease_status_div_id'], 
        'divorce_flg' => $v['divorce_flg'], 
        'twins_div_id' => $v['twins_div_id'], 
    );
}

$lmd->setResponse(array(
    'v' => $v, 
    'big_bro_num' => $big_bro_num, 
    'big_sis_num' => $big_sis_num,
    'kid_bro_num' => $kid_bro_num,
    'kid_sis_num' => $kid_sis_num,
    'family_history_map' => json_encode($family_history_map), 
    'fh_id' => $fh_id, 
    'age' => Answer::getOriginal('age'), 
), Lambda::INSANITATION);
