

<div id="qlist"><!-- qlist -->

<?php if(_isDoctor()): ?>
    <form method="post" action="<?php echo WEB_ROOT ?>/doctor/family_history/save?answer_code=<?php echo $_answer_code ?>">
    <input type="hidden" name="card_number" value="<?php echo $v['card_number'] ?>">
<?php endif; ?>

<hr class="normal"><div class="bg-odd">
<p class="label-1 disuse_doctor">■ご兄弟の構成を教えてください。</p>

兄：
<?php
    $fe = Factory::load('FormElement')->getInstance(array(1 => 1, 2 => 2, 3 => 3));
    $fe->setDefault($big_bro_num);
    $fe->setFirst('', '--');
    $fe->select('BIG_BRO', array('class' => 'sib_count', 'title' => '兄', 'style' => 'width:80px'));
?>人
　
姉：
<?php
    $fe = Factory::load('FormElement')->getInstance(array(1 => 1, 2 => 2, 3 => 3));
    $fe->setDefault($big_sis_num);
    $fe->setFirst('', '--');
    $fe->select('BIG_SIS', array('class' => 'sib_count', 'title' => '姉', 'style' => 'width:80px'));
?>人
　
弟：
<?php
    $fe = Factory::load('FormElement')->getInstance(array(1 => 1, 2 => 2, 3 => 3));
    $fe->setDefault($kid_bro_num);
    $fe->setFirst('', '--');
    $fe->select('KID_BRO', array('class' => 'sib_count', 'title' => '弟', 'style' => 'width:80px'));
?>人
　
妹：
<?php
    $fe = Factory::load('FormElement')->getInstance(array(1 => 1, 2 => 2, 3 => 3));
    $fe->setDefault($kid_sis_num);
    $fe->setFirst('', '--');
    $fe->select('KID_SIS', array('class' => 'sib_count', 'title' => '妹', 'style' => 'width:80px'));
?>人
</div>

<hr class="normal"><div class="bg-even">
<p class="disuse_doctor">■ご家族の構成と持病［大きな病気、アレルギー、健在・他界］について教えてください。</p>
<div class="FAMILY_HISTORY"></div>
</div>

<?php if(_isDoctor()): ?>
    </form>
<?php else: ?>
    <div id="same_symptom_stage">
    <hr class="normal"><div class="bg-odd">
    ■同居のご家族で今回お子様と似た症状のある方はいらっしゃいますか？
    <div class="SAME_SYMPTOM"></div>
    </div>
    </div>
<?php endif; ?>

</div><!-- /qlist -->



<!-- Start of FamilyHistory -->
<script type="text/javascript">

$(function(){
    var map = <?php echo $family_history_map ?>;
    var age = '<?php echo $age ?>';

    FamilyHistory.render(map, age);

    // 兄弟姉妹の人数を変更した時
    $('.sib_count').change(function(){
        //$('.SIB').remove();
        $('.sib_count').each(function(){
            var name  = $(this).attr('name');
            var title = $(this).attr('title');
            var count = $(this).val();
            var map = {};
            if (count > 0) {
                for (var i = 1; i <= count; i++) {
                    (function(name, title, i){
                        if ($("[name='FH[" + name + i + "]']").attr('checked')) {
                            // noop.
                        } else if ($('#' + title + i).size() == 0) {
                            map[name + i] = {
                                klass : name, 
                                label : title + i
                            }
                        }
                    })(name, title, i);
                }

                // todo: 暫定対応
                //  不要な要素を削除する
                //   magic_number 9 = 各兄弟の最大人数で想定されない大きな数値
                for (i = i; i <= 9; i++) {
                    (function(title, i){
                        if ($('#' + title + i).size() > 0) {
                            $('#' + title + i).remove();
                        }
                    })(title, i);
                }
            } else {
                // todo: 暫定対応
                //  不要な要素を削除する
                //   magic_number 9 = 各兄弟の最大人数で想定されない大きな数値
                for (i = 1; i <= 9; i++) {
                    (function(title, i){
                        if ($('#' + title + i).size() > 0) {
                            $('#' + title + i).remove();
                        }
                    })(title, i);
                }
            }
            FamilyHistory.render(map, age);
        });

    });
});

FamilyHistory = {

    // 家族項目の描画
    render : function(map, age)
    {
        // すべての DOM を構築する
        for (var type in map) {

            var family_history_id = map[type].family_history_id;
            var klass = map[type].klass;
            var label = map[type].label;

            $('.FAMILY_HISTORY').append(
                '<a id="id-' + family_history_id + '"></a>' + 
                '<div class="'+klass+'" id="'+label+'">' + 
                this.getTypeCheckbox(type, label)
            );

            var div_indent_1 = $('<div>').attr('class', 'indent-1');
            $('.FAMILY_HISTORY')
                .append(this.getAliveRadio(type).appendTo(div_indent_1))
                .append(this.getCohabitationRadio(type, label).appendTo(div_indent_1))
                .append(this.getAgeSelect(type, age));

            $('.FAMILY_HISTORY').append(
                this.getSeriousDiseaseRadio(type) + 
                this.getSeriousDiseaseText(type) + 
                this.getDateSelect(type + '_serious_disease') + 
                this.getStatusRadio(type + '_serious_disease')
            );

            if (this.isSibling(type)) {
                $('.FAMILY_HISTORY').append(
                    this.getAllergyRadio(type) + 
                    this.getAllergyItemCheckbox(type) +
                    this.getDateSelect(type + '_allergy') + 
                    this.getStatusRadio(type + '_allergy')
                );
            } else {
                $('.FAMILY_HISTORY').append(
                    this.getAllergyRadio(type) + 
                    this.getAllergyItemCheckbox(type)
                );
            }

            $('.FAMILY_HISTORY').append(
                this.getCardNumber(type) + 
                <?php if(_isDoctor()): ?>
                    this.getDiseaseStatusSelect(type) + 
                    this.getDivorceFlagCheckBox(type, klass) + 
                    this.getTwinsDivIdSelect(type, klass) + 
                    this.getSubmitBtn(type) + 
                <?php endif; ?>
                '<hr></div>'
            );
        }

        // 離婚チェックボックスの振舞い設定
        this.behaveDivorceCheckBox();

        // 各家族項目の設定
        for (var type in map) {

            var checked = map[type].checked;

            // デフォルト値のセット
            this.setDefault(type, map[type]);

            (function(type, checked, age){

                // 大項目のチェックボックス以外、すべて非表示
                $("[id^='"+type+"']").hide();

                // 大項目のチェックボックスが押下された場合
                $("[name='FH["+type+"]']").click(function(){
                    if ($(this).attr("checked")) {
                        FamilyHistory.openItem(type, age);
                    } else {
                        $("[id^='"+type+"']").attr('checked', false);
                        $("input:text[name^='"+type+"']").val('');
                        $("[name^='"+type+"_card_number']").val('');
                        $("select[name^='"+type+"']").val('');
                        $("[id^='"+type+"']").hide();
                    }
                });

                // 健在 or 他界
                $("[name='"+type+"_alive']").click(function(){
                    if ($(this).val() == 10) { // 10: 健在
                        $("[id^='"+type+"_cohabitation']").show();
                    } else {
                        $("[id^='"+type+"_cohabitation']").attr('checked', false);
                        $("[id^='"+type+"_cohabitation']").hide();
                    }
                });

                // 大病： あり or なし
                $("[name='"+type+"_serious_disease']").click(function(){
                    if ($(this).val() == 10) { // 10: あり
                        $("[id^='"+type+"_serious_disease'],[name='"+type+"_serious_disease']").show();
                    } else {
                        $("[name='"+type+"_serious_disease_name']").val('');
                        $("select[name^='"+type+"_serious_disease']").val('');
                        $("[id^='"+type+"_serious_disease_status']").attr('checked', false);

                        $("[id^='"+type+"_serious_disease']").hide();
                        $("[id='"+type+"_serious_disease'],[name='"+type+"_serious_disease']").show();
                    }
                });

                // アレルギー： あり or なし
                $("[name='"+type+"_allergy']").click(function(){
                    if ($(this).val() == 10) { // 10: あり
                        $("[id^='"+type+"_allergy'],[name='"+type+"_allergy']").show();
                    } else {
                        $("[id^='"+type+"_allergy_items']").attr('checked', false);
                        $("select[name^='"+type+"_allergy']").val('');
                        $("[id^='"+type+"_allergy_status']").attr('checked', false);

                        $("[id^='"+type+"_allergy']").hide();
                        $("[id='"+type+"_allergy'],[name='"+type+"_allergy']").show();
                    }
                });

                if (checked) {
                    // 大項目をオープンする
                    FamilyHistory.openItem(type, age);
                }

            })(type, checked, age);
        }

        // 同居のご家族で今回お子様と似た症状のある方はいらっしゃいますか？
        FamilyHistory.renderSameSymptom();
        FamilyHistory.bindSameSymptom();

        // ハイライト
        $('input:checkbox, input:radio').click(function(){
            highlightCheckboxAndRadio();
        });
        highlightCheckboxAndRadio();

    },



    behaveDivorceCheckBox : function()
    {
        $("[name='F_GF_divorce_flg']").click(function(){
            $("[name='F_GM_divorce_flg']").attr('checked', $(this).attr('checked'));
        });
        $("[name='F_GM_divorce_flg']").click(function(){
            $("[name='F_GF_divorce_flg']").attr('checked', $(this).attr('checked'));
        });

        $("[name='M_GF_divorce_flg']").click(function(){
            $("[name='M_GM_divorce_flg']").attr('checked', $(this).attr('checked'));
        });
        $("[name='M_GM_divorce_flg']").click(function(){
            $("[name='M_GF_divorce_flg']").attr('checked', $(this).attr('checked'));
        });

        $("[name='FATHER_divorce_flg']").click(function(){
            $("[name='MOTHER_divorce_flg']").attr('checked', $(this).attr('checked'));
        });
        $("[name='MOTHER_divorce_flg']").click(function(){
            $("[name='FATHER_divorce_flg']").attr('checked', $(this).attr('checked'));
        });
    },

    setDefault : function(type, hash)
    {
        $("[name='FH["+type+"]']").attr('checked', hash.checked);
        $("[name='"+type+"_alive']").val([hash.alive]);
        $("[name='"+type+"_cohabitation']").val([hash.cohabitation]);
        $("[name='"+type+"_age']").val(hash.age);
        $("[name='"+type+"_serious_disease']").val([hash.serious_disease]);
        $("[name='"+type+"_serious_disease_name']").val(hash.serious_disease_name);
        $("[name='"+type+"_serious_disease_y']").val(hash.serious_disease_y);
        $("[name='"+type+"_serious_disease_m']").val(hash.serious_disease_m);
        $("[name='"+type+"_serious_disease_d']").val(hash.serious_disease_d);
        $("[name='"+type+"_serious_disease_status']").val([hash.serious_disease_status]);
        $("[name='"+type+"_allergy']").val([hash.allergy]);
        $("[name='"+type+"_allergy_items[]']").val(hash.allergy_items);
        $("[name='"+type+"_allergy_y']").val(hash.allergy_y);
        $("[name='"+type+"_allergy_m']").val(hash.allergy_m);
        $("[name='"+type+"_allergy_d']").val(hash.allergy_d);
        $("[name='"+type+"_allergy_status']").val([hash.allergy_status]);
        $("[name='"+type+"_card_number']").val(hash.card_number);
        $("[name='"+type+"_disease_status_div_id']").val(hash.disease_status_div_id);
        $("[name='"+type+"_divorce_flg']").val([hash.divorce_flg]);
        $("[name='"+type+"_twins_div_id']").val(hash.twins_div_id);
    },

    openItem : function(type, age)
    {
        $("[id^='"+type+"_alive']").show();
        $("[id^='"+type+"_age']").show();
        $("[id='"+type+"_serious_disease'],[name='"+type+"_serious_disease']").show();
        $("[id='"+type+"_allergy'],[name='"+type+"_allergy']").show();
        $("[id='"+type+"_card_number'],[name='"+type+"_card_number']").show();
        $("[id='"+type+"_disease_status_div_id'],[name='"+type+"_disease_status_div_id']").show();
        $("[id='"+type+"_divorce_flg'],[name='"+type+"_divorce_flg']").show();
        $("[id='"+type+"_twins_div_id'],[name='"+type+"_twins_div_id']").show();
        $("[id='"+type+"_submit'],[name='"+type+"_submit']").show();

        if (this.isSibling(type)) {
            // 兄弟姉妹は「健在」「同居」がデフォルト
            $("[name='"+type+"_alive']").val(['10'])
            $("[id^='"+type+"_cohabitation']").show();
            $("[name='"+type+"_cohabitation']").val(['10'])
        }

        if ($("[name='"+type+"_age']").val() === '') {
            // 年齢のデフォルト値がセットされてない場合
            switch (type) {
                // 小児：祖父母は「70歳」がデフォルト
                // 大人：祖父母は「自分の年齢＋40歳」がデフォルト
                case 'F_GF':
                case 'F_GM':
                case 'M_GF':
                case 'M_GM':
                    <?php if (_isChild()): ?>
                        $("[name='"+type+"_age']").val('70');
                    <?php else: ?>
                        var def_age = parseInt(age) + 40;
                        def_age = (def_age > this.getMaxAge()) ? this.getMaxAge() : def_age;
                        $("[name='"+type+"_age']").val(def_age);
                    <?php endif; ?>
                    break;

                // 小児：父母は30歳がデフォルト
                // 大人：父母は「自分の年齢＋25歳」がデフォルト
                case 'FATHER':
                case 'MOTHER':
                    <?php if (_isChild()): ?>
                        $("[name='"+type+"_age']").val('30');
                    <?php else: ?>
                        var def_age = parseInt(age) + 25;
                        def_age = (def_age > this.getMaxAge()) ? this.getMaxAge() : def_age;
                        $("[name='"+type+"_age']").val(def_age);
                    <?php endif; ?>
                    break;
            }
            if (this.isSibling(type)) {
                // 兄弟姉妹は自分の年齢がデフォルト
                    $("[name='"+type+"_age']").val(age);
            }
        }

        if ($("[name='"+type+"_alive']:checked").val() == 10) {
            // 健在
            $("[id^='"+type+"_cohabitation']").show();
        }

        if ($("[name='"+type+"_serious_disease']:checked").val() == 10) {
            // 大病: あり
            $("[id^='"+type+"_serious_disease'],[name='"+type+"_serious_disease']").show();
        }

        if ($("[name='"+type+"_allergy']:checked").val() == 10) {
            // アレルギー: あり
            $("[id^='"+type+"_allergy'],[name='"+type+"_allergy']").show();
        }
    },

    getTypeCheckbox : function(type, label)
    {
        var t = '';
        t += '<div>';
        t += '<input type="checkbox" name="FH['+type+']" value="'+label+'" id="x_'+type+'_0" /><label style="cursor:pointer" for="x_'+type+'_0">'+label+'</label>';
        t += '</div>';
        return t;
    },

    getAliveRadio : function(type)
    {
        var span_tag = $('<span>').attr('id', type+'_alive');

        var input_tag = $('<input>').attr({
            'type': 'radio',
            'name': type+'_alive',
            'value': 10,
            'id': type+'_alive_0'
        });
        var label_tag = $('<label>').attr('for', type+'_alive_0').css('cursor', 'pointer').text('健在');
        span_tag.append(input_tag);
        span_tag.append(label_tag);

        input_tag = $('<input>', {
            'type': 'radio',
            'name': type+'_alive',
            'value': 20,
            'id': type+'_alive_1'
        });
        label_tag = $('<label>').attr('for', type+'_alive_1').css('cursor', 'pointer').text('他界');
        span_tag.append(input_tag);
        span_tag.append(label_tag);

        return span_tag;
    },

    getCohabitationRadio : function(type, label)
    {
        var span_tag = $('<span>').attr('id', type+'_cohabitation').css('padding-left', '30px');

        var input_tag = $('<input>').attr({
            'type': 'radio',
            'name': type+'_cohabitation',
            'value': 10,
            'id': type+'_cohabitation_0',
            'typelabel': label
        });
        var label_tag = $('<label>').attr('for', type+'_cohabitation_0').css('cursor', 'pointer').text('同居');
        span_tag.append(input_tag);
        span_tag.append(label_tag);

        input_tag = $('<input>').attr({
            'type': 'radio',
            'name': type+'_cohabitation',
            'value': 20,
            'id': type+'_cohabitation_1',
            'typelabel': label
        });
        label_tag = $('<label>').attr('for', type+'_cohabitation_1').css('cursor', 'pointer').text('別居');
        span_tag.append(input_tag);
        span_tag.append(label_tag);

        return span_tag;
    },

    getAgeSelect : function(type, age)
    {
        var div = $('<div>').attr('id', type+'_age').text('年齢')
        var select = $('<select>').attr('name', type+'_age').css('width', '80px');

        var hash = this.getAge(type);
        for (var i in hash) {
            $('<option>').val(i).text(hash[i]).appendTo(select);
        }

        return div.append(select);
    },

    getSeriousDiseaseRadio : function(type)
    {
        var t = '';
        t += '<div id="'+type+'_serious_disease">';
        t += '大病：';
        t += '<input type="radio" name="'+type+'_serious_disease" value="10" id="'+type+'_serious_disease_0" /><label style="cursor:pointer" for="'+type+'_serious_disease_0">あり</label>';
        t += '<input type="radio" name="'+type+'_serious_disease" value="20" id="'+type+'_serious_disease_1" /><label style="cursor:pointer" for="'+type+'_serious_disease_1">なし</label>';
        t += '</div>';
        return t;
    },

    getSeriousDiseaseText : function(type)
    {
        var t = '';

        t += '<div class="indent-2">';

        t += '<div id="'+type+'_serious_disease_name">';
        t += '病名<input type="text" name="'+type+'_serious_disease_name" style="width:200px">';
        t += '</div>';

        return t;
    },

    getDateSelect : function(name)
    {
        var t = '';

        t += '<div>';

        t += '<span id="'+name+'_date">';

        t += '<select name="'+name+'_y" style="width:80px">';
        var hash = this.getWareki();
        for (var i in hash) {
            t += '<option value="' + i + '">' + hash[i] + '</option>';
        }
        t += '</select>年';

        t += '<select name="'+name+'_m" style="width:80px">';
        var hash = this.getMonths();
        for (var i in hash) {
            t += '<option value="' + i + '">' + hash[i] + '</option>';
        }
        t += '</select>月';

        /*
        t += '<select name="'+name+'_d" style="width:80px">';
        var hash = this.getDays();
        for (var i in hash) {
            t += '<option value="' + i + '">' + hash[i] + '</option>';
        }
        t += '</select>日';
        */

        t += 'から';
        t += '</span>';

        return t;
    },

    getStatusRadio : function(name)
    {
        var t = '';
        t += '<span id="'+name+'_status" style="padding-left:30px">';
        t += '<input type="radio" name="'+name+'_status" value="10" id="'+name+'_status_0" /><label style="cursor:pointer" for="'+name+'_status_0">完治</label>';
        t += '<input type="radio" name="'+name+'_status" value="20" id="'+name+'_status_1" /><label style="cursor:pointer" for="'+name+'_status_1">治療中</label>';
        t += '</span>';

        t += '</div>'; // end of "anonymous <div>"
        t += '</div>'; // end of "class indent-2"

        return t;
    },

    getAllergyRadio : function(type)
    {
        var t = '';
        t += '<div id="'+type+'_allergy">';
        t += 'アレルギー：';
        t += '<input type="radio" name="'+type+'_allergy" value="10" id="'+type+'_allergy_0" /><label style="cursor:pointer" for="'+type+'_allergy_0">あり</label>';
        t += '<input type="radio" name="'+type+'_allergy" value="20" id="'+type+'_allergy_1" /><label style="cursor:pointer" for="'+type+'_allergy_1">なし</label>';
        t += '</div>';
        return t;
    },

    getAllergyItemCheckbox : function(type)
    {
        var t = '';

        t += '<div class="indent-2">';

        t += '<div id="'+type+'_allergy_items">';
        t += '<input type="checkbox" name="'+type+'_allergy_items[]" value="10" id="'+type+'_allergy_items_0" /><label style="cursor:pointer" for="'+type+'_allergy_items_0">食物</label>';
        t += '<input type="checkbox" name="'+type+'_allergy_items[]" value="20" id="'+type+'_allergy_items_1" /><label style="cursor:pointer" for="'+type+'_allergy_items_1">喘息</label>';
        t += '<input type="checkbox" name="'+type+'_allergy_items[]" value="30" id="'+type+'_allergy_items_2" /><label style="cursor:pointer" for="'+type+'_allergy_items_2">アトピー</label>';
        t += '</div>';
        return t;
    },

    getCardNumber : function(type)
    {
        var t = '';
        t += '<div id="'+type+'_card_number">';
        t += '<div>当院の診察券番号<span class="disuse_doctor">があればご入力ください</span></div>';
        t += '<input type="number" name="'+type+'_card_number" style="width:200px">';
        t += '</div>';

        t += '</div>'; // end of "class indent-1"

        return t;
    },

    getDiseaseStatusSelect : function(type)
    {
        var t = '';
        t += '<div id="'+type+'_disease_status_div_id">遺伝病：';
        t += '<select name="'+type+'_disease_status_div_id" style="width:100px">';
        t += '<option value="1">--</option>';
        t += '<option value="2">遺伝子あり</option>';
        t += '<option value="3">発症</option>';
        t += '</select>';
        t += '</div>';
        return t;
    },

    getDivorceFlagCheckBox : function(type, klass)
    {
        switch (klass) {
            case 'BIG_BRO':
            case 'BIG_SIS':
            case 'KID_BRO':
            case 'KID_SIS':
                return '';
        }

        var t = '';
        t += '<div id="'+type+'_divorce_flg"><label style="cursor:pointer" for="'+type+'_divorce_flg_1">離婚</label>';
        t += '<input type="checkbox" name="'+type+'_divorce_flg" value="1" id="'+type+'_divorce_flg_1">';
        t += '</div>';
        return t;
    },

    getTwinsDivIdSelect : function(type, klass)
    {
        switch (klass) {
            case 'GRANDFATHER':
            case 'GRANDMOTHER':
            case 'FATHER':
            case 'MOTHER':
                return '';
        }

        var t = '';
        t += '<div id="'+type+'_twins_div_id">双子：';
        t += '<select name="'+type+'_twins_div_id" style="width:80px">';
        t += '<option value="0">--</option>';
        t += '<option value="1">一卵性</option>';
        t += '<option value="2">二卵性</option>';
        t += '</select>';
        t += '</div>';
        return t;
    },

    getSubmitBtn : function(type)
    {
        var t = '';
        t += '<div id="'+type+'_submit" style="text-align:center">';
        t += '<input type="submit" value="修正する">';
        t += '</div>';
        return t;
    },



    getWareki : function()
    {
        var recent = 120;

        var y = new Date().getYear();
        y = (y < 2000) ? y + 1900 : y;

        var buf = {'':'--'};
        for (var i = y - recent; i <= y; i++) {
            var wareki = '';
            if (1868 <= i && i <= 1911) {
                wareki = "明治" + (i - 1867);
            } else if (1912 <= i && i <= 1925) {
                wareki = "大正" + (i - 1911);
            } else if (1926 <= i && i <= 1988) {
                wareki = "昭和" + (i - 1925);
            } else if (1989 <= i) {
                wareki = "平成" + (i - 1988);
            }
            //$buf[$i] = "西暦{$i}年 ({$wareki})";
            buf[i] = wareki;
        }
        return buf;
    },

    getMonths : function()
    {
        var buf = {'':'--'};
        for (var i = 1; i <= 12; i++) {
            buf[i] = i;
        }
        return buf;
    },

    getDays : function()
    {
        var buf = {'':'--'};
        for (var i = 1; i <= 31; i++) {
            buf[i] = i;
        }
        return buf;
    },

    getAge : function(type)
    {
        var buf = {'':'--'};
        var min_age = 0;
        switch (type) {
            case 'F_GF':
            case 'F_GM':
            case 'M_GF':
            case 'M_GM':
            case 'FATHER':
            case 'MOTHER':
                min_age = 16;
            default:
        }
        for (var i = min_age; i <= this.getMaxAge(); i++) {
            buf[i] = i;
        }
        return buf;
    },

    getMaxAge : function()
    {
        return 180;
    },

    renderSameSymptom : function()
    {
        $('.SAME_SYMPTOM').empty();
        $('#same_symptom_stage').hide();

        var typelabel = '';
        var tag = '';
        var idx = 0;
        $("[name$='_cohabitation']").each(function(){
            if ($(this).attr('checked') && $(this).val() == 10) { // 10: 同居
                $('#same_symptom_stage').show();
                typelabel = $(this).attr('typelabel');
                tag  = '<input type="checkbox" name="same_symptoms[]" id="same_symptom_'+idx+'" value="'+typelabel+'">';
                tag += '<label style="cursor:pointer" for="same_symptom_'+idx+'">'+typelabel+'</label>　';
                $('.SAME_SYMPTOM').append(tag);
                ++idx;
            }
        });

        $("[id^='same_symptom']").click(function(){
            //highlightCheckbox();
            $(this).each(function(){
                if ($(this).attr('checked')) {
                    $(this).next().css({'color':'<?php echo PATIENT_CHECKED_COLOR ?>'});
                } else {
                    $(this).next().css({'color':'#000000'});
                }
            });
        });
    },

    bindSameSymptom : function()
    {
        $("[name^='FH['], [name$='_alive'], [name$='_cohabitation']").click(function(){
            FamilyHistory.renderSameSymptom();
        });
    }, 

    isSibling : function(type)
    {
        return type.match(/^(BIG_|KID_)/);
    }

}

<?php if(_isDoctor()): ?>
    $(function(){
        var fh_id = '<?php echo $fh_id ?>';
        if (isNaN(fh_id)) {
            // fh_id = new の時
            return;
        }
        var hashOffset = $('#id-' + fh_id).offset().top;
        setTimeout(function(){
            $('html,body').animate({
                scrollTop: hashOffset
            }, 1000);
        }, 1000);
        return false;
    });
<?php endif; ?>

</script>
<!-- End of FamilyHistory -->
