<?php
    $v = $lmd->param('v');
?>

<hr class="normal">
<div class="bg-odd">
<p class="label-1">■最近（1ヶ月以内）に海外に旅行に行きましたか？</p>
<?php
    $fe = Factory::load('FormElement')->getInstance(Resource::get('yesno'));
    $fe->setDefault(isset($v['q1']) ? $v['q1'] : '');
    $fe->setLabelTag('q1');
    $fe->setDelimiter('　');
    $fe->radio('q1', array('id' => 'q1'));
?>
<div id="q1-option1">
<hr class="dotted">
<div class="indent-1">
<p class="label-1">▼「はい」の場合、地域を教えてください</p>
<?php
    $fe = Factory::load('FormElement')->getInstance(Resource::get('country'));
    $fe->setDefault(isset($v['q1_a']) ? explode(',', $v['q1_a']) : '');
    $fe->setLabelTag('q1_a');
    $fe->setDelimiter('　');
    $fe->checkboxes('q1_a', array('id' => 'q1_a'), 3);
?>
<div id="q1-option2">
<hr class="dotted">
<p class="label-1">▼「その他」の場合、ご入力ください</p>
<input type="text" name="q1_a_text" value="<?php echo isset($v['q1_a_text']) ? $v['q1_a_text'] : '' ?>">
</div>
</div>
</div>
</div>
<script type="text/javascript">
$(function(){
    behaveAs_q1_a();
    behaveAs_q1_a_text();

    // 最近（1ヶ月以内）に海外に旅行に行きましたか？
    $("[name='q1']").click(function(){
        behaveAs_q1_a();
    });

    // 「はい」の場合、地域を教えてください
    $("[name='q1_a[]']").click(function(){
        behaveAs_q1_a_text();
    });
    /**
     * 最近（1ヶ月以内）に海外に旅行に行きましたか？
     */
    function behaveAs_q1_a()
    {
        if ($("[name='q1']:checked").val() == '10') { // 10: はい
            // はい
            $('#q1-option1').show();
        } else {
            // いいえ or 未選択
            $("[name='q1_a[]']").each(function(){
                $(this).removeAttr('checked');
            });
            $('#q1-option1').hide();
            highlightCheckbox();
        }

        // 「はい」の場合、地域を教えてください ⇒ その他
        behaveAs_q1_a_text();
    }

    /**
     * 海外旅行
     * 「はい」の場合、地域を教えてください ⇒ その他
     */
    function behaveAs_q1_a_text()
    {
        var flag = hasValueInCheckbox("[name='q1_a[]']", 80); // 80: その他
        logicalTextField(flag, '#q1-option2', "[name='q1_a_text']");
    }
});
</script>
