<?php
    $v = $lmd->param('v');
?>

<hr class="normal">
<div class="bg-odd">
<p class="label-1">■常用薬はありますか？</p>
<?php
    $fe = Factory::load('FormElement')->getInstance(Resource::get('yesno'));
    $fe->setDefault(isset($v['q16']) ? $v['q16'] : '');
    $fe->setLabelTag('q16');
    $fe->setDelimiter('　');
    $fe->radio('q16', array('id' => 'q16'));
?>
<div id="q16-option1">
<hr class="dotted">
<div class="indent-1">
<p class="label-1">▼「はい」の場合</p>
<?php
    $fe = Factory::load('FormElement')->getInstance(Resource::get('addiction_medicine'));
    $fe->setDefault(isset($v['q16_medicine']) ? explode(',', $v['q16_medicine']) : '');
    $fe->setLabelTag('q16_medicine');
    $fe->setDelimiter('　');
    $fe->checkboxes('q16_medicine', array('id' => 'q16_medicine'), 4);
?>
<div id="q16-option2">
<hr class="dotted">
<p class="label-1">▼「その他」の場合、ご入力ください</p>
<input type="text" name="q16_other_text" value="<?php echo isset($v['q16_other_text']) ? $v['q16_other_text'] : '' ?>">
</div>
</div>
</div>
</div>
<script type="text/javascript">
$(function(){
    // 常用薬はありますか
    behaveAs_q16();
    function behaveAs_q16()
    {
        if ($("[name='q16']:checked").val() == 10) { // 10: はい
            $('#q16-option1').show();
        } else {
            $('#q16-option1').hide();
            $("[name='q16_medicine[]']").attr('checked', false);
            logicalTextField(false, '#q16-option2', "[name='q16_other_text']");
        }
        highlightCheckbox();
    }
    $("[name='q16']").click(function(){
        behaveAs_q16();
    });

    // 常用薬はありますか ⇒ 「その他」
    behaveAs_q16_family();
    function behaveAs_q16_family()
    {
        var flag = hasValueInCheckbox("[name='q16_medicine[]']", 50); // 50: その他
        logicalTextField(flag, '#q16-option2', "[name='q16_other_text']");
    }
    $("[name='q16_medicine[]']").click(function(){
        behaveAs_q16_family();
    });
});
</script>
