<?php
    $v = $lmd->param('v');
?>

<hr class="normal">
<div class="bg-odd">
<p class="label-1">■今までにかかった病気はありますか？</p>
<p>
<input type="checkbox" value="on" id="q6_all">
<label style="cursor:pointer" for="q6_all">全てかかった</label>
</p>
<?php
    $fe = Factory::load('FormElement')->getInstance(Resource::get('child.byouki'));
    $fe->setDefault(isset($v['q6']) ? explode(',', $v['q6']) : '');
    $fe->setLabelTag('q6');
    $fe->setDelimiter('　');
    $fe->checkboxes('q6', array('id' => 'q6'), 6);
?>
<div id="q6-option1">
<hr class="dotted">
<div class="indent-1">
<p class="label-1">▼「その他」の場合、ご入力ください</p>
<input type="text" name="q6_text" value="<?php echo isset($v['q6_text']) ? $v['q6_text'] : '' ?>">
</div>
</div>
</div>
<script type="text/javascript">
$(function(){
    // 今までにかかった病気 ⇒ 全てかかった
    $('#q6_all').click(function(){
        if ($(this).attr('checked') === true) {
            $("[name='q6[]']").each(function(){
                if ($(this).val() == 60) { // 60: 特にない
                    $(this).attr('checked', false);
                } else {
                    $(this).attr('checked', true);
                }
            });
        } else {
            $("[name='q6[]']").attr('checked', false);
        }
        highlightCheckbox();
    });

    // 今までにかかった病気 ⇒ 「特にない」
    $('#q6_5').click(function(){
        if ($(this).attr('checked')) {
            $("[name='q6[]'], #q6_all").attr('checked', false);
            $(this).attr('checked', true);
        }
        highlightCheckbox();
    });

    // 今までにかかった病気 ⇒ 「特にない」以外
    $("[name='q6[]']").click(function(){
        var flag = false;
        $(this).each(function(){
            if ($(this).val() != 60) { // ! 60: 特にない 以外
                if ($(this).attr('checked')) {
                    $('#q6_5').attr('checked', false);
                    return false; // break;
                }
            } 
        });
        highlightCheckbox();
    });

    // 今までにかかった病気 ⇒ 「その他」
    behaveAs_q6();
    function behaveAs_q6()
    {
        var flag = hasValueInCheckbox("[name='q6[]']", 70); // 70: その他
        logicalTextField(flag, '#q6-option1', "[name='q6_text']");
    }
    $("[name='q6[]'], #q6_all").click(function(){
        behaveAs_q6();
    });
});
</script>
