<?php
/**
 * step1
 */
$prev_step = 0;
$step      = 1;
$next_step = 2;

Answer::removeForwardAnswer($step);

$lmd->setResponse(array(
    'prev_step' => $prev_step, 
    'step'      => $step, 
    'next_step' => $next_step, 
));

if ($lmd->hasHttpPost('card_number')) {
    // step0 からの遷移のため、代理入力フラグをOFFにする
    _setAgentFlag(false);
}

$card_number = '';
if ($lmd->hasHttpPost('back')) {
    // do nothing.
} elseif (_isAgent()){
    // 代理入力
    $user_name = DocCookie::getUserName();
    if ($user_name === '') $user_name = QQ_CARDNUMBER_PREFIX;
    Answer::set($prev_step, array(
        'card_number' => generateCardNumber($user_name), 
    ));
} elseif (_isDoctor()) {
    // ドクター側...
    Answer::set($prev_step, array(
        'card_number' => Answer::getOriginal('card_number'), 
    ));
} elseif ((int)$lmd->httpPost('next_step') === $step) {
    // 患者側...
    if ($lmd->hasHttpPost('nonmember_flg')) {
        // 診察券なし
        $card_number = generateCardNumber(NONMEMBER_CARDNUMBER_PREFIX);
    } else {
        $card_number = $lmd->httpPost('card_number');
    }
    Answer::set($prev_step, array(
        'card_number' => $card_number,
    ));
    // こちらは成育用なので目黒用のポートチェックは無効にします。
    //$port = Factory::load('App/PortCheck')->getInstance(IS_DEV);
    //$stat = $port->isPatient($card_number);
    //if ($stat == FALSE) {
    //    // ポート確認エラー...
    //    $err = $port->getError();
    //    $url = sprintf("/?card_number=%s&code=%s", urlencode($card_number), $err['code']);
    //    $mes = sprintf("card_number=%s&code=%s&msg=%s", $card_number, $err['code'], $err['msg']);
    //    Factory::load('App/Log')->getInstance()->put('PortError', $mes);
    //    header('Location: ' . $url);
    //    exit;
    //} else {
    //    // ポート確認OK...
    //    $port_res = $port->getPatientCode();
    //    list($patient_code, $insurance_no, $insurance_name) = explode('&', $port_res);
    //    Answer::set($prev_step, array(
    //        'card_number' => $card_number,
    //        'patient_code' => $patient_code,
    //        'insurance_no' => $insurance_no,
    //        'insurance_name' => $insurance_name,
    //    ));
    //}
} else {
    _invalidRequest();
}

$res = array();
$reg_date = '';
if ($card_number) {
    $dao = Factory::load('DB/DAO_answers')->getInstance();
    $res = $dao->fetchNewest_BY_card_number($card_number);
    if ($res) {
        list($reg_date, ) = explode(' ', $res['reg_datetime']);
        $reg_date = str_replace('-', '/', $reg_date);
    }
}

if (isset($_SERVER['HTTP_REFERER']) && strpos($_SERVER['HTTP_REFERER'], 'step2') !== false) {
    // noop.
    //  setp2から【戻る】ボタンで戻ってきた場合。
} elseif (_isDoctor()) {
    list($weight_int, $weight_float) = String::explode('.', Answer::getOriginal('weight', null, ''), 2);
    $lmd->setResponse(array(
        'is_repeater' => false,
        'birth_y' => Answer::getOriginal('birth_y'), 
        'birth_m' => Answer::getOriginal('birth_m'), 
        'birth_d' => Answer::getOriginal('birth_d'), 
        'gender_div_id' => Answer::getOriginal('gender_div_id'), 
        'weight_int'   => $weight_int, 
        'weight_float' => $weight_float, 
        'nowtemp'  => Answer::getOriginal('nowtemp'), 
        'maxtemp'  => Answer::getOriginal('maxtemp'), 
        'fromtemp' => Answer::getOriginal('fromtemp_div_id'), 
    ));
} else {
    list($weight_int, $weight_float) = String::explode('.', $res ? $res['weight'] : '', 2);
    $lmd->setResponse(array(
        'is_repeater' => $res ? true : false,
        'reg_date' => $reg_date,
        'birth_y' => $res ? $res['birth_y'] : '',
        'birth_m' => $res ? $res['birth_m'] : '',
        'birth_d' => $res ? $res['birth_d'] : '',
        'gender_div_id' => $res ? $res['gender_div_id'] : '',
        'weight_int'   => $weight_int, 
        'weight_float' => $weight_float, 
        'nowtemp'  => '',
        'maxtemp'  => '',
        'fromtemp' => '', 
    ));
}

// doctor / agent / patient
if (_isDoctor()) {
    if (_isAgent()) {
        $lmd->setPrep("step1.agent");
    } else {
        $lmd->setPrep("step1.doctor");
    }
} else {
    $lmd->setPrep("step1.index");
}



/**
 * 診察券番号の生成
 */
function generateCardNumber($prefix)
{
    return sprintf('%s_%s_%s', 
                $prefix, 
                substr(md5(microtime()), 0, 4), 
                date('ymd_His')
           );
}
