<?php
/**
 * step232
 * 患者側 : 救急外傷 選択画面
 */
$prev_step = 2;
$step      = 232;
$next_step = 235;

Answer::removeForwardAnswer($step);

if ($lmd->hasHttpPost('back')) {
    // do nothing.
} elseif ((int)$lmd->httpPost('next_step') === $step) {
    if ($prev_step === 2) {
        Answer::step2_answer2session($lmd);
        Answer::set($prev_step, array('isIshiki' => $lmd->httpPost('isIshiki')));
    }
} else {
    _invalidRequest();
}

$dao = Factory::load('DB/DAO_external_injury_type')->getInstance();

$node_id = 1; // 1: 外傷項目, 2: 交通外傷項目
$questions = $dao->fetchAllExternalInjuryType($node_id);

$lmd->setResponse(array(
    'prev_step' => $prev_step, 
    'step'      => $step, 
    'next_step' => $next_step, 
    'questions' => $questions, 
));

// for Doctor.
$lmd->setResponse(array(
    'orig_answers' => explode(',', Answer::getOriginal("step{$step}_answers", null, '')),
));
