<?php
/**
 * step233
 * 患者側 : 救急外傷 詳細画面
 */
$prev_step = 235;
$step      = 233;
$next_step = 231; // 外傷一般QAへ(交通外傷が含まれる場合は234へ:JSで変更)

Answer::removeForwardAnswer($step);

if ($lmd->hasHttpPost('back')) {
    // do nothing.
} elseif ((int)$lmd->httpPost('next_step') === $step // 共通項目画面入力あり
	    || (int)$lmd->httpGet('next_step') === $step // 共通項目画面スキップ
	) {
    $answers = array();
    foreach ($lmd->httpPost("step{$prev_step}", array()) as $q => $v) {
        $answers[$q] = $v;
    }
    Answer::set($prev_step, array('answers' => $answers));
} else {
    _invalidRequest();
}

$type_id = Answer::get(232, 'answers');

$dao = Factory::load('DB/DAO_external_injury_question')->getInstance();
$selection = $dao->fetchAllExternalInjuryQuestionWithAnswerSelection($type_id);

// 詳細項目スキップ処理(共通項目化により吸収されて詳細項目が無くなった外傷があるため)
if (empty($selection)) {
    // If no question for question_id, then skip to next step...
    $lmd->redirect(APP_ROOT . '/step' . $next_step . '?next_step=' . $next_step);
}

$injurys = $questions = $answers = array();
foreach ($selection as $val) {
    $questions[$val['external_injury_question_id']] = array(
                                                        'external_injury_question_id' => $val['external_injury_question_id'],
                                                        'question_name' => $val['question_name'],
                                                        'external_injury_type_id' => $val['external_injury_type_id'],
                                                        'select_type' => $val['select_type'],
                                                        );
    $answers[$val['external_injury_question_id']][] = $val;
    $injurys[$val['external_injury_type_id']] = $val['type_name'];
}

$parts = Factory::load('App/Parts')->getInstance();
$pgr1 = $parts->getGroupDataById(1);
$pgr2 = $parts->getGroupDataById(2);
$pgr3 = $parts->getGroupDataById(3);
$parts_group = array();
$parts_group[$pgr1['gid']] = $pgr1['name'];
$parts_group[$pgr2['gid']] = $pgr2['name'];
$parts_group[$pgr3['gid']] = $pgr3['name'];
$parts_question = array();
foreach ($parts->map as $key => $val) {
    if ($key == 18) { continue; } // 交通外傷はスキップ
    $parts_question[$val] = $key;
}



$lmd->setResponse(array(
    'prev_step' => $prev_step, 
    'step'      => $step, 
    'next_step' => $next_step, 
    'injurys' => $injurys, 
    'questions' => $questions, 
    'answers'   => $answers, 
    'parts_answers' => Resource::get('parts_answer_selection'),
    'parts_group' => $parts_group,
    'parts_question' => $parts_question,
));

// for Doctor.
$lmd->setResponse(array(
    'orig_answers' => explode(',', Answer::getOriginal("step{$step}_answers", null, '')),
));
