<?php
/**
 * step242: 大人(16歳以上)専用の既往歴2
 */

Factory::import('App/KiouAdult');

$prev_step = 241;
$step      = 242;
$next_step = 3;

Answer::removeForwardAnswer($step);

if ($lmd->hasHttpPost('back')) {
    // do nothing.
} elseif ((int)$lmd->httpPost('next_step') === $step) {
    $answers = array();
    foreach ($lmd->httpPost() as $k => $v) {
        if (preg_match('/^input_(\d+)$/', $k, $c)) {
            $answers[$c[0]] = $v;
        }
    }
    Answer::set($prev_step, array('answers' => $answers));
} else {
    _invalidRequest();
}

if (_isAgent() || _isDoctor()) {
    // 代理入力 | ドクター
    $lmd->redirect(APP_ROOT . '/step3');
}

$lmd->setResponse(array(
    'prev_step' => $prev_step, 
    'step'      => $step, 
    'next_step' => $next_step, 
));



$card_number = Answer::get(0, 'card_number');
list($def, $reg_date) = KiouAdult::getDefault($card_number);
$lmd->setResponse(array(
    'is_repeater' => $def ? true : false,
    'reg_date' => $reg_date,
));

$sort    = ADULT_KIOU_SORT;
$pos_use = ADULT_KIOU_POS;
$pos_val = 2;
$data = KiouAdult::getData($sort, $pos_use, $pos_val);

$DAT = json_encode($data);
if ($def) {
    $DEF = json_encode($def);
} else {
    /*
    前画面の選択肢によって「これまでに以下に当てはまる病気...」の項目を自動的にチェックする。

    [仕様]
    １）前画面で「血糖の異常」だったら「糖尿病」にチェック。
    　　かつ、定期的に薬を飲んでいたら「食事・運動療法のみ」を選択できないようにする。
    ２）前画面で「脂質の異常」だったら「高脂血症」にチェック。
    ３）前画面で「血圧の異常」でかつ「血圧の薬」を飲んでいたら「高血圧」にチェック。
    */
    $def = array();
    $step241_answers = Answer::get(241, 'answers');
    if (isTonyobyo($step241_answers)) {
        // 「糖尿病」にチェック
        $def['input_42'][] = 1; // 1:糖尿病
        if (hasJoyoyaku($step241_answers)) {
            // 「食事・運動療法のみ」を選択できないようにする。
            $lmd->setResponse(array(
                'disable_tonyo_1' => true, 
            ));
        }
    }
    if (isKoshikesho($step241_answers)) {
        // 「高脂血症」にチェック
        $def['input_42'][] = 3; // 3:高脂血症
    }
    if (isKoketsuatsu($step241_answers)) {
        // 「高血圧」にチェック
        $def['input_42'][] = 2; // 2:高血圧
    }

    $DEF = json_encode($def);
}

$lmd->setResponse(array(
    'DAT' => $DAT, 
    'DEF' => $DEF,
    'age' => Answer::get(2, 'age'), 
), Lambda::INSANITATION);



// input_7 = 1:血糖の異常
function isTonyobyo(Array $a)
{
    return (isset($a['input_7']) && in_array(1, $a['input_7']));
}

// input_9 = 1:現在定期的に飲んでいる薬はありますか⇒はい
function hasJoyoyaku($a)
{
    return (isset($a['input_9']) && (int)$a['input_9'] === 1);
}

// input_7 = 2:脂質の異常
function isKoshikesho(Array $a)
{
    return (isset($a['input_7']) && in_array(2, $a['input_7']));
}

// input_7 = 3:血圧の異常
// input_11 = 2:血圧の薬
function isKoketsuatsu(Array $a)
{
    $ketsuatsu_ijo    = (isset($a['input_7']) && in_array(3, $a['input_7']));
    $ketsuatsu_kusuri = (isset($a['input_11']) && in_array(2, $a['input_11']));
    return ($ketsuatsu_ijo && $ketsuatsu_kusuri);
}


