<?php
    $lmd->invokeModule('common.head', array(
        'title' => SITE_NAME,
    ));
?>

<style type="text/css">
dl#qlist dd ul li input {
    float: none;
}
.checklist input {
    float: none;
}
li label {
    display: inline-block;
    vertical-align: middle;
}
li label.disease_name {
    width: 290px;
}
</style>

<div id="wrap">
  <!-- section class="step_number"><img src="_shared/images/step_02.png"></section -->
  <h2 id="___c_lead" class="section_label">気になる症状について教えてください。<br>
    <span class="medium_red disuse_doctor">※最大３つまで選んでください。</span></h2>
</div>
<form id="step<?php echo $step ?>" name="step<?php echo $step ?>" method="post" action="">
<input type="hidden" name="next_step" value="">

  <dl id="qlist">
    <dt>気になる症状</dt>
    <dd>

    <?php $idx = $row = 1; $tmp = $items; foreach($items as $v): next($tmp); ?>

    <?php if ($idx % 3 === 1): ?>
        <ul class="checklist">
            <?php if($row % 2 === 0): ?>
            <li>
            <?php else: ?>
            <li class="li-odd">
            <?php endif; ?>
    <?php endif; ?>

            <?php 
                $checked = in_array($v['DiseaseID'], $orig_answers) ? ' checked="checked"' : '';
                if ($v['DiseaseID'] == FEVER_ID && ($nowtemp >= FEVER_CHECK_TEMP || $maxtemp >= FEVER_CHECK_TEMP)) {
                    // 現在の発熱、一番高い発熱が FEVER_CHECK_TEMP 以上で、気になる症状⇒「発熱」にチェックをいれる
                    $checked = ' checked="checked"';
                }
            ?>

            <input type="checkbox" 
                name="step3[]" 
                value="<?php echo $v['DiseaseID'] ?>"
                OrgFlag="<?php echo $v['OrgFlag'] ?>"
                id="item<?php echo $idx ?>" 
            <?php echo $checked ?>>

            <label class="disease_name" for="item<?php echo $idx ?>"><?php echo $v['DiseaseName'] ?></label>

    <?php if ($idx % 3 === 0 || current($tmp) === false): ?>
            </li>
        </ul>
    <?php ++$row; endif; ?>

    <?php ++$idx; endforeach; ?>

        <ul class="checklist">
        <!-- p style="padding-left:10px">その他</p -->
        <?php if($row % 2 === 0): ?>
            <li>
        <?php else: ?>
            <li class="li-odd">
        <?php endif; ?>
        <input type="checkbox" name="s3_other_disease_flg" value="1" id="item_s3_disease_other_flg"<?php echo $s3_other_disease_flg ? ' checked' : '' ?>>
        <label for="item_s3_disease_other_flg" id="item_s3_disease_other_flg">その他</label>
        <input type="text" name="s3_other_disease" value="<?php echo $s3_other_disease ?>" style="width:500px">
        </li>
        </ul>

        <ul class="checklist">
        <?php ++$row; if($row % 2 === 0): ?>
            <li>
        <?php else: ?>
            <li class="li-odd">
        <?php endif; ?>
        <input type="checkbox" name="s3_no_disease_flg" value="1" id="item_s3_no_disease_flg"<?php echo $isNotShojo ? ' checked' : '' ?>>
        <label for="item_s3_no_disease_flg">特に気になる症状はない</label>
        </li>
        </ul>

        <ul class="checklist">
        <?php ++$row; if($row % 2 === 0): ?>
            <li>
        <?php else: ?>
            <li class="li-odd">
        <?php endif; ?>
        <div>一番気になる症状</div>
        <select name="primaryShojo"></select>
        </li>
        </ul>

    </dd>
  </dl>

<p class="next">
<input type="hidden" name="answer_id" value="<?php echo $_answer_id ?>">
<input type="submit" name="next" value="次に進む" alt="次に進む">
</p>

</form>

<!--
<form method="post" action="<?php echo WEB_ROOT ?>/step<?php echo $prev_step ?>">
<input type="hidden" name="answer_id" value="<?php echo $_answer_id ?>">
<p class="back"><input type="submit" name="back" value="前のページに戻る"></p>
</form>
-->
<p class="back"><input type="button" value="戻る" onClick="history.back()"></p>

<?php 
    if (_isDoctor()) {
        $lmd->invokeModule('doctor.home_button');
    }
?>



<script type="text/javascript">
$(function(){

    highlightCheckbox();
    initPrimaryShojoOption();
    behaveAs_other_disease();

    <?php if(_isDoctor()): ?>
        onFocusCheckbox('<?php echo $primaryShojo ?>');
    <?php else : ?>
        onFocusCheckbox();
    <?php endif; ?>

    $("[name='next']").click(function(){
        if ( ! $('input:checkbox:checked').length) {
            alert('最低１つは選択してください。');
            return false;
        }

        if ( ! $("[name='s3_no_disease_flg']:checked").length) {
            // 「特に気になる症状はない」以外！
            if ($("[name='primaryShojo']").val() === '') {
                alert('「一番気になる症状」を選択してください。');
                return false;
            }
        }

        // デフォルト
        $('#step3').attr('action', '<?php echo WEB_ROOT ?>/step31');
        $("[name='next_step']").val(31);

        // 「特に気になる症状はない」を選択
        if ($("[name='s3_no_disease_flg']:checked").length) {
            $('#step3').attr('action', '<?php echo WEB_ROOT ?>/step41');
            $("[name='next_step']").val(41);
            $('form').append('<input type="hidden" name="isNotShojo" value="1">');

            return true;
        }

        // 「その他」のみを選択
        if ($('input:checkbox:checked').length === 1 && $("[name='s3_other_disease_flg']:checked").length) {
            $('#step3').attr('action', '<?php echo WEB_ROOT ?>/step41');
            $("[name='next_step']").val(41);
            $('form').append('<input type="hidden" name="isNotShojo" value="1">');

            return true;
        }

        // 選択項目に「OrgFlag=1」が含まれていない場合
        var $OrgFlag = false;
        $('input:checkbox:checked').each(function(){
            if ($(this).attr('OrgFlag') == 1) {
                $OrgFlag = true;
                return false; // break;
            }
        });
        if ( ! $OrgFlag) {
            $('#step3').attr('action', '<?php echo WEB_ROOT ?>/step41');
            $("[name='next_step']").val(41);
        }

        return true;
    });

    $('input:checkbox').click(function(){
        if ($("[name='s3_no_disease_flg']:checked").length) {
            // 特に気になる症状はない
            $('input:checkbox').attr('checked', false);
            $(this).attr('checked', true);
            $("[name='s3_other_disease']").val('');
        }

        if ($('input:checkbox:checked').length > 3) {
            if ($("[name='s3_other_disease_flg']:checked").length) {
                // その他
                if ($('input:checkbox:checked').length === 4) {
                    onFocusCheckbox();
                    return;
                }
            }
            $(this).attr('checked', false);
            alert('チェックできるのは最大３つまでです');
        }

        onFocusCheckbox();
    });

    $('#item_s3_disease_other_flg').click(function(){
        behaveAs_other_disease();
    });
});

function onFocusCheckbox(def)
{

    initPrimaryShojoOption();

    $('input:checkbox').each(function(){
        var label = $(this).next();
        if ($(this).attr('checked')) {
            label.css({'color':'<?php echo PATIENT_CHECKED_COLOR ?>'});
            if (def && def == label.text()) {
                $("[name='primaryShojo']").append('<option value="'+label.text()+'" selected>'+label.text()+'</option>');
            } else {
                $("[name='primaryShojo']").append('<option value="'+label.text()+'">'+label.text()+'</option>');
            }
        } else {
            label.css({'color':'#000000'});
        }
    });

    if ($("[name='s3_no_disease_flg']:checked").length) {
        // 特に気になる症状はない
        initPrimaryShojoOption();
    }
}

function initPrimaryShojoOption()
{
    $("[name='primaryShojo']").children().remove();
    $("[name='primaryShojo']").append('<option value="">--</option>');
    if ($('#item_s3_disease_other_flg').attr('checked') == false) {
        $("[name='s3_other_disease']").val('');
        $("[name='s3_other_disease']").hide();
    }
}

function behaveAs_other_disease()
{
    if ($('#item_s3_disease_other_flg').attr('checked')) {
        $("[name='s3_other_disease']").show();
    } else {
        $("[name='s3_other_disease']").val('');
        $("[name='s3_other_disease']").hide();
    }
}
</script>



<?php
    $lmd->invokeModule('common.foot');
?>
