<?php
    $lmd->invokeModule('common.head', array(
        'title' => SITE_NAME,
    ));
?>




<div id="wrap">
  <!-- section class="step_number"><img src="_shared/images/step_02.png"></section -->
  <h2 id="___c_lead" class="section_label">気になる症状について教えてください。<br>
    <span class="medium_red disuse_doctor">※最大３つまで選んでください。</span></h2>
</div>
<form id="step<?php echo $step ?>" name="step<?php echo $step ?>" method="post">
<input type="hidden" name="next_step" value="">

  <dl id="qlist">
    <dt>気になる症状</dt>
    <dd>

    <?php $idx = 1; $prev_cate = ''; foreach($items as $v): $cate = $v['DisCatName']; ?>

      <ul class="checklist">

        <?php if($prev_cate !== $cate): ?>
            <p style="font-weight:bold; padding-left:10px"><?php echo $cate ?></p>
        <?php endif; ?>

        <?php if($idx % 2 === 0): ?>
        <li>
        <?php else: ?>
        <li class="li-odd">
        <?php endif; ?>

            <?php 
                $checked = in_array($v['DiseaseID'], $orig_answers) ? ' checked="checked"' : '';
            ?>

            <input type="checkbox" 
                name="step3[]" 
                value="<?php echo $v['DiseaseID'] ?>"
                id="item<?php echo $idx ?>" 
            <?php echo $checked ?>>

            <label for="item<?php echo $idx ?>"><?php echo $v['DiseaseName'] ?></label>

        </li>
      </ul>

    <?php ++$idx; $prev_cate = $cate; endforeach; ?>

        <ul class="checklist">
        <p style="font-weight:bold; padding-left:10px">その他</p>
        <?php if($idx % 2 === 0): ?>
            <li>
        <?php else: ?>
            <li class="li-odd">
        <?php endif; ?>
        <input type="checkbox" name="s3_other_disease_flg" value="1" id="item_s3_disease_other_flg"<?php echo $s3_other_disease_flg ? ' checked' : '' ?>>
        <label for="item_s3_disease_other_flg">その他</label>
        <input type="text" name="s3_other_disease" value="<?php echo $s3_other_disease ?>" style="width:400px">
        </li>
        </ul>

        <ul class="checklist">
        <?php ++$idx; if($idx % 2 === 0): ?>
            <li>
        <?php else: ?>
            <li class="li-odd">
        <?php endif; ?>
        <hr>
        <input type="checkbox" name="s3_no_disease_flg" value="1" id="item_s3_no_disease_flg"<?php echo $isNotShojo ? ' checked' : '' ?>>
        <label for="item_s3_no_disease_flg">特に気になる症状はない</label>
        <hr>
        </li>
        </ul>

        <ul class="checklist">
        <?php ++$idx; if($idx % 2 === 0): ?>
            <li>
        <?php else: ?>
            <li class="li-odd">
        <?php endif; ?>
        <div>一番気になる症状</div>
        <select name="primaryShojo"></select>
        </li>
        </ul>

    </dd>
  </dl>

<p class="next">
<input type="hidden" name="answer_id" value="<?php echo $_answer_id ?>">
<input type="submit" name="next" value="次に進む" alt="次に進む">
</p>

<?php if($enableFever): ?>
    <input type="hidden" name="enableFever" value="1">
<?php endif; ?>

</form>

<!--
<form method="post" action="<?php echo WEB_ROOT ?>/step<?php echo $prev_step ?>">
<input type="hidden" name="answer_id" value="<?php echo $_answer_id ?>">
<p class="back"><input type="submit" name="back" value="前のページに戻る"></p>
</form>
-->
<p class="back"><input type="button" value="戻る" onClick="history.back()"></p>

<?php 
    if (_isDoctor()) {
        $lmd->invokeModule('doctor.home_button');
    }
?>



<script type="text/javascript">
$(function(){

    highlightCheckbox();
    initPrimaryShojoOption('');
    behaveAs_other_disease();

    <?php if(_isDoctor()): ?>
        onFocusCheckbox('<?php echo $primaryShojo ?>');
    <?php endif; ?>

    $("[name='next']").click(function(){
        if ($('select[name="primaryShojo"]').attr('value') != '発熱' && ! $('input:checkbox:checked').length) {
            alert('最低１つは選択してください。');
            return false;
        }

        if ( ! $("[name='s3_no_disease_flg']:checked").length) {
            // 「特に気になる症状はない」以外！
            if ($("[name='primaryShojo']").val() === '') {
                alert('「一番気になる症状」を選択してください。');
                return false;
            }
        }

        // デフォルト
        $('#step3').attr('action', '<?php echo WEB_ROOT ?>/step31');
        $("[name='next_step']").val(31);

        // 「特に気になる症状はない」を選択
        if ($("[name='s3_no_disease_flg']:checked").length) {
            $('#step3').attr('action', '<?php echo WEB_ROOT ?>/step<?php echo $next_step ?>');
            $("[name='next_step']").val(4);
            $('form').append('<input type="hidden" name="isNotShojo" value="1">');
        }

        // 「その他」のみを選択
        if ($('input:checkbox:checked').length === 1 && $("[name='s3_other_disease_flg']:checked").length) {
            $('#step3').attr('action', '<?php echo WEB_ROOT ?>/step<?php echo $next_step ?>');
            $("[name='next_step']").val(4);
            $('form').append('<input type="hidden" name="isNotShojo" value="1">');
        }
        return true;
    });

    $('input:checkbox').click(function(){
        if ($("[name='s3_no_disease_flg']:checked").length) {
            // 特に気になる症状はない
            $('input:checkbox').attr('checked', false);
            $(this).attr('checked', true);
            $("[name='s3_other_disease']").val('');
        }

        if ($('input:checkbox:checked').length > 3) {
            if ($("[name='s3_other_disease_flg']:checked").length) {
                // その他
                if ($('input:checkbox:checked').length === 4) {
                    onFocusCheckbox();
                    return;
                }
            }
            $(this).attr('checked', false);
            alert('チェックできるのは最大３つまでです');
        }

        onFocusCheckbox();
    });

    $('#item_s3_disease_other_flg').click(function(){
        behaveAs_other_disease();
    });
});

function onFocusCheckbox(def)
{

    initPrimaryShojoOption(def);

    $('input:checkbox').each(function(){
        var label = $(this).next();
        if ($(this).attr('checked')) {
            label.css({'color':'<?php echo PATIENT_CHECKED_COLOR ?>'});
            if (def && def == label.text()) {
                $("[name='primaryShojo']").append('<option value="'+label.text()+'" selected>'+label.text()+'</option>');
            } else {
                $("[name='primaryShojo']").append('<option value="'+label.text()+'">'+label.text()+'</option>');
            }
        } else {
            label.css({'color':'#000000'});
        }
    });

    if ($("[name='s3_no_disease_flg']:checked").length) {
        // 特に気になる症状はない
        initPrimaryShojoOption('');
    }
}

function initPrimaryShojoOption(def)
{
    $("[name='primaryShojo']").children().remove();
    $("[name='primaryShojo']").append('<option value="">--</option>');
    <?php if($enableFever): ?>
        if (def == '発熱') {
            $("[name='primaryShojo']").append('<option value="発熱" selected>発熱</option>');
        } else {
            $("[name='primaryShojo']").append('<option value="発熱">発熱</option>');
        }
    <?php endif; ?>
}

function behaveAs_other_disease()
{
    if ($('#item_s3_disease_other_flg').attr('checked')) {
        $("[name='s3_other_disease']").removeAttr('disabled');
    } else {
        $("[name='s3_other_disease']").val('');
        $("[name='s3_other_disease']").attr('disabled', 'disabled');
    }
}
</script>



<?php
    $lmd->invokeModule('common.foot');
?>
