<?php
/**
 * step31
 */
$prev_step = 3;
$step      = 31;
$next_step = _isChild() ? 451 : 41;
//if (Answer::get(2, 'isGaisho') || Answer::get(2, 'isGoin')) {
//    // 外傷、誤飲フラグがあれば、遷移先を step* とする
//    $next_step = '*'; //暫定
//}

if (_isDoctor() || _isAgent()) {
    // ドクター側「修正」と代理入力は step41:16歳以上の既往 に遷移させない
    $next_step = 4;
}

Answer::removeForwardAnswer($step);

if ($lmd->hasHttpPost('back')) {
    // do nothing.
} elseif ((int)$lmd->httpPost('next_step') === $step) {
    if ($prev_step === 3) {
        Answer::step3_answer2session($lmd);
    }
} else {
    _invalidRequest();
}

// P.34 「全身状態用性年齢区分を抽出」で求めたCategoryID値は絶対に使用しない様に十分注意する事。
$category_id = Answer::get(3, 'shojo_category_id');

$qa = Factory::load('App/QA')->getInstance();
$diseases_arr = $qa->step31_getDiseaseArr(Answer::get($prev_step, 'answers', array()));
$diseases  = $qa->step31_getDisease($diseases_arr, $category_id);
$questions = $qa->step31_getQestions($diseases_arr, $category_id);
$answers   = $qa->step31_getAnswers($questions, $category_id);
$diseases_with_when = $qa->step31_checkDiseaseIdWithWhenFlag($diseases_arr, $category_id);
$questions_with_when = $qa->step31_getRawQuestions($diseases_arr, $category_id);
$answers_with_when = $qa->step31_getRawAnswers($questions, $category_id);

$fever_diseases  = array();
$fever_questions = array();
$fever_answers   = array();
$fever_when = '';
if ($lmd->httpPost('enableFever')) {
    $fever_diseases[FEVER_ID] = $qa->step31_getFiverDisease($category_id, FEVER_ID);
    $fever_questions = $qa->step31_getFiverQestions($category_id, FEVER_ID);
    $fever_answers   = $qa->step31_getAnswers($fever_questions, $category_id);
    $diseases_with_when  = $diseases_with_when + $qa->step31_checkDiseaseIdWithWhenFlag($fever_diseases[FEVER_ID], $category_id);
    $questions_with_when = $questions_with_when + $qa->step31_getRawQuestions($fever_diseases[FEVER_ID], $category_id);
    $answers_with_when   = $answers_with_when + $qa->step31_getRawAnswers($fever_questions, $category_id);
    $fever_when = Answer::get(1, 'fromtemp');
}
$lmd->setResponse(array(
    'prev_step' => $prev_step, 
    'step'      => $step, 
    'next_step' => $next_step, 
    'diseases'  => $diseases, 
    'questions' => $questions, 
    'answers'   => $answers, 

    'fever_diseases'  => $fever_diseases, 
    'fever_questions' => $fever_questions, 
    'fever_answers'   => $fever_answers, 
    'fever_when'      => $fever_when === '' ? 'none' : $fever_when, 

    'diseases_with_when'  => $diseases_with_when,  // いつ頃フラグを含む症状IDリスト
    'questions_with_when' => $questions_with_when, // いつ頃フラグを含む質問リスト
    'answers_with_when'   => $answers_with_when,   // いつ頃フラグを含む回答リスト
));
//_Ve($diseases, $questions, $answers, $fever_diseases, $fever_questions, fever_answers);

$when = _getWhen(Answer::getOriginal('step31_when'));

// for Doctor.
$orig_answers = explode(',', Answer::getOriginal("step{$step}_answers", null, ''));
$orig_fever_answers = explode(',', Answer::getOriginal("fever_answers", null, ''));
$lmd->setResponse(array(
    'orig_answers' => array_merge($orig_answers, $orig_fever_answers),
    'when' => $when,
));

// child | adult
if (_isChild()) {
    $lmd->setPrep("step{$step}.child");
} else {
    $lmd->setPrep("step{$step}.adult");
}
