<?php
/**
 * step451: 小児(16未満)既往歴1
 */

$prev_step = $lmd->httpPost('isNotShojo') ? 3 : 31;
if ($lmd->httpPost('isKinkyu')) {
    // 緊急フロー
    $prev_step = 2; // 前画面は全身状態
}
$step      = 451;
$next_step = 452;

Answer::removeForwardAnswer($step);

if ($lmd->hasHttpPost('back')) {
    // do nothing.
} elseif (_isAgent()) {
    // 代理入力
    $lmd->redirect(APP_ROOT . '/step5');
} elseif ((int)$lmd->httpPost('next_step') === $step) {
    if ($prev_step === 2) {
        Answer::step2_answer2session($lmd);
    } elseif ($prev_step === 3) {
        Answer::step3_answer2session($lmd);
    } elseif ($prev_step === 31) {
        $answers = $when = array();
        foreach ($lmd->httpPost("step{$prev_step}", array()) as $val) foreach ($val as $v) {
            $answers[] = $v;
        }
        foreach ($lmd->httpPost('when', array()) as $k => $v) {
            $when[] = "{$k}:{$v}";
        }
        Answer::set($prev_step, array('answers' => $answers));
        Answer::set($prev_step, array('when' => $when));

        if ($lmd->hasHttpPost('fever')) {
            foreach ($lmd->httpPost('fever') as $v) {
                $fever_answers[] = $v;
            }
            Answer::set($prev_step, array('fever_answers' => $fever_answers));
        }
    }
} else {
    // 矛盾が生じるため、不要。
    //_invalidRequest();
}

$lmd->setResponse(array(
    'prev_step' => $prev_step, 
    'step'      => $step, 
    'next_step' => $next_step, 
));



if (_isDoctor()) {
    // ドクター側で「修正」を通してこのステップ(既往)に来た場合は次のステップ(step5)に強制リダイレクト
    //  ※パラメーター「fh_id(family_history_id)」が存在しない場合は「修正」からの遷移と見なす
    if ( ! $lmd->hasHttpGet('fh_id')) {
        $lmd->redirect(APP_ROOT . '/step5');
    }
}


if (_isDoctor() && $_answer_code) {
    // ドクター側からの家族歴修正
    list($card_number, ) = explode('-', $_answer_code);
} else {
    // 患者側からの通常遷移
    $card_number = Answer::get(0, 'card_number');
}

$res = array();
$reg_date = '';
if ($card_number) {
    $dao = Factory::load(_isChild() ? 'DB/DAO_kiou_child' : 'DB/DAO_kiou_adult')->getInstance();
    $res = $dao->fetchNewest_BY_card_number($card_number);
    if ($res) {
        list($reg_date, ) = explode(' ', $res['reg_datetime']);
        $reg_date = str_replace('-', '/', $reg_date);
    }
}



$lmd->setResponse(array(
    'is_repeater' => $res ? true : false,
    'reg_date' => $reg_date,
    'v' => $res,
    'card_number' => $card_number,
    'isKinkyu' => $lmd->httpPost('isKinkyu') ? 1 : 0,
));
$lmd->setResponse(array(
    'q17_disease'    => isset($res['q17_disease']) ? $res['q17_disease'] : '',
    'q17_other_text' => isset($res['q17_other_text']) ? $res['q17_other_text'] : '',
), Lambda::INSANITATION);
