<?php
/**
 * step452: 小児(16未満)既往歴2
 */
$prev_step = 451;
$step      = 452;
$next_step = 453;

Answer::removeForwardAnswer($step);

if ($lmd->hasHttpPost('back')) {
    // do nothing.
} elseif ((int)$lmd->httpPost('next_step') === $step) {
    $arr = array();
    foreach ($lmd->httpPost() as $k => $v) {
        if (preg_match('/^(q[1-9]+|status|reason)/', $k)) {
            $arr[$k] = $v;
        }
    }

    Answer::set($prev_step, $arr);

    // 前ページに戻った時に、Javascript の alert を実行させない
    Answer::set(0, array('noMoreKiouAlert' => true));

    if ($lmd->httpPost('isKinkyu')) {
        // 緊急フローの時は、step5 へ
        $lmd->redirect(APP_ROOT . '/step5');
    } 
} else {
    _invalidRequest();
}

$lmd->setResponse(array(
    'prev_step' => $prev_step, 
    'step'      => $step, 
    'next_step' => $next_step, 
));

$card_number = Answer::get(0, 'card_number');
$dao = Factory::load(_isChild() ? 'DB/DAO_kiou_child' : 'DB/DAO_kiou_adult')->getInstance();
$res = $dao->fetchNewest_BY_card_number($card_number);

$lmd->setResponse(array(
    'v' => $res,
));
