<?php

class KiouAdult
{
    private static function getDataPath()
    {
        return LAMBDA_BASEDIR.'/resources/adult.kiou.dat.tsv';
    }

    public static function getOptions($idx)
    {
        $buf = array();
        foreach (file(self::getDataPath()) as $v) {
            $v = trim($v);
            if ( ! $v) continue;
            list($id, $if_contain, $act_gid, $gid, $cid, $ques_text, $ans_type, $ques_suffix, $ans_option, $sort1, $pos1, $sort2, $pos2, $sort3, $pos3, $sort4, $pos4) = explode("\t", $v);
            if ($id === 'id') continue; // label行をスキップ

            if ((int)$id === (int)$idx) {
                foreach (explode('|', $ans_option) as $vv) {
                    list($key, $val) = explode(':', $vv);
                    $buf[$key] = $val;
                }
                return $buf;
            }
        }
        return $buf;
    }

    public static function getData($sort, $pos_use, $pos_val)
    {
        $buf = array();
        foreach (file(self::getDataPath()) as $v) {
            $v = trim($v);
            if ( ! $v) continue;
            list($id, $if_contain, $act_gid, $gid, $cid, $ques_text, $ans_type, $ques_suffix, $ans_option, $sort1, $pos1, $sort2, $pos2, $sort3, $pos3, $sort4, $pos4) = explode("\t", $v);
            if ($id === 'id') continue; // label行をスキップ

            if ( ! $$sort) continue;

            if ((int)$$pos_use !== (int)$pos_val) continue;

            $buf[$$sort] = array(
                'id' => $id, 
                'if_contain' => $if_contain, 
                'act_gid' => $act_gid, 
                'gid' => $gid, 
                'cid' => $cid, 
                'ques_text' => $ques_text, 
                'ans_type' => $ans_type, 
                'ques_suffix' => $ques_suffix, 
                'ans_option' => $ans_option, 
            );
        }

        ksort($buf);
        $buf = array_values($buf);

        return $buf;
    }

    public static function getDefault($card_number)
    {
        $def = array();
        $reg_date = '';
        if ($card_number) {
            $dao = Factory::load('DB/DAO_kiou_adult')->getInstance();
            $res = $dao->fetchNewest_BY_card_number($card_number);
            if ($res) {
                $def = unserialize($res['serialized_data']);
                list($reg_date, ) = explode(' ', $res['reg_datetime']);
                $reg_date = str_replace('-', '/', $reg_date);
            }
        }

        return array($def, $reg_date);
    }

    /**
     * step242で選択された病名
     */
    public static function getStep242Diseases(Array $a)
    {
        // input_42: これまでに以下に当てはまる病気（あるいはその他の大きな病気）を指摘されたことがありますか

        $buf = array();
        if (isset($a['input_42']) && is_array($a['input_42']) && $a['input_42']) {
            $diseases = self::getOptions(42);
            foreach ($diseases as $k => $v) {
                if ($v === 'その他') {
                    if (isset($a['input_43']) && $a['input_43'] !== '') $buf[] = $a['input_43']; //その他(四肢不自由がある）
                    if (isset($a['input_44']) && $a['input_44'] !== '') $buf[] = $a['input_44']; //その他（自由記入）
                    continue;
                }
                if (in_array($k, $a['input_42'])) $buf[] = $v;
            }
        }
        return join("\t", $buf);
    }



}


