<?php
/* vim:se et ts=4 sw=4 sts=4 fdm=marker: */
/**
 * Log
 * 
 * LICENSE: 
 * 
 * @copyright 2011 Topazos, Inc.
 * @license http://www.topazos.co.jp/license/3_0.txt PHP License 3.0
 * @version CVS: $Id: $
 * @link http://www.topazos.co.jp/package/PackageName
 * @since File available since Release 1.0.0
 */

/**
 * Sample Code
 * 
 * $log = new Log;
 * $log->put('Test Error', 'This is Test Error....');
 * 
 */

/**
 * Log Class
 */
class Log
{

    private $_date;
    private $_dir  = '/logs/log_error';
    private $_file = '%04d%02d%02d.log';
    private $_path;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->_date = date('Y-m-d H:i:s');
        sscanf($this->_date, "%04d-%02d-%02d %02d:%02d:%02d", $y,$m,$d,$h,$i,$s);
        $this->_file = sprintf($this->_file, $y,$m,$d);
        $this->_dir = dirname(dirname(dirname(__FILE__))) . $this->_dir;
        $this->_path = $this->_dir . '/' . $this->_file;
        if (! is_file($this->_path)) {
            touch($this->_path);
            chmod($this->_path, 0666);
        }
    }

    /**
     * Put
     */
    public function put($name, $msg)
    {
        $name = str_replace(' ', '', $name);
        $msg = sprintf("[%s] %s %s", date('Y-m-d H:i:s'), $name, $msg);
        error_log($msg . "\n", 3, $this->_path);
    }

}

?>
