<?php
/* vim:se et ts=4 sw=4 sts=4 fdm=marker: */
/**
 * Parts for External Injury
 * 
 * LICENSE: 
 * 
 * @copyright 2011 Topazos, Inc.
 * @license http://www.topazos.co.jp/license/3_0.txt PHP License 3.0
 * @version CVS: $Id: $
 * @link http://www.topazos.co.jp/package/PackageName
 * @since File available since Release 1.0.0
 */

/**
 * Parts Class
 */
class Parts
{

    /**
     * Variables.
     */
    public $parts = array();
    public $area  = array();
    public $map   = array(
                    // external_injury_type_id => external_injury_question_id
                    1 => 1,   // 打った
                    2 => 13,  // 切った
                    3 => 20,  // 挟んだ／つぶした
                    4 => 29,  // 捻った
                    5 => 33,  // 人／動物に噛まれた
                    6 => 40,  // 虫に刺された
                    7 => 47,  // 擦った
                    8 => 51,  // 刺さった
                    9 => 56,  // 撃たれた
                    10 => 60, // やけどした
                    11 => 71, // かぶれた／ただれた
                    12 => 80, // 絞められた
                    //13 => , // 誤飲／誤嚥した
                    14 => 92, // 異物が入った
                    15 => 96, // 自転車の車輪に巻き込まれた
                    //16 => , // 鼻血が出た
                    //17 => , // 溺れた
                    18 => 109, // 交通事故にあった(高エネルギー外傷)
                    );

    /**
     * Constructor
     */
    public function __construct()
    {
        /**
         * [TODO]
         * ハードコーディングでなく、
         * テーブル：external_injury_group から取得する
         */
        $this->area[] = array('gid' => 1, 'name' => '頭部');
        $this->area[] = array('gid' => 2, 'name' => '体幹');
        $this->area[] = array('gid' => 3, 'name' => '四肢');

        /**
         * [TODO]
         * ハードコーディングでなく、
         * テーブル：external_injury_parts から取得する
         */
        $this->parts[] = array('gid' => 1, 'id' => 1, 'name' => '頭部');
        $this->parts[] = array('gid' => 1, 'id' => 2, 'name' => '顔面');
        $this->parts[] = array('gid' => 1, 'id' => 3, 'name' => '鼻');
        $this->parts[] = array('gid' => 1, 'id' => 4, 'name' => '顎');
        $this->parts[] = array('gid' => 1, 'id' => 5, 'name' => '口腔内');
        $this->parts[] = array('gid' => 1, 'id' => 6, 'name' => '頚部');
        $this->parts[] = array('gid' => 1, 'id' => 7, 'name' => '耳');
        $this->parts[] = array('gid' => 1, 'id' => 8, 'name' => '目');
        $this->parts[] = array('gid' => 1, 'id' => 9, 'name' => '口');
        $this->parts[] = array('gid' => 2, 'id' => 10, 'name' => '胸部');
        $this->parts[] = array('gid' => 2, 'id' => 11, 'name' => '腹部');
        $this->parts[] = array('gid' => 2, 'id' => 12, 'name' => '骨盤部');
        $this->parts[] = array('gid' => 2, 'id' => 13, 'name' => '背部');
        $this->parts[] = array('gid' => 2, 'id' => 14, 'name' => '会陰部');
        $this->parts[] = array('gid' => 3, 'id' => 15, 'name' => '大腿部');
        $this->parts[] = array('gid' => 3, 'id' => 16, 'name' => '下腿部');
        $this->parts[] = array('gid' => 3, 'id' => 17, 'name' => '足部');
        $this->parts[] = array('gid' => 3, 'id' => 18, 'name' => '上腕');
        $this->parts[] = array('gid' => 3, 'id' => 19, 'name' => '前腕');
        $this->parts[] = array('gid' => 3, 'id' => 20, 'name' => '手部');
    }

    /**
     * Get Serialized Parts Data
     * @param array $answers : step233_answers
     */
    public function getSerializedPartsData($answers)
    {
        $result = array();
        foreach ($this->map as $type_id => $quest_id) {
            if (! empty($answers[$quest_id])) {
                if ($this->map[18] == $quest_id) {
                    // 交通外傷(高エネルギー外傷)...
                    $result[$type_id] = $answers[$quest_id];
                } else {
                    // 外傷部位...
                    foreach ($answers[$quest_id] as $parts_name => $answer_id) {
                            $result[$type_id][] = $this->getPartsId($parts_name);
                    }
                }
            }
        }
        $result = serialize($result);
        return $result;
    }

    /**
     * Get Group Data by Id
     * @param integer $gid : Group Id
     */
    public function getGroupDataById($gid)
    {
        $result = FALSE;
        foreach ($this->area as $val) {
            if ($val['gid'] == $gid) {
                $result = $val;
                break;
            }
        }
        return $result;
    }

    /**
     * Get Parts Data by Id
     * @param integer $id : Parts Id
     */
    public function getPartsDataById($id)
    {
        $result = FALSE;
        foreach ($this->parts as $val) {
            if ($val['id'] == $id) {
                $result = $val;
                break;
            }
        }
        if ($result !== FALSE) {
            $group = $this->getGroupDataById($result['gid']);
            $result['gname'] = $group['name'];
        }
        return $result;
    }

    /**
     * Get Parts Data by Id
     * @param array $id : List of Parts Id
     */
    public function getPartsListById($id)
    {
        $result = FALSE;
        foreach ((array)$id as $i) {
            if ($result === FALSE) { $result = array(); }
            $result[] = $this->getPartsDataById($i);
        }
        return $result;
    }

    /**
     * Get Parts Data by Name
     * @param array $name : List of Parts Name
     */
    public function getPartsListByName($name)
    {
        $result = FALSE;
        foreach ((array)$name as $n) {
            if ($result === FALSE) { $result = array(); }
            $result[] = $this->getPartsDataByName($n);
        }
        return $result;
    }

    /**
     * Get Parts Data by Name
     * @param string $name : Parts Name
     */
    public function getPartsDataByName($name)
    {
        $result = FALSE;
        foreach ($this->parts as $val) {
            if ($val['name'] == $name) {
                $result = $val;
                break;
            }
        }
        if ($result !== FALSE) {
            $group = $this->getGroupDataById($result['gid']);
            $result['gname'] = $group['name'];
        }
        return $result;
    }

    /**
     * Get Parts Id
     * @param string $name : Parts Name
     */
    public function getPartsId($name)
    {
        $data = $this->getPartsDataByName($name);
        $result = ($data !== FALSE ? $data['id'] : FALSE);
        return $result;
    }

}

?>
