<?php
/**
 * データアクセスオブジェクト 基底クラス
 *
 * @package Lambda/lib/DB/DAO
 * @author  rooth
 * @version 0.0.1
 *
 * PHP versions 5
 */

require_once dirname(__FILE__).'/PDO_MySQL_Manipulator.php';

class DAO_Base
{
    protected $manipulator;

    public function __construct()
    {
        if ( ! $this->manipulator) {
            $this->manipulator = new PDO_MySQL_Manipulator(DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_ENCODING);
        }
    }

    public function foundRows()
    {
        return $this->manipulator->foundRows();
    }

    public function lastInsertId($name = NULL)
    {
        return $this->manipulator->lastInsertId($name);
    }

    public function begin()
    {
        return $this->manipulator->begin();
    }

    public function commit()
    {
        return $this->manipulator->commit();
    }

    public function rollback()
    {
        return $this->manipulator->rollBack();
    }

    /**
     * PDO::prepare メソッドを介さずに 生のクエリ を発行する。
     *
     * @param  str $type クエリタイプ (fetchColum|fetch|fechAll|execute)
     * @param  str $sql  クエリ
     * @return mixed
     * @access public
     */
    public function rawQuery($type, $sql)
    {
        return $this->manipulator->rawQuery($type, $sql);
    }

    /**
     *<pre>
     *
     * レコード存在チェックを行う (※. カラム型が boolean の値の検証はできません)
     *
     *   レコードが存在しない場合、PDOの参照系メソッドは以下を返却する。
     *
     *    fetchColumn: false
     *    fetch:       false
     *    fetchAll:    array()
     *
     *   これらの値を検証し、レコードの存在チェックを行う。
     *
     *</pre>
     *
     * @param  mixed $v 検証対象の変数
     * @return bool
     * @access public
     */
    public function hasRecord($v)
    {
        if (is_array($v)) {
            return (count($v) !== 0);
        } else {
            return ($v !== false);
        }
    }



    /** *******************************************************
     * 参照系
     ******************************************************* */
    public function fetchAll($offset = '', $limit = '')
    {
        $this->manipulator->select('SQL_CALC_FOUND_ROWS * ');
        $this->manipulator->orderBy(array(
            $this->pkey => 'DESC',
        ));
        if ($offset !== '' && $limit !== '') {
            $this->manipulator->limit($offset, $limit);
        }
        return $this->manipulator->fetchAll();
    }

    public function fetchAll_DESC($offset = '', $limit = '')
    {
        $this->manipulator->select('SQL_CALC_FOUND_ROWS * ');
        $this->manipulator->orderBy(array(
            $this->pkey => 'DESC',
        ));
        if ($offset !== '' && $limit !== '') {
            $this->manipulator->limit($offset, $limit);
        }
        return $this->manipulator->fetchAll();
    }

    public function fetchAll_ASC($offset = '', $limit = '')
    {
        $this->manipulator->select('SQL_CALC_FOUND_ROWS * ');
        $this->manipulator->orderBy(array(
            $this->pkey => 'ASC',
        ));
        if ($offset !== '' && $limit !== '') {
            $this->manipulator->limit($offset, $limit);
        }
        return $this->manipulator->fetchAll();
    }

    public function fetchAll_BY_ids(Array $ids)
    {
        $this->manipulator->select('SQL_CALC_FOUND_ROWS * ');
        $this->manipulator->where(array(
            $this->pkey => array('IN', $ids)
        ));
        return $this->manipulator->fetchAll();
    }

    public function fetch_BY_id($id)
    {
        $this->manipulator->select('*');
        $this->manipulator->where(array(
            $this->pkey => $id,
        ));
        return $this->manipulator->fetch();
    }



    public function fetchAll_active($offset = '', $limit = '')
    {
        $this->manipulator->select('SQL_CALC_FOUND_ROWS * ');
        $this->manipulator->where(array(
            'active_flg' => 1, 
        ));
        $this->manipulator->orderBy(array(
            $this->pkey => 'DESC',
        ));
        if ($offset !== '' && $limit !== '') {
            $this->manipulator->limit($offset, $limit);
        }
        return $this->manipulator->fetchAll();
    }

    public function fetch_active_BY_id($id)
    {
        $this->manipulator->select(' * ');
        $this->manipulator->where(array(
            $this->pkey => $id, 
            'and', 
            'active_flg' => 1, 
        ));
        return $this->manipulator->fetch();
    }



    /** *******************************************************
     * 更新系
     ******************************************************* */
    public function update_active_flg(Array $ids, $active_flg)
    {
        $this->manipulator->set(array(
            'active_flg'   => $active_flg, 
        ));
        $this->manipulator->where(array(
            $this->pkey => array('IN', $ids)
        ));
        return $this->manipulator->update();
    }

    public function update_display_order($id, $display_order)
    {
        $this->manipulator->set(array(
            'display_order' => $display_order, 
        ));
        $this->manipulator->where(array(
            $this->pkey => $id,
        ));
        return $this->manipulator->update();
    }

    public function delete_BY_ids(Array $ids)
    {
        $this->manipulator->where(array(
            $this->pkey => array('IN', $ids)
        ));
        return $this->manipulator->delete();
    }

    public function delete_BY_id($id)
    {
        $this->manipulator->where(array(
            $this->pkey => $id,
        ));
        return $this->manipulator->delete();
    }



} //-- End of class


