<?php
/**
 * データアクセスオブジェクト
 */

require_once dirname(__FILE__).'/DAO_Base.php';

class DAO_CarteDisRelationTable extends DAO_Base
{
    protected $table = 'CarteDisRelationTable';
    //protected $pkey  = '';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetch_BY_CategoryID_AND_DiseaseID($CategoryID, $DiseaseID)
    {
        $this->manipulator->select(' * ');
        $this->manipulator->where(array(
            'CategoryID' => $CategoryID, 
            'and',
            'DiseaseID' => $DiseaseID, 
            'and',
            'ValidFlag' => 0, 
        ));
        $this->manipulator->orderBy(array(
            'DiseaseID' => 'ASC',
        ));

        return $this->manipulator->fetch();
    }



} //-- End of class


